/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.AbstractCameraAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.VisualAdapter;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Plane;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.PlanarReflector;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import java.nio.DoubleBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanarReflectorAdapter
extends VisualAdapter<PlanarReflector> {
    private AffineMatrix4x4 m_geometryTransformation = AffineMatrix4x4.createNaN();
    private double[] m_reflection = new double[16];
    private double[] m_equation = new double[4];
    private DoubleBuffer m_reflectionBuffer = DoubleBuffer.wrap(this.m_reflection);
    private DoubleBuffer m_equationBuffer = DoubleBuffer.wrap(this.m_equation);

    private void updateGeometryTransformation() {
        Geometry[] sgGeometries = (Geometry[])((PlanarReflector)this.m_element).geometries.getValue();
        if (sgGeometries != null && sgGeometries.length > 0) {
            Geometry sgGeometry = sgGeometries[0];
            sgGeometry.getPlane(this.m_geometryTransformation);
        }
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        super.propertyChanged(property);
        if (property == ((PlanarReflector)this.m_element).geometries) {
            this.updateGeometryTransformation();
        }
    }

    @Override
    public void setup(RenderContext rc) {
    }

    @Override
    public void renderAlphaBlended(RenderContext rc) {
    }

    @Override
    public void renderOpaque(RenderContext rc) {
    }

    public boolean isFacing(AbstractCameraAdapter<? extends AbstractCamera> cameraAdapter) {
        AffineMatrix4x4 m = ((PlanarReflector)this.m_element).getTransformation((ReferenceFrame)((Object)cameraAdapter.m_element));
        return m.orientation.backward.z > 0.0;
    }

    public synchronized void applyReflection(RenderContext rc) {
        AffineMatrix4x4 m = ((PlanarReflector)this.m_element).getAbsoluteTransformation();
        m.multiply(this.m_geometryTransformation);
        Plane plane = new Plane(m);
        plane.getEquation(this.m_equation);
        rc.gl.glClipPlane(12288, this.m_equationBuffer);
        Point3 p = m.translation;
        Vector3 v = new Vector3(-m.orientation.backward.x, -m.orientation.backward.y, -m.orientation.backward.z);
        Matrix4x4 r = new Matrix4x4();
        double p_dot_v = p.x * v.x + p.y * v.y + p.z * v.z;
        r.right.x = 1.0 - 2.0 * v.x * v.x;
        r.up.x = 0.0 - 2.0 * v.x * v.y;
        r.backward.x = 0.0 - 2.0 * v.x * v.z;
        r.translation.x = 2.0 * v.x * p_dot_v;
        r.right.y = 0.0 - 2.0 * v.y * v.x;
        r.up.y = 1.0 - 2.0 * v.y * v.y;
        r.backward.y = 0.0 - 2.0 * v.y * v.z;
        r.translation.y = 2.0 * v.y * p_dot_v;
        r.right.z = 0.0 - 2.0 * v.z * v.x;
        r.up.z = 0.0 - 2.0 * v.z * v.y;
        r.backward.z = 1.0 - 2.0 * v.z * v.z;
        r.translation.z = 2.0 * v.z * p_dot_v;
        r.right.w = 0.0;
        r.up.w = 0.0;
        r.backward.w = 0.0;
        r.translation.w = 1.0;
        r.getAsColumnMajorArray16(this.m_reflection);
        rc.gl.glMultMatrixd(this.m_reflectionBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderStencil(RenderContext rc) {
        rc.gl.glPushMatrix();
        PlanarReflectorAdapter planarReflectorAdapter = this;
        synchronized (planarReflectorAdapter) {
            rc.gl.glMultMatrixd(this.accessAbsoluteTransformationAsBuffer());
        }
        this.actuallyRender(rc);
        rc.gl.glPopMatrix();
    }
}

