/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import com.sun.opengl.util.ImageUtil;
import com.sun.opengl.util.texture.Texture;
import edu.cmu.cs.dennisc.lookingglass.opengl.Context;
import edu.cmu.cs.dennisc.lookingglass.opengl.GeometryAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.MultipleAppearanceAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.TextureAdapter;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.Vertex;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderContext
extends Context {
    private int m_lastTime_nextLightID = 16384;
    private int m_nextLightID;
    private boolean m_isFogEnabled;
    private float[] m_ambient = new float[4];
    private FloatBuffer m_ambientBuffer = FloatBuffer.wrap(this.m_ambient);
    private HashMap<GeometryAdapter<? extends Geometry>, Integer> m_displayListMap = new HashMap();
    private HashMap<TextureAdapter<? extends edu.cmu.cs.dennisc.texture.Texture>, Texture> m_textureBindingMap = new HashMap();
    private List<Texture> m_toBeForgottenTextures = new LinkedList<Texture>();
    private List<Integer> m_toBeForgottenDisplayLists = new LinkedList<Integer>();
    private TextureAdapter<? extends edu.cmu.cs.dennisc.texture.Texture> m_currDiffuseColorTextureAdapter;
    private boolean m_isShadingEnabled;
    private Rectangle m_clearRect = new Rectangle();
    private Stack<Float> m_globalOpacityStack = new Stack();
    private float m_globalOpacity = 1.0f;
    private int m_face;
    private MultipleAppearanceAdapter m_multipleAppearanceAdapter;
    private float m_globalBrightness = 1.0f;
    private static float[] s_color = new float[4];
    private static FloatBuffer s_colorBuffer = FloatBuffer.wrap(s_color);

    public void pushGlobalOpacity() {
        this.m_globalOpacityStack.push(Float.valueOf(this.m_globalOpacity));
    }

    public void multiplyGlobalOpacity(float globalOpacity) {
        this.m_globalOpacity *= globalOpacity;
    }

    public void popGlobalOpacity() {
        this.m_globalOpacity = this.m_globalOpacityStack.pop().floatValue();
    }

    public void initialize() {
        this.m_clearRect.setBounds(0, 0, 0, 0);
        this.m_globalOpacity = 1.0f;
        this.m_globalOpacityStack.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderLetterboxingIfNecessary(int width, int height) {
        if (this.m_clearRect.x != 0 || this.m_clearRect.y != 0 || this.m_clearRect.width != width || this.m_clearRect.height != height) {
            this.gl.glEnable(3089);
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            try {
                if (this.m_clearRect.x > 0) {
                    this.gl.glScissor(0, 0, this.m_clearRect.x, height);
                    this.gl.glClear(16384);
                }
                if (this.m_clearRect.x + this.m_clearRect.width < width) {
                    this.gl.glScissor(this.m_clearRect.x + this.m_clearRect.width, 0, width - this.m_clearRect.width, height);
                    this.gl.glClear(16384);
                }
                if (this.m_clearRect.y > 0) {
                    this.gl.glScissor(0, 0, width, this.m_clearRect.y);
                    this.gl.glClear(16384);
                }
                if (this.m_clearRect.y + this.m_clearRect.height < height) {
                    this.gl.glScissor(0, this.m_clearRect.y + this.m_clearRect.height, width, height - this.m_clearRect.height);
                    this.gl.glClear(16384);
                }
            }
            finally {
                this.gl.glDisable(3089);
            }
        }
    }

    public void captureBuffers(BufferedImage rvColor, FloatBuffer rvDepth) {
        if (rvColor != null) {
            int width = rvColor.getWidth();
            int height = rvColor.getHeight();
            DataBuffer dataBuffer = rvColor.getRaster().getDataBuffer();
            if (rvDepth != null) {
                byte[] color = ((DataBufferByte)dataBuffer).getData();
                ByteBuffer buffer = ByteBuffer.wrap(color);
                this.gl.glReadPixels(0, 0, width, height, 32768, 5121, (Buffer)buffer);
                this.gl.glReadPixels(0, 0, width, height, 6402, 5126, (Buffer)rvDepth);
                boolean ON = false;
                int OFF = -1;
                int i = 0;
                while (rvDepth.hasRemaining()) {
                    color[i] = rvDepth.get() == 1.0f ? 0 : -1;
                    i += 4;
                }
                rvDepth.rewind();
            } else {
                int error;
                ByteBuffer buffer = ByteBuffer.wrap(((DataBufferByte)dataBuffer).getData());
                while (this.gl.glGetError() != 0) {
                }
                int format = 32768;
                int type = 5121;
                this.gl.glReadPixels(0, 0, width, height, format, type, (Buffer)buffer);
                LinkedList<Integer> errors = null;
                while ((error = this.gl.glGetError()) != 0) {
                    if (errors == null) {
                        errors = new LinkedList<Integer>();
                    }
                    errors.add(error);
                }
                if (errors != null) {
                    String description = this.glu.gluErrorString(((Integer)errors.get(0)).intValue());
                    PrintUtilities.println("unable to capture back buffer:", description);
                }
            }
        } else {
            throw new RuntimeException("todo");
        }
        ImageUtil.flipImageVertically((BufferedImage)rvColor);
    }

    @Override
    protected void handleGLChange() {
    }

    public void setMultipleAppearance(int face, MultipleAppearanceAdapter multipleAppearanceAdapter) {
        this.m_face = face;
        this.m_multipleAppearanceAdapter = multipleAppearanceAdapter;
    }

    @Override
    public void setAppearanceIndex(int index) {
        this.m_multipleAppearanceAdapter.setPipelineState(this, this.m_face, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actuallyForgetTexturesIfNecessary() {
        int N = this.m_toBeForgottenTextures.size();
        if (N > 0) {
            List<Texture> list = this.m_toBeForgottenTextures;
            synchronized (list) {
                this.m_toBeForgottenTextures.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actuallyForgetDisplayListsIfNecessary() {
        int N = this.m_toBeForgottenDisplayLists.size();
        if (N > 0) {
            List<Integer> list = this.m_toBeForgottenDisplayLists;
            synchronized (list) {
                for (Integer toBeForgottenDisplayList : this.m_toBeForgottenDisplayLists) {
                    this.gl.glDeleteLists(toBeForgottenDisplayList.intValue(), 1);
                }
                this.m_toBeForgottenDisplayLists.clear();
            }
        }
    }

    public void beginAffectorSetup() {
        this.m_ambient[0] = 0.0f;
        this.m_ambient[1] = 0.0f;
        this.m_ambient[2] = 0.0f;
        this.m_ambient[3] = 1.0f;
        this.m_nextLightID = 16384;
        this.m_isFogEnabled = false;
        this.m_currDiffuseColorTextureAdapter = null;
    }

    public void endAffectorSetup() {
        this.m_ambient[0] = this.m_ambient[0] * this.m_globalBrightness;
        this.m_ambient[1] = this.m_ambient[1] * this.m_globalBrightness;
        this.m_ambient[2] = this.m_ambient[2] * this.m_globalBrightness;
        this.m_ambient[3] = this.m_ambient[3] * this.m_globalBrightness;
        this.gl.glLightModelfv(2899, this.m_ambientBuffer);
        for (int id = this.m_nextLightID; id < this.m_lastTime_nextLightID; ++id) {
            this.gl.glDisable(id);
        }
        if (this.m_isFogEnabled) {
            this.gl.glEnable(2912);
        } else {
            this.gl.glDisable(2912);
        }
        this.m_lastTime_nextLightID = this.m_nextLightID;
        this.gl.glEnable(2929);
        this.gl.glEnable(2903);
        this.gl.glEnable(2884);
    }

    public void setGlobalBrightness(float globalBrightness) {
        this.m_globalBrightness = globalBrightness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLightColor(int id, float[] color, float brightness) {
        FloatBuffer floatBuffer = s_colorBuffer;
        synchronized (floatBuffer) {
            RenderContext.s_color[0] = color[0] * brightness * this.m_globalBrightness;
            RenderContext.s_color[1] = color[1] * brightness * this.m_globalBrightness;
            RenderContext.s_color[2] = color[2] * brightness * this.m_globalBrightness;
            RenderContext.s_color[3] = color[3] * brightness * this.m_globalBrightness;
            this.gl.glLightfv(id, 4609, s_colorBuffer);
            this.gl.glLightfv(id, 4610, s_colorBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFogColor(float[] fogColor) {
        FloatBuffer floatBuffer = s_colorBuffer;
        synchronized (floatBuffer) {
            RenderContext.s_color[0] = fogColor[0] * this.m_globalBrightness;
            RenderContext.s_color[1] = fogColor[1] * this.m_globalBrightness;
            RenderContext.s_color[2] = fogColor[2] * this.m_globalBrightness;
            RenderContext.s_color[3] = fogColor[3] * this.m_globalBrightness;
            this.gl.glFogfv(2918, s_colorBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColor(float[] color, float opacity) {
        FloatBuffer floatBuffer = s_colorBuffer;
        synchronized (floatBuffer) {
            RenderContext.s_color[0] = color[0] * this.m_globalBrightness;
            RenderContext.s_color[1] = color[1] * this.m_globalBrightness;
            RenderContext.s_color[2] = color[2] * this.m_globalBrightness;
            RenderContext.s_color[3] = color[3] * opacity * this.m_globalOpacity;
            this.gl.glColor4fv(s_colorBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaterial(int face, int name, float[] color, float opacity) {
        FloatBuffer floatBuffer = s_colorBuffer;
        synchronized (floatBuffer) {
            RenderContext.s_color[0] = color[0] * this.m_globalBrightness;
            RenderContext.s_color[1] = color[1] * this.m_globalBrightness;
            RenderContext.s_color[2] = color[2] * this.m_globalBrightness;
            RenderContext.s_color[3] = color[3] * opacity * this.m_globalOpacity;
            this.gl.glMaterialfv(face, name, s_colorBuffer);
        }
    }

    public void setClearColor(float[] color) {
        this.gl.glClearColor(color[0] * this.m_globalBrightness, color[1] * this.m_globalBrightness, color[2] * this.m_globalBrightness, color[3] * this.m_globalBrightness);
    }

    public void setViewportAndAddToClearRect(Rectangle viewport) {
        this.gl.glViewport(viewport.x, viewport.y, viewport.width, viewport.height);
        if (this.m_clearRect.width == 0 || this.m_clearRect.height == 0) {
            this.m_clearRect.setBounds(viewport);
        } else {
            this.m_clearRect.union(viewport);
        }
    }

    public boolean isFogEnabled() {
        return this.m_isFogEnabled;
    }

    public void setIsFogEnabled(boolean isFogEnabled) {
        this.m_isFogEnabled = isFogEnabled;
    }

    public void addAmbient(float[] color, float brightness) {
        this.m_ambient[0] = this.m_ambient[0] + color[0] * brightness;
        this.m_ambient[1] = this.m_ambient[1] + color[1] * brightness;
        this.m_ambient[2] = this.m_ambient[2] + color[2] * brightness;
    }

    public int getNextLightID() {
        int id = this.m_nextLightID++;
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getDisplayListID(GeometryAdapter<? extends Geometry> geometryAdapter) {
        HashMap<GeometryAdapter<? extends Geometry>, Integer> hashMap = this.m_displayListMap;
        synchronized (hashMap) {
            Integer rv = this.m_displayListMap.get(geometryAdapter);
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer generateDisplayListID(GeometryAdapter<? extends Geometry> geometryAdapter) {
        Integer id = new Integer(this.gl.glGenLists(1));
        HashMap<GeometryAdapter<? extends Geometry>, Integer> hashMap = this.m_displayListMap;
        synchronized (hashMap) {
            this.m_displayListMap.put(geometryAdapter, id);
        }
        geometryAdapter.addRenderContext(this);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetAllGeometryAdapters() {
        HashMap<GeometryAdapter<? extends Geometry>, Integer> hashMap = this.m_displayListMap;
        synchronized (hashMap) {
            for (GeometryAdapter<? extends Geometry> geometryAdapter : this.m_displayListMap.keySet()) {
                this.forgetGeometryAdapter(geometryAdapter, false);
            }
            this.m_displayListMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetGeometryAdapter(GeometryAdapter<? extends Geometry> geometryAdapter, boolean removeFromMap) {
        HashMap<GeometryAdapter<? extends Geometry>, Integer> hashMap = this.m_displayListMap;
        synchronized (hashMap) {
            Integer value = this.m_displayListMap.get(geometryAdapter);
            if (value != null) {
                this.m_toBeForgottenDisplayLists.add(value);
                if (removeFromMap) {
                    this.m_displayListMap.remove(geometryAdapter);
                }
                geometryAdapter.removeRenderContext(this);
            }
        }
    }

    public void forgetGeometryAdapter(GeometryAdapter<? extends Geometry> geometryAdapter) {
        this.forgetGeometryAdapter(geometryAdapter, true);
    }

    private void forgetTextureBindingID(TextureAdapter<? extends edu.cmu.cs.dennisc.texture.Texture> textureAdapter, Texture value, boolean removeFromMap) {
        if (value != null) {
            this.m_toBeForgottenTextures.add(value);
            if (removeFromMap) {
                this.m_textureBindingMap.remove(textureAdapter);
            }
            textureAdapter.removeRenderContext(this);
            PrintUtilities.println("FYI: texture adapter forgotten:", textureAdapter, value);
        } else {
            PrintUtilities.println("WARNING: no id for texture adapter:", textureAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetAllTextureAdapters() {
        HashMap<TextureAdapter<? extends edu.cmu.cs.dennisc.texture.Texture>, Texture> hashMap = this.m_textureBindingMap;
        synchronized (hashMap) {
            for (TextureAdapter<? extends edu.cmu.cs.dennisc.texture.Texture> textureAdapter : this.m_textureBindingMap.keySet()) {
                this.forgetTextureBindingID(textureAdapter, this.m_textureBindingMap.get(textureAdapter), false);
            }
            this.m_textureBindingMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetTextureAdapter(TextureAdapter<? extends edu.cmu.cs.dennisc.texture.Texture> textureAdapter, boolean removeFromMap) {
        HashMap<TextureAdapter<? extends edu.cmu.cs.dennisc.texture.Texture>, Texture> hashMap = this.m_textureBindingMap;
        synchronized (hashMap) {
            this.forgetTextureBindingID(textureAdapter, this.m_textureBindingMap.get(textureAdapter), removeFromMap);
        }
    }

    public void forgetTextureAdapter(TextureAdapter<? extends edu.cmu.cs.dennisc.texture.Texture> textureAdapter) {
        this.forgetTextureAdapter(textureAdapter, true);
    }

    public void put(TextureAdapter<? extends edu.cmu.cs.dennisc.texture.Texture> textureAdapter, Texture glTexture) {
        this.m_textureBindingMap.put(textureAdapter, glTexture);
    }

    public void setDiffuseColorTextureAdapter(TextureAdapter<? extends edu.cmu.cs.dennisc.texture.Texture> diffuseColorTextureAdapter, boolean isDiffuseColorTextureClamped) {
        if (diffuseColorTextureAdapter != null && diffuseColorTextureAdapter.isValid()) {
            this.gl.glEnable(3553);
            if (this.m_currDiffuseColorTextureAdapter != diffuseColorTextureAdapter) {
                Texture texture = diffuseColorTextureAdapter.getTexture(this);
                texture.bind();
                texture.enable();
                int value = isDiffuseColorTextureClamped ? 10496 : 10497;
                this.gl.glTexParameteri(3553, 10242, value);
                this.gl.glTexParameteri(3553, 10243, value);
                this.m_currDiffuseColorTextureAdapter = diffuseColorTextureAdapter;
            }
        } else {
            this.gl.glDisable(3553);
        }
    }

    public void setBumpTextureAdapter(TextureAdapter<? extends edu.cmu.cs.dennisc.texture.Texture> bumpTextureAdapter) {
        if (bumpTextureAdapter == null || bumpTextureAdapter.isValid()) {
            // empty if block
        }
    }

    public boolean isShadingEnabled() {
        return this.m_isShadingEnabled;
    }

    public void setIsShadingEnabled(boolean isShadingEnabled) {
        this.m_isShadingEnabled = isShadingEnabled;
        if (this.m_isShadingEnabled) {
            this.gl.glEnable(2896);
        } else {
            this.gl.glDisable(2896);
        }
    }

    public float getURatio() {
        if (this.m_currDiffuseColorTextureAdapter != null) {
            return this.m_currDiffuseColorTextureAdapter.mapU(1.0f);
        }
        return Float.NaN;
    }

    public float getVRatio() {
        if (this.m_currDiffuseColorTextureAdapter != null) {
            return this.m_currDiffuseColorTextureAdapter.mapV(1.0f);
        }
        return Float.NaN;
    }

    protected void renderVertex(Vertex vertex) {
        if (this.m_currDiffuseColorTextureAdapter != null && !vertex.textureCoordinate0.isNaN()) {
            float u = this.m_currDiffuseColorTextureAdapter.mapU(vertex.textureCoordinate0.u);
            float v = this.m_currDiffuseColorTextureAdapter.mapV(vertex.textureCoordinate0.v);
            this.gl.glTexCoord2f(u, v);
        }
        if (!vertex.diffuseColor.isNaN()) {
            this.gl.glColor4f(vertex.diffuseColor.red, vertex.diffuseColor.green, vertex.diffuseColor.blue, vertex.diffuseColor.alpha);
        }
        if (this.m_isShadingEnabled) {
            this.gl.glNormal3f(vertex.normal.x, vertex.normal.y, vertex.normal.z);
        }
        this.gl.glVertex3d(vertex.position.x, vertex.position.y, vertex.position.z);
    }
}

