/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.PickContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.VisualAdapter;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Vector4;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.Visual;
import java.nio.IntBuffer;

class SelectionBufferInfo {
    private float zFront;
    private float zBack;
    private VisualAdapter<? extends Visual> visualAdapter;
    private boolean isFrontFacing;
    private int geometryIndex;
    private int subElement;
    private Point3 pointInSource = Point3.createNaN();

    public SelectionBufferInfo(PickContext pc, IntBuffer intBuffer, int offset) {
        int nameCount = intBuffer.get(offset + 0);
        int zFrontAsInt = intBuffer.get(offset + 1);
        int zBackAsInt = intBuffer.get(offset + 2);
        long zFrontAsLong = zFrontAsInt;
        this.zFront = zFrontAsLong &= 0xFFFFFFFFL;
        this.zFront /= 4.2949673E9f;
        long zBackAsLong = zBackAsInt;
        this.zBack = zBackAsLong &= 0xFFFFFFFFL;
        this.zBack /= 4.2949673E9f;
        if (nameCount == 4) {
            int key = intBuffer.get(offset + 3);
            this.visualAdapter = pc.getPickVisualAdapterForName(key);
            this.isFrontFacing = intBuffer.get(offset + 4) == 1;
            this.geometryIndex = intBuffer.get(offset + 5);
            this.subElement = intBuffer.get(offset + 6);
        }
    }

    public float getZFront() {
        return this.zFront;
    }

    public float getZBack() {
        return this.zBack;
    }

    public Visual getSGVisual() {
        if (this.visualAdapter != null) {
            return (Visual)this.visualAdapter.m_element;
        }
        return null;
    }

    public boolean isFrontFacing() {
        return this.isFrontFacing;
    }

    public int getGeometryIndex() {
        return this.geometryIndex;
    }

    public Geometry getSGGeometry() {
        Visual sgVisual = this.getSGVisual();
        if (sgVisual != null) {
            Geometry[] gs = (Geometry[])sgVisual.geometries.getValue();
            if (0 <= this.geometryIndex && this.geometryIndex < gs.length) {
                return gs[this.geometryIndex];
            }
            return null;
        }
        return null;
    }

    public int getSubElement() {
        return this.subElement;
    }

    public void updatePointInSource(Ray ray, AffineMatrix4x4 inverseAbsoluteTransformationOfSource) {
        if (this.visualAdapter != null) {
            this.visualAdapter.getIntersectionInSource(this.pointInSource, ray, inverseAbsoluteTransformationOfSource, this.geometryIndex, this.subElement);
        } else {
            this.pointInSource.setNaN();
        }
    }

    public void updatePointInSource(Matrix4x4 m) {
        double z = this.zFront;
        z *= 2.0;
        Vector4 v = new Vector4(0.0, 0.0, z -= 1.0, 1.0);
        m.transform(v);
        this.pointInSource.set(v.x / v.w, v.y / v.w, v.z / v.w);
    }

    public Point3 getPointInSource() {
        return this.pointInSource;
    }
}

