/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.color.Color4f;
import edu.cmu.cs.dennisc.lookingglass.opengl.AdapterFactory;
import edu.cmu.cs.dennisc.lookingglass.opengl.AppearanceAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.TextureAdapter;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.FillingStyle;
import edu.cmu.cs.dennisc.scenegraph.ShadingStyle;
import edu.cmu.cs.dennisc.scenegraph.SingleAppearance;
import edu.cmu.cs.dennisc.texture.Texture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleAppearanceAdapter
extends AppearanceAdapter<SingleAppearance> {
    private boolean m_isShaded;
    private boolean m_isAmbientLinkedToDiffuse;
    private boolean m_isMaterialActuallyShowing;
    private boolean m_isMaterialAlphaBlended;
    private float[] m_ambient = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN};
    private float[] m_diffuse = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN};
    private float[] m_specular = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN};
    private float[] m_emissive = new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN};
    private float m_opacity = Float.NaN;
    private float m_shininess = Float.NaN;
    private int m_polygonMode;
    private TextureAdapter<? extends Texture> m_diffuseColorTextureAdapter;
    private boolean m_isDiffuseColorTextureAlphaBlended;
    private boolean m_isDiffuseColorTextureClamped;
    private TextureAdapter<? extends Texture> m_bumpTextureAdapter;
    private boolean m_isEthereal;

    @Override
    public boolean isActuallyShowing() {
        return this.m_isMaterialActuallyShowing;
    }

    @Override
    public boolean isAlphaBlended() {
        return this.m_isMaterialAlphaBlended || this.m_isDiffuseColorTextureAlphaBlended;
    }

    @Override
    public boolean isEthereal() {
        return this.m_isEthereal;
    }

    @Override
    public void setPipelineState(RenderContext rc, int face) {
        rc.setIsShadingEnabled(this.m_isShaded);
        if (this.m_isShaded) {
            rc.gl.glMaterialf(face, 5633, this.m_shininess);
            rc.setMaterial(face, 4610, this.m_specular, this.m_opacity);
            rc.setMaterial(face, 5632, this.m_emissive, this.m_opacity);
            if (this.m_isAmbientLinkedToDiffuse) {
                rc.gl.glColorMaterial(face, 5634);
            } else {
                rc.setMaterial(face, 4608, this.m_ambient, this.m_opacity);
                rc.gl.glColorMaterial(face, 4609);
            }
        }
        rc.setColor(this.m_diffuse, this.m_opacity);
        rc.gl.glPolygonMode(face, this.m_polygonMode);
        rc.setDiffuseColorTextureAdapter(this.m_diffuseColorTextureAdapter, this.m_isDiffuseColorTextureClamped);
        rc.setBumpTextureAdapter(this.m_bumpTextureAdapter);
        if (this.m_isEthereal) {
            rc.gl.glDepthFunc(515);
        } else {
            rc.gl.glDepthFunc(513);
        }
    }

    private void updateOpacityRelatedBooleans() {
        float opacity = this.m_opacity * this.m_diffuse[3];
        this.m_isMaterialActuallyShowing = opacity > 0.0f;
        this.m_isMaterialAlphaBlended = opacity < 1.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property == ((SingleAppearance)this.m_element).ambientColor) {
            ((Color4f)((SingleAppearance)this.m_element).ambientColor.getValue()).getAsArray(this.m_ambient);
            this.m_isAmbientLinkedToDiffuse = Float.isNaN(this.m_ambient[0]);
            return;
        } else if (property == ((SingleAppearance)this.m_element).diffuseColor) {
            ((Color4f)((SingleAppearance)this.m_element).diffuseColor.getValue()).getAsArray(this.m_diffuse);
            this.updateOpacityRelatedBooleans();
            return;
        } else if (property == ((SingleAppearance)this.m_element).fillingStyle) {
            FillingStyle fillingStyle = ((SingleAppearance)this.m_element).fillingStyle.getValue();
            if (fillingStyle.equals((Object)FillingStyle.SOLID)) {
                this.m_polygonMode = 6914;
                return;
            } else if (fillingStyle.equals((Object)FillingStyle.WIREFRAME)) {
                this.m_polygonMode = 6913;
                return;
            } else {
                if (!fillingStyle.equals((Object)FillingStyle.POINTS)) throw new RuntimeException();
                this.m_polygonMode = 6912;
            }
            return;
        } else if (property == ((SingleAppearance)this.m_element).shadingStyle) {
            ShadingStyle shadingStyle = ((SingleAppearance)this.m_element).shadingStyle.getValue();
            if (shadingStyle == null || shadingStyle.equals((Object)ShadingStyle.NONE)) {
                this.m_isShaded = false;
                return;
            } else if (shadingStyle.equals((Object)ShadingStyle.FLAT)) {
                this.m_isShaded = true;
                return;
            } else {
                if (!shadingStyle.equals((Object)ShadingStyle.SMOOTH)) throw new RuntimeException();
                this.m_isShaded = true;
            }
            return;
        } else if (property == ((SingleAppearance)this.m_element).opacity) {
            this.m_opacity = ((Float)((SingleAppearance)this.m_element).opacity.getValue()).floatValue();
            this.updateOpacityRelatedBooleans();
            return;
        } else if (property == ((SingleAppearance)this.m_element).specularHighlightColor) {
            ((Color4f)((SingleAppearance)this.m_element).specularHighlightColor.getValue()).getAsArray(this.m_specular);
            return;
        } else if (property == ((SingleAppearance)this.m_element).specularHighlightExponent) {
            this.m_shininess = ((Float)((SingleAppearance)this.m_element).specularHighlightExponent.getValue()).floatValue();
            return;
        } else if (property == ((SingleAppearance)this.m_element).emissiveColor) {
            ((Color4f)((SingleAppearance)this.m_element).emissiveColor.getValue()).getAsArray(this.m_emissive);
            return;
        } else if (property == ((SingleAppearance)this.m_element).diffuseColorTexture) {
            this.m_diffuseColorTextureAdapter = AdapterFactory.getAdapterFor(((SingleAppearance)this.m_element).diffuseColorTexture.getValue());
            return;
        } else if (property == ((SingleAppearance)this.m_element).isDiffuseColorTextureAlphaBlended) {
            this.m_isDiffuseColorTextureAlphaBlended = (Boolean)((SingleAppearance)this.m_element).isDiffuseColorTextureAlphaBlended.getValue();
            return;
        } else if (property == ((SingleAppearance)this.m_element).isDiffuseColorTextureClamped) {
            this.m_isDiffuseColorTextureClamped = (Boolean)((SingleAppearance)this.m_element).isDiffuseColorTextureClamped.getValue();
            return;
        } else if (property == ((SingleAppearance)this.m_element).bumpTexture) {
            this.m_bumpTextureAdapter = AdapterFactory.getAdapterFor(((SingleAppearance)this.m_element).bumpTexture.getValue());
            return;
        } else if (property == ((SingleAppearance)this.m_element).isEthereal) {
            this.m_isEthereal = (Boolean)((SingleAppearance)this.m_element).isEthereal.getValue();
            return;
        } else {
            super.propertyChanged(property);
        }
    }
}

