/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.Context;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.ShapeAdapter;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.Sphere;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SphereAdapter
extends ShapeAdapter<Sphere> {
    private double m_radius;
    private int m_stacks = 50;
    private int m_slices = 50;

    private void glSphere(Context c) {
        c.glu.gluSphere(c.getQuadric(), this.m_radius, this.m_slices, this.m_stacks);
    }

    @Override
    protected void renderGeometry(RenderContext rc) {
        this.glSphere(rc);
    }

    @Override
    public Point3 getIntersectionInSource(Point3 rv, Ray ray, AffineMatrix4x4 m, int subElement) {
        double c;
        Point3 origin = new Point3(0.0, 0.0, 0.0);
        Vector3 dst = Vector3.createSubtraction(ray.accessOrigin(), origin);
        double b = Vector3.calculateDotProduct(dst, ray.accessDirection());
        double d = b * b - (c = Vector3.calculateDotProduct(dst, dst) - this.m_radius);
        if (d > 0.0) {
            double t = -b - Math.sqrt(d);
            ray.getPointAlong(rv, t);
        } else {
            rv.setNaN();
        }
        return rv;
    }

    @Override
    protected void pickGeometry(PickContext pc, boolean isSubElementRequired) {
        int name = isSubElementRequired ? 0 : -1;
        pc.gl.glPushName(name);
        this.glSphere(pc);
        pc.gl.glPopName();
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property == ((Sphere)this.m_element).radius) {
            this.m_radius = (Double)((Sphere)this.m_element).radius.getValue();
            this.setIsGeometryChanged(true);
        } else {
            super.propertyChanged(property);
        }
    }
}

