/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.AbstractPerspectiveCameraAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.Context;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleInDegrees;
import edu.cmu.cs.dennisc.math.AngleInRadians;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.SymmetricPerspectiveCamera;
import java.awt.Rectangle;
import java.nio.DoubleBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricPerspectiveCameraAdapter
extends AbstractPerspectiveCameraAdapter<SymmetricPerspectiveCamera> {
    private double m_verticalInDegrees;
    private double m_horizontalInDegrees;
    private static final double DEFAULT_ACTUAL_VERTICAL_IN_DEGREES = new AngleInRadians(0.5).getAsDegrees();

    @Override
    public Ray getRayAtPixel(Ray rv, int xPixel, int yPixel, Rectangle actualViewport) {
        double vertical = this.getActualVerticalViewingAngle(actualViewport).getAsRadians();
        double near = (Double)((SymmetricPerspectiveCamera)this.m_element).nearClippingPlaneDistance.getValue();
        double far = (Double)((SymmetricPerspectiveCamera)this.m_element).farClippingPlaneDistance.getValue();
        xPixel = actualViewport.width - xPixel;
        yPixel = actualViewport.height - yPixel;
        double tanHalfVertical = Math.tan(vertical * 0.5);
        double aspect = (double)actualViewport.width / (double)actualViewport.height;
        double halfWidth = (double)actualViewport.width * 0.5;
        double halfHeight = (double)actualViewport.height * 0.5;
        double dx = tanHalfVertical * ((double)xPixel / halfWidth - 1.0) * aspect;
        double dy = tanHalfVertical * (1.0 - (double)yPixel / halfHeight);
        Point3 pNear = new Point3(dx * near, dy * near, near);
        Point3 pFar = new Point3(dx * far, dy * far, far);
        rv.setOrigin(pNear);
        Vector3 direction = Vector3.createSubtraction(pFar, pNear);
        direction.normalize();
        rv.setDirection(direction);
        return rv;
    }

    @Override
    public Matrix4x4 getActualProjectionMatrix(Matrix4x4 rv, Rectangle actualViewport) {
        double zNear = (Double)((SymmetricPerspectiveCamera)this.m_element).nearClippingPlaneDistance.getValue();
        double zFar = (Double)((SymmetricPerspectiveCamera)this.m_element).farClippingPlaneDistance.getValue();
        double fovx = this.getActualHorizontalViewingAngle(actualViewport).getAsRadians();
        double fovy = this.getActualVerticalViewingAngle(actualViewport).getAsRadians();
        double aspect = fovx / fovy;
        double f = 1.0 / Math.tan(fovy / 2.0);
        rv.right.set(f / aspect, 0.0, 0.0, 0.0);
        rv.up.set(0.0, f, 0.0, 0.0);
        rv.backward.set(0.0, 0.0, (zFar + zNear) / (zNear - zFar), -1.0);
        rv.translation.set(0.0, 0.0, 2.0 * zFar * zNear / (zNear - zFar), 0.0);
        return rv;
    }

    @Override
    protected Rectangle performLetterboxing(Rectangle rv) {
        if (!Double.isNaN(this.m_horizontalInDegrees) && !Double.isNaN(this.m_verticalInDegrees)) {
            double aspect = this.m_horizontalInDegrees / this.m_verticalInDegrees;
            double pixelAspect = (double)rv.width / (double)rv.height;
            if (aspect > pixelAspect) {
                int letterBoxedHeight = (int)((double)rv.width / aspect + 0.5);
                rv.setBounds(0, (rv.height - letterBoxedHeight) / 2, rv.width, letterBoxedHeight);
            } else if (aspect < pixelAspect) {
                int letterBoxedWidth = (int)((double)rv.height * aspect + 0.5);
                rv.setBounds((rv.width - letterBoxedWidth) / 2, 0, letterBoxedWidth, rv.height);
            }
        }
        return rv;
    }

    public Angle getActualHorizontalViewingAngle(Rectangle actualViewport) {
        double horizontalInDegrees;
        if (Double.isNaN(this.m_horizontalInDegrees)) {
            double aspect = (double)actualViewport.width / (double)actualViewport.height;
            horizontalInDegrees = Double.isNaN(this.m_verticalInDegrees) ? DEFAULT_ACTUAL_VERTICAL_IN_DEGREES * aspect : this.m_verticalInDegrees * aspect;
        } else {
            horizontalInDegrees = this.m_horizontalInDegrees;
        }
        return new AngleInDegrees(horizontalInDegrees);
    }

    public Angle getActualVerticalViewingAngle(Rectangle actualViewport) {
        double verticalInDegrees;
        if (Double.isNaN(this.m_verticalInDegrees)) {
            double aspect = (double)actualViewport.width / (double)actualViewport.height;
            verticalInDegrees = Double.isNaN(this.m_horizontalInDegrees) ? DEFAULT_ACTUAL_VERTICAL_IN_DEGREES : this.m_horizontalInDegrees / aspect;
        } else {
            verticalInDegrees = this.m_verticalInDegrees;
        }
        return new AngleInDegrees(verticalInDegrees);
    }

    @Override
    protected void setupProjection(Context context, Rectangle actualViewport, float zNear, float zFar) {
        Matrix4x4 projection = new Matrix4x4();
        double[] projectionArray = new double[16];
        DoubleBuffer projectionBuffer = DoubleBuffer.wrap(projectionArray);
        this.getActualProjectionMatrix(projection, actualViewport);
        projection.getAsColumnMajorArray16(projectionArray);
        context.gl.glMultMatrixd(projectionBuffer);
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property == ((SymmetricPerspectiveCamera)this.m_element).verticalViewingAngle) {
            this.m_verticalInDegrees = ((Angle)((SymmetricPerspectiveCamera)this.m_element).verticalViewingAngle.getValue()).getAsDegrees();
        } else if (property == ((SymmetricPerspectiveCamera)this.m_element).horizontalViewingAngle) {
            this.m_horizontalInDegrees = ((Angle)((SymmetricPerspectiveCamera)this.m_element).horizontalViewingAngle.getValue()).getAsDegrees();
        } else {
            super.propertyChanged(property);
        }
    }
}

