/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl;

import edu.cmu.cs.dennisc.lookingglass.opengl.Context;
import edu.cmu.cs.dennisc.lookingglass.opengl.GeometryAdapter;
import edu.cmu.cs.dennisc.lookingglass.opengl.PickContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.RenderContext;
import edu.cmu.cs.dennisc.lookingglass.opengl.ShapeAdapter;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.Torus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorusAdapter
extends ShapeAdapter<Torus> {
    private void glVertex(Context context, Torus.CoordinatePlane coordinatePlane, double majorRadius, double minorRadius, double theta, double phi, boolean isLightingEnabled) {
        double sinTheta = Math.sin(theta);
        double cosTheta = Math.cos(theta);
        double sinPhi = Math.sin(phi);
        double cosPhi = Math.cos(phi);
        double y = minorRadius * sinPhi;
        double r = majorRadius + minorRadius * cosPhi;
        double x = sinTheta * r;
        double z = cosTheta * r;
        if (isLightingEnabled) {
            double i = sinTheta * cosPhi;
            double j = sinPhi;
            double k = cosTheta * cosPhi;
            if (coordinatePlane == Torus.CoordinatePlane.XY || coordinatePlane == Torus.CoordinatePlane.YZ) {
                // empty if block
            }
            context.gl.glNormal3d(i, j, k);
        }
        if (coordinatePlane == Torus.CoordinatePlane.XY || coordinatePlane == Torus.CoordinatePlane.YZ) {
            // empty if block
        }
        context.gl.glVertex3d(x, y, z);
    }

    private void glTorus(Context context, boolean isLightingEnabled) {
        Torus.CoordinatePlane coordinatePlane = ((Torus)this.m_element).coordinatePlane.getValue();
        double majorRadius = (Double)((Torus)this.m_element).majorRadius.getValue();
        double minorRadius = (Double)((Torus)this.m_element).minorRadius.getValue();
        int N = 32;
        int M = 16;
        double dTheta = 0.2026833970057931;
        double dPhi = 0.41887902047863906;
        double theta = 0.0;
        for (int i = 0; i < 31; ++i) {
            double phi = 0.0;
            context.gl.glBegin(8);
            for (int j = 0; j < 16; ++j) {
                this.glVertex(context, coordinatePlane, majorRadius, minorRadius, theta, phi, isLightingEnabled);
                this.glVertex(context, coordinatePlane, majorRadius, minorRadius, theta + dTheta, phi, isLightingEnabled);
                phi += dPhi;
            }
            context.gl.glEnd();
            theta += dTheta;
        }
    }

    @Override
    protected void renderGeometry(RenderContext rc) {
        this.glTorus(rc, true);
    }

    @Override
    protected void pickGeometry(PickContext pc, boolean isSubElementRequired) {
        int name = isSubElementRequired ? 0 : -1;
        pc.gl.glPushName(name);
        this.glTorus(pc, false);
        pc.gl.glPopName();
    }

    @Override
    public Point3 getIntersectionInSource(Point3 rv, Ray ray, AffineMatrix4x4 m, int subElement) {
        Vector3 direction = new Vector3(0.0, 0.0, 0.0);
        Torus.CoordinatePlane coordinatePlane = ((Torus)this.m_element).coordinatePlane.getValue();
        if (coordinatePlane == Torus.CoordinatePlane.XY) {
            direction.z = 1.0;
        } else if (coordinatePlane == Torus.CoordinatePlane.YZ) {
            direction.x = 1.0;
        } else {
            direction.y = 1.0;
        }
        return GeometryAdapter.getIntersectionInSourceFromPlaneInLocal(rv, ray, m, 0.0, 0.0, 0.0, direction.x, direction.y, direction.z);
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property == ((Torus)this.m_element).majorRadius) {
            this.setIsGeometryChanged(true);
        } else if (property == ((Torus)this.m_element).minorRadius) {
            this.setIsGeometryChanged(true);
        } else if (property == ((Torus)this.m_element).coordinatePlane) {
            this.setIsGeometryChanged(true);
        } else {
            super.propertyChanged(property);
        }
    }
}

