/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl.graphics;

import edu.cmu.cs.dennisc.awt.MultilineText;
import edu.cmu.cs.dennisc.awt.TextAlignment;
import edu.cmu.cs.dennisc.lookingglass.Graphics2D;
import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.lookingglass.opengl.graphics.BubbleAdapter;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.graphics.SpeechBubble;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeechBubbleAdapter
extends BubbleAdapter<SpeechBubble> {
    private static double sine(double t, double theta0, double theta1) {
        double theta = theta0 + t * (theta1 - theta0);
        return Math.sin(theta);
    }

    private Area getPortionOfPath(GeneralPath path, double portion) {
        Area area = new Area(path);
        Rectangle2D bounds = area.getBounds2D();
        double maskBottom = bounds.getY() + bounds.getHeight();
        double stylizedPathPortion = SpeechBubbleAdapter.sine(portion, -1.5707963267948966, 0.0) + 1.0;
        stylizedPathPortion *= stylizedPathPortion;
        double maskHeight = bounds.getHeight() * stylizedPathPortion;
        Rectangle2D.Double mask = new Rectangle2D.Double(bounds.getX(), maskBottom - maskHeight, bounds.getWidth(), maskHeight);
        area.intersect(new Area(mask));
        return area;
    }

    @Override
    protected void render(Graphics2D g2, LookingGlass lookingGlass, Rectangle actualViewport, AbstractCamera camera, MultilineText multilineText, Font font, Color textColor, float wrapWidth, Color fillColor, Color outlineColor, Point2D.Float originOfTail, Point2D.Float bodyConnectionLocationOfTail, Point2D.Float textBoundsOffset, double portion) {
        Area area;
        assert (originOfTail != null);
        assert (bodyConnectionLocationOfTail != null);
        g2.setFont(font);
        Dimension2D textSize = multilineText.getDimension(g2, wrapWidth);
        Rectangle2D.Double textBounds = new Rectangle2D.Double(textBoundsOffset.x, textBoundsOffset.y, textSize.getWidth(), textSize.getHeight());
        g2.setFont(font);
        float targetX = (float)bodyConnectionLocationOfTail.getX();
        float targetY = (float)bodyConnectionLocationOfTail.getY();
        float originX = (float)originOfTail.getX();
        float originY = (float)originOfTail.getY();
        float controlX = targetX;
        float controlY = originY;
        float topOffsetX = 6.0f;
        float topOffsetY = -2.0f;
        GeneralPath path = new GeneralPath();
        path.moveTo(originX, originY);
        path.quadTo(controlX, controlY, targetX + topOffsetX, targetY + topOffsetY);
        path.lineTo(targetX - topOffsetX, targetY + topOffsetY);
        path.quadTo(controlX, controlY, originX, originY);
        path.closePath();
        double IPAD = font.getSize2D() * 0.333f;
        RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double();
        roundRect.x = ((RectangularShape)textBounds).getX() + bodyConnectionLocationOfTail.getX() + textBoundsOffset.getX() - IPAD;
        roundRect.y = ((RectangularShape)textBounds).getY() + bodyConnectionLocationOfTail.getY() + textBoundsOffset.getY() - ((RectangularShape)textBounds).getHeight() - IPAD;
        roundRect.width = ((RectangularShape)textBounds).getWidth() + IPAD + IPAD;
        roundRect.height = ((RectangularShape)textBounds).getHeight() + IPAD + IPAD;
        roundRect.arcwidth = IPAD;
        roundRect.archeight = IPAD;
        if (portion < 1.0) {
            area = this.getPortionOfPath(path, portion);
        } else {
            area = new Area(path);
            area.add(new Area(roundRect));
        }
        assert (area != null);
        g2.setTransform(new AffineTransform());
        g2.setColor(fillColor);
        g2.fill(area);
        g2.setColor(outlineColor);
        g2.draw(area);
        if (!(portion < 1.0)) {
            g2.setFont(font);
            double xT = bodyConnectionLocationOfTail.getX();
            double yT = bodyConnectionLocationOfTail.getY() - ((RectangularShape)textBounds).getHeight();
            g2.translate(xT, yT);
            multilineText.paint(g2, wrapWidth, TextAlignment.LEADING, textBounds);
            g2.translate(-xT, -yT);
        }
    }
}

