/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.opengl.graphics;

import edu.cmu.cs.dennisc.awt.MultilineText;
import edu.cmu.cs.dennisc.color.Color4f;
import edu.cmu.cs.dennisc.lookingglass.Graphics2D;
import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.lookingglass.opengl.GraphicAdapter;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.graphics.Text;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextAdapter<E extends Text>
extends GraphicAdapter<E> {
    private MultilineText multilineText;
    private Font rememberedFont = null;
    private Color textColor = null;

    protected abstract float getWrapWidth(Rectangle var1);

    protected abstract void render(Graphics2D var1, LookingGlass var2, Rectangle var3, AbstractCamera var4, MultilineText var5, Font var6, Color var7, float var8);

    private void forgetFontIfNecessary(Graphics2D g2) {
        if (this.rememberedFont != null) {
            g2.forget(this.rememberedFont);
            this.rememberedFont = null;
        }
    }

    @Override
    protected void render(Graphics2D g2, LookingGlass lookingGlass, Rectangle actualViewport, AbstractCamera camera) {
        String text = (String)((Text)this.m_element).text.getValue();
        Font font = ((Text)this.m_element).font.getValue();
        if (font != this.rememberedFont) {
            this.forgetFontIfNecessary(g2);
            g2.remember(font);
            this.rememberedFont = font;
        }
        if (this.multilineText == null) {
            this.multilineText = new MultilineText(text);
        }
        this.render(g2, lookingGlass, actualViewport, camera, this.multilineText, this.rememberedFont, this.textColor, this.getWrapWidth(actualViewport));
    }

    @Override
    protected void forget(Graphics2D g2) {
        this.forgetFontIfNecessary(g2);
    }

    private void markMultilineTextInvalid() {
        this.multilineText = null;
    }

    @Override
    protected void propertyChanged(InstanceProperty<?> property) {
        if (property == ((Text)this.m_element).text) {
            this.markMultilineTextInvalid();
        } else if (property == ((Text)this.m_element).font) {
            this.markMultilineTextInvalid();
        } else if (property == ((Text)this.m_element).textColor) {
            Color4f color = (Color4f)((Text)this.m_element).textColor.getValue();
            this.textColor = color != null ? color.getAsAWTColor() : null;
        } else {
            super.propertyChanged(property);
        }
    }
}

