/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.lookingglass.util;

import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Vector4;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.AbstractNearPlaneAndFarPlaneCamera;
import java.awt.Point;
import java.awt.Rectangle;

public class TransformationUtilities {
    private static Matrix4x4 s_actualProjectionBuffer = new Matrix4x4();
    private static Rectangle s_actualViewportBuffer = new Rectangle();
    private static Vector4 s_vector4dBuffer = new Vector4();

    private static Vector4 transformFromAWTToViewport(Vector4 rv, Point p, double z, Rectangle actualViewport) {
        rv.x = p.x;
        rv.y = actualViewport.height - p.y;
        rv.z = z;
        rv.w = 1.0;
        return rv;
    }

    private static Point transformFromViewportToAWT(Point rv, Vector4 xyzw, Rectangle actualViewport) {
        rv.x = (int)(xyzw.x / xyzw.w);
        rv.y = (int)(xyzw.y / xyzw.w);
        rv.y = actualViewport.height - rv.y;
        return rv;
    }

    private static double getNear(AbstractCamera sgCamera) {
        if (sgCamera instanceof AbstractNearPlaneAndFarPlaneCamera) {
            return (Double)((AbstractNearPlaneAndFarPlaneCamera)sgCamera).nearClippingPlaneDistance.getValue();
        }
        return Double.NaN;
    }

    private static double getFar(AbstractCamera sgCamera) {
        if (sgCamera instanceof AbstractNearPlaneAndFarPlaneCamera) {
            return (Double)((AbstractNearPlaneAndFarPlaneCamera)sgCamera).farClippingPlaneDistance.getValue();
        }
        return Double.NaN;
    }

    private static Vector4 transformFromViewportToProjection_AffectReturnValuePassedIn(Vector4 rv, AbstractCamera sgCamera, Rectangle actualViewport) {
        rv.multiply(1.0 / rv.w);
        rv.x = (rv.x - (double)actualViewport.x) / (double)actualViewport.width;
        rv.y = (rv.y - (double)actualViewport.y) / (double)actualViewport.height;
        double zNear = TransformationUtilities.getNear(sgCamera);
        double zFar = TransformationUtilities.getFar(sgCamera);
        rv.z = (rv.z - zNear) / (zFar - zNear);
        rv.x = rv.x * 2.0 - 1.0;
        rv.y = rv.y * 2.0 - 1.0;
        rv.z = rv.z * 2.0 - 1.0;
        return rv;
    }

    private static Vector4 transformFromProjectionToViewport_AffectReturnValuePassedIn(Vector4 rv, AbstractCamera sgCamera, Rectangle actualViewport) {
        rv.multiply(1.0 / rv.w);
        rv.x = rv.x * 0.5 + 0.5;
        rv.y = rv.y * 0.5 + 0.5;
        rv.z = rv.z * 0.5 + 0.5;
        rv.x = rv.x * (double)actualViewport.width + (double)actualViewport.x;
        rv.y = rv.y * (double)actualViewport.height + (double)actualViewport.y;
        double zNear = TransformationUtilities.getNear(sgCamera);
        double zFar = TransformationUtilities.getFar(sgCamera);
        rv.z = rv.z * (zFar - zNear) + zNear;
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector4 transformFromProjectionToCamera_AffectReturnValuePassedIn(Vector4 rv, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        rv.multiply(1.0 / rv.w);
        Matrix4x4 matrix4x4 = s_actualProjectionBuffer;
        synchronized (matrix4x4) {
            lookingGlass.getActualProjectionMatrix(s_actualProjectionBuffer, sgCamera);
            s_actualProjectionBuffer.invert();
            s_actualProjectionBuffer.transform(rv);
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector4 transformFromCameraToProjection_AffectReturnValuePassedIn(Vector4 rv, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        rv.multiply(1.0 / rv.w);
        Matrix4x4 matrix4x4 = s_actualProjectionBuffer;
        synchronized (matrix4x4) {
            lookingGlass.getActualProjectionMatrix(s_actualProjectionBuffer, sgCamera);
            s_actualProjectionBuffer.transform(rv);
            return rv;
        }
    }

    private static Vector4 transformFromViewportToCamera_AffectReturnValuePassedIn(Vector4 rv, LookingGlass lookingGlass, AbstractCamera sgCamera, Rectangle actualViewport) {
        TransformationUtilities.transformFromViewportToProjection_AffectReturnValuePassedIn(rv, sgCamera, actualViewport);
        TransformationUtilities.transformFromProjectionToCamera_AffectReturnValuePassedIn(rv, lookingGlass, sgCamera);
        return rv;
    }

    private static Vector4 transformFromCameraToViewport_AffectReturnValuePassedIn(Vector4 rv, LookingGlass lookingGlass, AbstractCamera sgCamera, Rectangle actualViewport) {
        TransformationUtilities.transformFromCameraToProjection_AffectReturnValuePassedIn(rv, lookingGlass, sgCamera);
        TransformationUtilities.transformFromProjectionToViewport_AffectReturnValuePassedIn(rv, sgCamera, actualViewport);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector4 transformFromViewportToCamera_AffectReturnValuePassedIn(Vector4 rv, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        Rectangle rectangle = s_actualViewportBuffer;
        synchronized (rectangle) {
            lookingGlass.getActualViewport(s_actualViewportBuffer, sgCamera);
            TransformationUtilities.transformFromViewportToCamera_AffectReturnValuePassedIn(rv, lookingGlass, sgCamera, s_actualViewportBuffer);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector4 transformFromCameraToViewport_AffectReturnValuePassedIn(Vector4 rv, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        Rectangle rectangle = s_actualViewportBuffer;
        synchronized (rectangle) {
            lookingGlass.getActualViewport(s_actualViewportBuffer, sgCamera);
            TransformationUtilities.transformFromCameraToViewport_AffectReturnValuePassedIn(rv, lookingGlass, sgCamera, s_actualViewportBuffer);
        }
        return rv;
    }

    public static Vector4 transformFromViewportToCamera(Vector4 rv, Vector4 xyzw, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        rv.set(xyzw);
        return TransformationUtilities.transformFromViewportToCamera_AffectReturnValuePassedIn(rv, lookingGlass, sgCamera);
    }

    public static Vector4 transformFromCameraToViewport(Vector4 rv, Vector4 xyzw, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        rv.set(xyzw);
        return TransformationUtilities.transformFromCameraToViewport_AffectReturnValuePassedIn(rv, lookingGlass, sgCamera);
    }

    public static Vector4 transformFromViewportToCamera_New(Vector4 xyzw, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        return TransformationUtilities.transformFromViewportToCamera(new Vector4(), xyzw, lookingGlass, sgCamera);
    }

    public static Vector4 transformFromCameraToViewport_New(Vector4 xyzw, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        return TransformationUtilities.transformFromCameraToViewport(new Vector4(), xyzw, lookingGlass, sgCamera);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector4 transformFromAWTToCamera(Vector4 rv, Point p, double z, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        Rectangle rectangle = s_actualViewportBuffer;
        synchronized (rectangle) {
            lookingGlass.getActualViewport(s_actualViewportBuffer, sgCamera);
            TransformationUtilities.transformFromAWTToViewport(rv, p, z, s_actualViewportBuffer);
            TransformationUtilities.transformFromViewportToCamera_AffectReturnValuePassedIn(rv, lookingGlass, sgCamera, s_actualViewportBuffer);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point transformFromCameraToAWT(Point rv, Vector4 xyzw, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        Vector4 vector4 = s_vector4dBuffer;
        synchronized (vector4) {
            s_vector4dBuffer.set(xyzw);
            Rectangle rectangle = s_actualViewportBuffer;
            synchronized (rectangle) {
                lookingGlass.getActualViewport(s_actualViewportBuffer, sgCamera);
                TransformationUtilities.transformFromCameraToViewport_AffectReturnValuePassedIn(s_vector4dBuffer, lookingGlass, sgCamera, s_actualViewportBuffer);
                TransformationUtilities.transformFromViewportToAWT(rv, s_vector4dBuffer, s_actualViewportBuffer);
            }
        }
        return rv;
    }

    public static Point3 transformFromAWTToCamera_NewPoint3d(Point p, double z, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        Vector4 xyzw = TransformationUtilities.transformFromAWTToCamera(new Vector4(), p, z, lookingGlass, sgCamera);
        return new Point3(xyzw.x / xyzw.w, xyzw.y / xyzw.w, xyzw.z / xyzw.w);
    }

    public static Vector4 transformFromAWTToCamera_NewVector4d(Point p, double z, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        return TransformationUtilities.transformFromAWTToCamera(new Vector4(), p, z, lookingGlass, sgCamera);
    }

    public static Point transformFromCameraToAWT_New(Vector4 xyzw, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        return TransformationUtilities.transformFromCameraToAWT(new Point(), xyzw, lookingGlass, sgCamera);
    }

    public static Point transformFromCameraToAWT_New(Point3 xyzw, LookingGlass lookingGlass, AbstractCamera sgCamera) {
        return TransformationUtilities.transformFromCameraToAWT(new Point(), new Vector4(xyzw.x, xyzw.y, xyzw.z, 1.0), lookingGlass, sgCamera);
    }
}

