/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.equivalence.EquivalenceUtilities;
import edu.cmu.cs.dennisc.math.Matrix3x3;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Tuple3f;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.print.Printable;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMatrix3x3
implements BinaryEncodableAndDecodable,
Printable {
    public final Vector3 right = Vector3.createPositiveXAxis();
    public final Vector3 up = Vector3.createPositiveYAxis();
    public final Vector3 backward = Vector3.createPositiveZAxis();

    @Override
    public void decode(BinaryDecoder binaryDecoder) {
        this.right.decode(binaryDecoder);
        this.up.decode(binaryDecoder);
        this.backward.decode(binaryDecoder);
    }

    @Override
    public void encode(BinaryEncoder binaryEncoder) {
        this.right.encode(binaryEncoder);
        this.up.encode(binaryEncoder);
        this.backward.encode(binaryEncoder);
    }

    @Override
    public StringBuffer append(StringBuffer rv, DecimalFormat decimalFormat, boolean isLines) {
        int j;
        int i;
        int n;
        if (isLines) {
            n = decimalFormat.format(0.0).length() + 1;
            rv.append("+-");
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < n; ++j) {
                    rv.append(' ');
                }
            }
            rv.append("-+\n");
        }
        if (isLines) {
            rv.append("| ");
        } else {
            rv.append("[ ");
        }
        rv.append(decimalFormat.format(this.right.x));
        rv.append(' ');
        rv.append(decimalFormat.format(this.up.x));
        rv.append(' ');
        rv.append(decimalFormat.format(this.backward.x));
        if (isLines) {
            rv.append("  |\n");
        } else {
            rv.append("  ] ");
        }
        if (isLines) {
            rv.append("| ");
        } else {
            rv.append("[ ");
        }
        rv.append(decimalFormat.format(this.right.y));
        rv.append(' ');
        rv.append(decimalFormat.format(this.up.y));
        rv.append(' ');
        rv.append(decimalFormat.format(this.backward.y));
        if (isLines) {
            rv.append("  |\n");
        } else {
            rv.append("  ] ");
        }
        if (isLines) {
            rv.append("| ");
        } else {
            rv.append("[ ");
        }
        rv.append(decimalFormat.format(this.right.z));
        rv.append(' ');
        rv.append(decimalFormat.format(this.up.z));
        rv.append(' ');
        rv.append(decimalFormat.format(this.backward.z));
        if (isLines) {
            rv.append("  |\n");
        } else {
            rv.append("  ] ");
        }
        if (isLines) {
            n = decimalFormat.format(0.0).length() + 1;
            rv.append("+-");
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < n; ++j) {
                    rv.append(' ');
                }
            }
            rv.append("-+\n");
        }
        return rv;
    }

    public boolean isWithinEpsilonOfUnitLengthSquared(double epsilon) {
        return this.right.isWithinEpsilonOfUnitLengthSquared(epsilon) && this.up.isWithinEpsilonOfUnitLengthSquared(epsilon) && this.backward.isWithinEpsilonOfUnitLengthSquared(epsilon);
    }

    public boolean isWithinReasonableEpsilonOfUnitLengthSquared() {
        return this.isWithinEpsilonOfUnitLengthSquared(0.001);
    }

    protected void setValue(AbstractMatrix3x3 other) {
        this.right.set(other.right);
        this.up.set(other.up);
        this.backward.set(other.backward);
    }

    public static AbstractMatrix3x3 setReturnValueToNaN(AbstractMatrix3x3 rv) {
        rv.right.setNaN();
        rv.up.setNaN();
        rv.backward.setNaN();
        return rv;
    }

    public void setNaN() {
        AbstractMatrix3x3.setReturnValueToNaN(this);
    }

    public boolean isNaN() {
        return this.right.isNaN() || this.up.isNaN() || this.backward.isNaN();
    }

    public static AbstractMatrix3x3 setReturnValueToIdentity(AbstractMatrix3x3 rv) {
        rv.right.set(1.0, 0.0, 0.0);
        rv.up.set(0.0, 1.0, 0.0);
        rv.backward.set(0.0, 0.0, 1.0);
        return rv;
    }

    public void setIdentity() {
        AbstractMatrix3x3.setReturnValueToIdentity(this);
    }

    public boolean isIdentity() {
        return this.right.isPositiveXAxis() && this.up.isPositiveYAxis() && this.backward.isPositiveZAxis();
    }

    public double[] getAsColumnMajorArray16(double[] rv) {
        assert (rv.length == 16);
        rv[0] = this.right.x;
        rv[1] = this.right.y;
        rv[2] = this.right.z;
        rv[3] = 0.0;
        rv[4] = this.up.x;
        rv[5] = this.up.y;
        rv[6] = this.up.z;
        rv[7] = 0.0;
        rv[8] = this.backward.x;
        rv[9] = this.backward.y;
        rv[10] = this.backward.z;
        rv[11] = 0.0;
        rv[12] = 0.0;
        rv[13] = 0.0;
        rv[14] = 0.0;
        rv[15] = 1.0;
        return rv;
    }

    public double[] getAsColumnMajorArray16() {
        return this.getAsColumnMajorArray16(new double[16]);
    }

    private void set(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.right.x = m00;
        this.up.x = m01;
        this.backward.x = m02;
        this.right.y = m10;
        this.up.y = m11;
        this.backward.y = m12;
        this.right.z = m20;
        this.up.z = m21;
        this.backward.z = m22;
    }

    public void set(Vector3 right, Vector3 up, Vector3 backward) {
        this.right.set(right);
        this.up.set(up);
        this.backward.set(backward);
    }

    private void scale(double d) {
        this.right.multiply(d);
        this.up.multiply(d);
        this.backward.multiply(d);
    }

    public double determinate() {
        return this.right.x * this.up.y * this.backward.z + this.right.y * this.up.z * this.backward.x + this.right.z * this.up.x * this.backward.y - this.right.x * this.up.z * this.backward.y - this.right.z * this.up.y * this.backward.x - this.right.y * this.up.x * this.backward.z;
    }

    public void invert() {
        double d = this.determinate();
        this.set(this.up.y * this.backward.z - this.backward.y * this.up.z, this.backward.x * this.up.z - this.up.x * this.backward.z, this.up.x * this.backward.y - this.backward.x * this.up.y, this.backward.y * this.right.z - this.right.y * this.backward.z, this.right.x * this.backward.z - this.backward.x * this.right.z, this.backward.x * this.right.y - this.right.x * this.backward.y, this.right.y * this.up.z - this.up.y * this.right.z, this.up.x * this.right.z - this.right.x * this.up.z, this.right.x * this.up.y - this.up.x * this.right.y);
        this.scale(1.0 / d);
    }

    protected void setToMultiplication(AbstractMatrix3x3 a, AbstractMatrix3x3 b) {
        double m00 = a.right.x * b.right.x + a.up.x * b.right.y + a.backward.x * b.right.z;
        double m01 = a.right.x * b.up.x + a.up.x * b.up.y + a.backward.x * b.up.z;
        double m02 = a.right.x * b.backward.x + a.up.x * b.backward.y + a.backward.x * b.backward.z;
        double m10 = a.right.y * b.right.x + a.up.y * b.right.y + a.backward.y * b.right.z;
        double m11 = a.right.y * b.up.x + a.up.y * b.up.y + a.backward.y * b.up.z;
        double m12 = a.right.y * b.backward.x + a.up.y * b.backward.y + a.backward.y * b.backward.z;
        double m20 = a.right.z * b.right.x + a.up.z * b.right.y + a.backward.z * b.right.z;
        double m21 = a.right.z * b.up.x + a.up.z * b.up.y + a.backward.z * b.up.z;
        double m22 = a.right.z * b.backward.x + a.up.z * b.backward.y + a.backward.z * b.backward.z;
        this.right.x = m00;
        this.up.x = m01;
        this.backward.x = m02;
        this.right.y = m10;
        this.up.y = m11;
        this.backward.y = m12;
        this.right.z = m20;
        this.up.z = m21;
        this.backward.z = m22;
    }

    protected void applyMultiplication(AbstractMatrix3x3 b) {
        this.setToMultiplication(this, b);
    }

    public <E extends Tuple3> E transform(E rv) {
        double x = this.right.x * rv.x + this.up.x * rv.y + this.backward.x * rv.z;
        double y = this.right.y * rv.x + this.up.y * rv.y + this.backward.y * rv.z;
        double z = this.right.z * rv.x + this.up.z * rv.y + this.backward.z * rv.z;
        rv.x = x;
        rv.y = y;
        rv.z = z;
        return rv;
    }

    public <E extends Tuple3f> E transform(E rv) {
        float x = (float)(this.right.x * (double)rv.x + this.up.x * (double)rv.y + this.backward.x * (double)rv.z);
        float y = (float)(this.right.y * (double)rv.x + this.up.y * (double)rv.y + this.backward.y * (double)rv.z);
        float z = (float)(this.right.z * (double)rv.x + this.up.z * (double)rv.y + this.backward.z * (double)rv.z);
        rv.x = x;
        rv.y = y;
        rv.z = z;
        return rv;
    }

    public Vector3 createForward() {
        return Vector3.createNegation(this.backward);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Matrix3x3) {
            Matrix3x3 other = (Matrix3x3)o;
            return EquivalenceUtilities.areEquivalent(this.right, other.right) && EquivalenceUtilities.areEquivalent(this.up, other.up) && EquivalenceUtilities.areEquivalent(this.backward, other.backward);
        }
        return false;
    }

    public int hashCode() {
        int rv = 17;
        if (this.right != null) {
            rv = 37 * rv + this.right.hashCode();
        }
        if (this.up != null) {
            rv = 37 * rv + this.up.hashCode();
        }
        if (this.backward != null) {
            rv = 37 * rv + this.backward.hashCode();
        }
        return rv;
    }
}

