/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.equivalence.EquivalenceUtilities;
import edu.cmu.cs.dennisc.math.AbstractMatrix4x4;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AxisRotation;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Orientation;
import edu.cmu.cs.dennisc.math.OrthogonalMatrix3x3;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Point3f;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.Vector3f;
import edu.cmu.cs.dennisc.math.Vector4;
import edu.cmu.cs.dennisc.math.Vector4f;

public class AffineMatrix4x4
extends AbstractMatrix4x4
implements BinaryEncodableAndDecodable {
    public final OrthogonalMatrix3x3 orientation = OrthogonalMatrix3x3.createIdentity();
    public final Point3 translation = new Point3();
    private static final AffineMatrix4x4 IDENTITY = AffineMatrix4x4.createNaN();

    public AffineMatrix4x4() {
    }

    public AffineMatrix4x4(AffineMatrix4x4 other) {
        this.set(other);
    }

    public AffineMatrix4x4(Orientation orientation, Point3 translation) {
        this.set(orientation, translation);
    }

    @Deprecated
    public AffineMatrix4x4(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        this.set(new Matrix4x4(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33));
    }

    public AffineMatrix4x4(Matrix4x4 other) {
        this.set(other);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.orientation.decode(binaryDecoder);
        this.translation.decode(binaryDecoder);
    }

    public void encode(BinaryEncoder binaryEncoder) {
        this.orientation.encode(binaryEncoder);
        this.translation.encode(binaryEncoder);
    }

    public double[] getAsColumnMajorArray16(double[] rv) {
        assert (rv.length == 16);
        rv[0] = this.orientation.right.x;
        rv[1] = this.orientation.right.y;
        rv[2] = this.orientation.right.z;
        rv[3] = 0.0;
        rv[4] = this.orientation.up.x;
        rv[5] = this.orientation.up.y;
        rv[6] = this.orientation.up.z;
        rv[7] = 0.0;
        rv[8] = this.orientation.backward.x;
        rv[9] = this.orientation.backward.y;
        rv[10] = this.orientation.backward.z;
        rv[11] = 0.0;
        rv[12] = this.translation.x;
        rv[13] = this.translation.y;
        rv[14] = this.translation.z;
        rv[15] = 1.0;
        return rv;
    }

    public boolean isAffine() {
        return true;
    }

    public static AffineMatrix4x4 setReturnValueToNaN(AffineMatrix4x4 rv) {
        rv.orientation.setNaN();
        rv.translation.setNaN();
        return rv;
    }

    public static AffineMatrix4x4 createNaN() {
        return AffineMatrix4x4.setReturnValueToNaN(new AffineMatrix4x4());
    }

    public void setNaN() {
        AffineMatrix4x4.setReturnValueToNaN(this);
    }

    public boolean isNaN() {
        return this.orientation.isNaN() || this.translation.isNaN();
    }

    public static AffineMatrix4x4 accessIdentity() {
        IDENTITY.setIdentity();
        return IDENTITY;
    }

    public static AffineMatrix4x4 setReturnValueToIdentity(AffineMatrix4x4 rv) {
        rv.orientation.setIdentity();
        rv.translation.setZero();
        return rv;
    }

    public static AffineMatrix4x4 createIdentity() {
        return AffineMatrix4x4.setReturnValueToIdentity(AffineMatrix4x4.createNaN());
    }

    public void setIdentity() {
        AffineMatrix4x4.setReturnValueToIdentity(this);
    }

    public boolean isIdentity() {
        return this.orientation.isIdentity() && this.translation.isZero();
    }

    private static AffineMatrix4x4 setReturnValueToTranslation(AffineMatrix4x4 rv, double x, double y, double z) {
        rv.translation.set(x, y, z);
        rv.orientation.setIdentity();
        return rv;
    }

    public static AffineMatrix4x4 createTranslation(double x, double y, double z) {
        return AffineMatrix4x4.setReturnValueToTranslation(AffineMatrix4x4.createNaN(), x, y, z);
    }

    public static AffineMatrix4x4 createTranslation(Point3 translation) {
        return AffineMatrix4x4.createTranslation(translation.x, translation.y, translation.z);
    }

    public static AffineMatrix4x4 createTranslationAlongXAxis(double x) {
        return AffineMatrix4x4.setReturnValueToTranslation(AffineMatrix4x4.createNaN(), x, 0.0, 0.0);
    }

    public static AffineMatrix4x4 createTranslationAlongYAxis(double y) {
        return AffineMatrix4x4.setReturnValueToTranslation(AffineMatrix4x4.createNaN(), 0.0, y, 0.0);
    }

    public static AffineMatrix4x4 createTranslationAlongZAxis(double z) {
        return AffineMatrix4x4.setReturnValueToTranslation(AffineMatrix4x4.createNaN(), 0.0, 0.0, z);
    }

    public void applyTranslationAlongXAxis(double x) {
        this.multiply(AffineMatrix4x4.createTranslationAlongXAxis(x));
    }

    public void applyTranslationAlongYAxis(double y) {
        this.multiply(AffineMatrix4x4.createTranslationAlongYAxis(y));
    }

    public void applyTranslationAlongZAxis(double z) {
        this.multiply(AffineMatrix4x4.createTranslationAlongZAxis(z));
    }

    public void applyTranslation(double x, double y, double z) {
        this.multiply(AffineMatrix4x4.createTranslation(x, y, z));
    }

    public void applyTranslation(Point3 translation) {
        this.applyTranslation(translation.x, translation.y, translation.z);
    }

    public static AffineMatrix4x4 setReturnValueToOrientation(AffineMatrix4x4 rv, Orientation orientation) {
        rv.translation.setZero();
        orientation.getValue(rv.orientation);
        return rv;
    }

    public static AffineMatrix4x4 createOrientation(Orientation orientation) {
        return AffineMatrix4x4.setReturnValueToOrientation(AffineMatrix4x4.createNaN(), orientation);
    }

    public static AffineMatrix4x4 createRotationAboutXAxis(Angle angle) {
        return AffineMatrix4x4.setReturnValueToOrientation(AffineMatrix4x4.createNaN(), AxisRotation.createXAxisRotation(angle));
    }

    public static AffineMatrix4x4 createRotationAboutYAxis(Angle angle) {
        return AffineMatrix4x4.setReturnValueToOrientation(AffineMatrix4x4.createNaN(), AxisRotation.createYAxisRotation(angle));
    }

    public static AffineMatrix4x4 createRotationAboutZAxis(Angle angle) {
        return AffineMatrix4x4.setReturnValueToOrientation(AffineMatrix4x4.createNaN(), AxisRotation.createZAxisRotation(angle));
    }

    public void applyOrientation(Orientation orientation) {
        this.multiply(AffineMatrix4x4.createOrientation(orientation));
    }

    public void applyRotationAboutXAxis(Angle angle) {
        this.multiply(AffineMatrix4x4.createRotationAboutXAxis(angle));
    }

    public void applyRotationAboutYAxis(Angle angle) {
        this.multiply(AffineMatrix4x4.createRotationAboutYAxis(angle));
    }

    public void applyRotationAboutZAxis(Angle angle) {
        this.multiply(AffineMatrix4x4.createRotationAboutZAxis(angle));
    }

    public void set(AffineMatrix4x4 other) {
        this.orientation.setValue(other.orientation);
        this.translation.set(other.translation);
    }

    public void set(Orientation orientation, Point3 translation) {
        orientation.getValue(this.orientation);
        this.translation.set(translation);
    }

    public void set(Matrix4x4 other) {
        assert (other.isWithinReasonableEpsilonOfAffine());
        this.orientation.right.set(other.right.x, other.right.y, other.right.z);
        this.orientation.up.set(other.up.x, other.up.y, other.up.z);
        this.orientation.backward.set(other.backward.x, other.backward.y, other.backward.z);
        this.translation.set(other.translation.x, other.translation.y, other.translation.z);
    }

    private void set(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23) {
        this.orientation.right.x = m00;
        this.orientation.right.y = m10;
        this.orientation.right.z = m20;
        this.orientation.up.x = m01;
        this.orientation.up.y = m11;
        this.orientation.up.z = m21;
        this.orientation.backward.x = m02;
        this.orientation.backward.y = m12;
        this.orientation.backward.z = m22;
        this.translation.x = m03;
        this.translation.y = m13;
        this.translation.z = m23;
    }

    public static AffineMatrix4x4 setReturnValueToMultiplication(AffineMatrix4x4 rv, AffineMatrix4x4 a, AffineMatrix4x4 b) {
        double m00 = a.orientation.right.x * b.orientation.right.x + a.orientation.up.x * b.orientation.right.y + a.orientation.backward.x * b.orientation.right.z;
        double m01 = a.orientation.right.x * b.orientation.up.x + a.orientation.up.x * b.orientation.up.y + a.orientation.backward.x * b.orientation.up.z;
        double m02 = a.orientation.right.x * b.orientation.backward.x + a.orientation.up.x * b.orientation.backward.y + a.orientation.backward.x * b.orientation.backward.z;
        double m03 = a.orientation.right.x * b.translation.x + a.orientation.up.x * b.translation.y + a.orientation.backward.x * b.translation.z + a.translation.x;
        double m10 = a.orientation.right.y * b.orientation.right.x + a.orientation.up.y * b.orientation.right.y + a.orientation.backward.y * b.orientation.right.z;
        double m11 = a.orientation.right.y * b.orientation.up.x + a.orientation.up.y * b.orientation.up.y + a.orientation.backward.y * b.orientation.up.z;
        double m12 = a.orientation.right.y * b.orientation.backward.x + a.orientation.up.y * b.orientation.backward.y + a.orientation.backward.y * b.orientation.backward.z;
        double m13 = a.orientation.right.y * b.translation.x + a.orientation.up.y * b.translation.y + a.orientation.backward.y * b.translation.z + a.translation.y;
        double m20 = a.orientation.right.z * b.orientation.right.x + a.orientation.up.z * b.orientation.right.y + a.orientation.backward.z * b.orientation.right.z;
        double m21 = a.orientation.right.z * b.orientation.up.x + a.orientation.up.z * b.orientation.up.y + a.orientation.backward.z * b.orientation.up.z;
        double m22 = a.orientation.right.z * b.orientation.backward.x + a.orientation.up.z * b.orientation.backward.y + a.orientation.backward.z * b.orientation.backward.z;
        double m23 = a.orientation.right.z * b.translation.x + a.orientation.up.z * b.translation.y + a.orientation.backward.z * b.translation.z + a.translation.z;
        rv.orientation.right.x = m00;
        rv.orientation.right.y = m10;
        rv.orientation.right.z = m20;
        rv.orientation.up.x = m01;
        rv.orientation.up.y = m11;
        rv.orientation.up.z = m21;
        rv.orientation.backward.x = m02;
        rv.orientation.backward.y = m12;
        rv.orientation.backward.z = m22;
        rv.translation.x = m03;
        rv.translation.y = m13;
        rv.translation.z = m23;
        return rv;
    }

    public static AffineMatrix4x4 createMultiplication(AffineMatrix4x4 a, AffineMatrix4x4 b) {
        return AffineMatrix4x4.setReturnValueToMultiplication(new AffineMatrix4x4(), a, b);
    }

    public void setToMultiplication(AffineMatrix4x4 a, AffineMatrix4x4 b) {
        AffineMatrix4x4.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(AffineMatrix4x4 b) {
        this.setToMultiplication(this, b);
    }

    public double calculateDeterminate() {
        double m00 = this.orientation.right.x;
        double m10 = this.orientation.right.y;
        double m20 = this.orientation.right.z;
        double m01 = this.orientation.up.x;
        double m11 = this.orientation.up.y;
        double m21 = this.orientation.up.z;
        double m02 = this.orientation.backward.x;
        double m12 = this.orientation.backward.y;
        double m22 = this.orientation.backward.z;
        return m02 * m11 * m20 + m01 * m12 * m20 + m02 * m10 * m21 - m00 * m12 * m21 - m01 * m10 * m22 + m00 * m11 * m22;
    }

    public static AffineMatrix4x4 setReturnValueToInverse(AffineMatrix4x4 rv, AffineMatrix4x4 a) {
        Matrix4x4 m = new Matrix4x4(a);
        m.invert();
        rv.set(m);
        return rv;
    }

    public static AffineMatrix4x4 createInverse(AffineMatrix4x4 a) {
        return AffineMatrix4x4.setReturnValueToInverse(new AffineMatrix4x4(), a);
    }

    public void setToInverse(AffineMatrix4x4 a) {
        AffineMatrix4x4.setReturnValueToInverse(this, a);
    }

    public void invert() {
        this.setToInverse(this);
    }

    public Vector4 setReturnValueToTransformed(Vector4 rv, Vector4 b) {
        return new Matrix4x4(this).setReturnValueToTransformed(rv, b);
    }

    public Vector3 setReturnValueToTransformed(Vector3 rv, Vector3 b) {
        return new Matrix4x4(this).setReturnValueToTransformed(rv, b);
    }

    public Point3 setReturnValueToTransformed(Point3 rv, Point3 b) {
        return new Matrix4x4(this).setReturnValueToTransformed(rv, b);
    }

    public Vector4f setReturnValueToTransformed(Vector4f rv, Vector4f b) {
        return new Matrix4x4(this).setReturnValueToTransformed(rv, b);
    }

    public Vector3f setReturnValueToTransformed(Vector3f rv, Vector3f b) {
        return new Matrix4x4(this).setReturnValueToTransformed(rv, b);
    }

    public Point3f setReturnValueToTransformed(Point3f rv, Point3f b) {
        return new Matrix4x4(this).setReturnValueToTransformed(rv, b);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AffineMatrix4x4) {
            AffineMatrix4x4 other = (AffineMatrix4x4)o;
            return EquivalenceUtilities.areEquivalent(this.orientation, other.orientation) && EquivalenceUtilities.areEquivalent(this.translation, other.translation);
        }
        return false;
    }

    public int hashCode() {
        int rv = 17;
        if (this.orientation != null) {
            rv = 37 * rv + this.orientation.hashCode();
        }
        if (this.orientation != null) {
            rv = 37 * rv + this.translation.hashCode();
        }
        return rv;
    }
}

