/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleUtilities;
import edu.cmu.cs.dennisc.math.InterpolationUtilities;

public class AngleInRadians
implements Angle {
    private double m_radians;

    public AngleInRadians(double radians) {
        this.m_radians = radians;
    }

    public AngleInRadians(Angle other) {
        this(other.getAsRadians());
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.m_radians = binaryDecoder.decodeDouble();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.m_radians);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Angle) {
            Angle a = (Angle)obj;
            return this.m_radians == a.getAsRadians();
        }
        return false;
    }

    public boolean isNaN() {
        return Double.isNaN(this.m_radians);
    }

    public void setNaN() {
        this.m_radians = Double.NaN;
    }

    public double getAsRadians() {
        return this.m_radians;
    }

    public double getAsDegrees() {
        return AngleUtilities.radiansToDegrees(this.m_radians);
    }

    public double getAsRevolutions() {
        return AngleUtilities.radiansToRevolutions(this.m_radians);
    }

    public void setAsRadians(double radians) {
        this.m_radians = radians;
    }

    public void setAsDegrees(double degrees) {
        this.m_radians = AngleUtilities.degreesToRadians(degrees);
    }

    public void setAsRevolutions(double revolutions) {
        this.m_radians = AngleUtilities.revolutionsToRadians(revolutions);
    }

    public Angle createCopy() {
        return new AngleInRadians(this);
    }

    public void set(Angle other) {
        this.setAsRadians(other.getAsRadians());
    }

    public void setToInterpolation(Angle a0, Angle a1, double portion) {
        this.setAsRadians(InterpolationUtilities.interpolate(a0.getAsRadians(), a1.getAsRadians(), portion));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[");
        sb.append(this.m_radians);
        sb.append("]");
        return sb.toString();
    }
}

