/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleInDegrees;
import edu.cmu.cs.dennisc.math.AngleUtilities;
import edu.cmu.cs.dennisc.math.InterpolationUtilities;

public class AngleInRevolutions
implements Angle {
    private double m_revolutions;

    public AngleInRevolutions(double revolutions) {
        this.setAsRevolutions(revolutions);
    }

    public AngleInRevolutions(Angle other) {
        this.set(other);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.m_revolutions = binaryDecoder.decodeDouble();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.m_revolutions);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Angle) {
            Angle a = (Angle)obj;
            return this.m_revolutions == a.getAsRevolutions();
        }
        return false;
    }

    public boolean isNaN() {
        return Double.isNaN(this.m_revolutions);
    }

    public void setNaN() {
        this.m_revolutions = Double.NaN;
    }

    public double getAsRadians() {
        return AngleUtilities.revolutionsToRadians(this.m_revolutions);
    }

    public double getAsDegrees() {
        return AngleUtilities.revolutionsToDegrees(this.m_revolutions);
    }

    public double getAsRevolutions() {
        return this.m_revolutions;
    }

    public void setAsRadians(double radians) {
        this.m_revolutions = AngleUtilities.radiansToRevolutions(radians);
    }

    public void setAsDegrees(double degrees) {
        this.m_revolutions = AngleUtilities.degreesToRevolutions(degrees);
    }

    public void setAsRevolutions(double revolutions) {
        this.m_revolutions = revolutions;
    }

    public Angle createCopy() {
        return new AngleInDegrees(this);
    }

    public void set(Angle other) {
        this.setAsRevolutions(other.getAsRevolutions());
    }

    public void setToInterpolation(Angle a0, Angle a1, double portion) {
        this.setAsRevolutions(InterpolationUtilities.interpolate(a0.getAsRevolutions(), a1.getAsRevolutions(), portion));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[");
        sb.append(this.m_revolutions);
        sb.append("]");
        return sb.toString();
    }
}

