/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.math.Hexahedron;
import edu.cmu.cs.dennisc.math.Matrix3x3;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import java.io.Serializable;

public class AxisAlignedBox
implements Serializable {
    protected Point3 m_minimum = new Point3();
    protected Point3 m_maximum = new Point3();

    public AxisAlignedBox() {
        this.setNaN();
    }

    public AxisAlignedBox(Point3 minimum, Point3 maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
    }

    public AxisAlignedBox(double minimumX, double minimumY, double minimumZ, double maximumX, double maximumY, double maximumZ) {
        this.setMinimum(minimumX, minimumY, minimumZ);
        this.setMaximum(maximumX, maximumY, maximumZ);
    }

    public AxisAlignedBox(AxisAlignedBox other) {
        this.set(other);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof AxisAlignedBox) {
            AxisAlignedBox box = (AxisAlignedBox)o;
            return this.m_minimum.equals(box.m_minimum) && this.m_maximum.equals(box.m_maximum);
        }
        return false;
    }

    public void set(AxisAlignedBox other) {
        if (other != null) {
            this.m_minimum.set(other.m_minimum);
            this.m_maximum.set(other.m_maximum);
        } else {
            this.setNaN();
        }
    }

    public boolean isNaN() {
        return this.m_minimum.isNaN() || this.m_maximum.isNaN();
    }

    public void setNaN() {
        this.m_minimum.set(Double.NaN, Double.NaN, Double.NaN);
        this.m_maximum.set(Double.NaN, Double.NaN, Double.NaN);
    }

    public Point3 getMinimum(Point3 rv) {
        rv.set(this.m_minimum);
        return rv;
    }

    public Point3 getMinimum() {
        return this.getMinimum(new Point3());
    }

    public void setMinimum(Point3 minimum) {
        if (minimum == null) {
            this.m_minimum.set(Double.NaN, Double.NaN, Double.NaN);
        } else {
            this.m_minimum.set(minimum);
        }
    }

    public void setMinimum(double x, double y, double z) {
        this.m_minimum.set(x, y, z);
    }

    public Point3 getMaximum(Point3 rv) {
        rv.set(this.m_maximum);
        return rv;
    }

    public Point3 getMaximum() {
        return this.getMaximum(new Point3());
    }

    public void setMaximum(Point3 maximum) {
        if (maximum == null) {
            this.m_maximum.set(Double.NaN, Double.NaN, Double.NaN);
        } else {
            this.m_maximum.set(maximum);
        }
    }

    public void setMaximum(double x, double y, double z) {
        this.m_maximum.set(x, y, z);
    }

    public double getXMinimum() {
        return this.m_minimum.x;
    }

    public void setXMinimum(double v) {
        this.m_minimum.x = v;
    }

    public double getYMinimum() {
        return this.m_minimum.y;
    }

    public void setYMinimum(double v) {
        this.m_minimum.y = v;
    }

    public double getZMinimum() {
        return this.m_minimum.z;
    }

    public void setZMinimum(double v) {
        this.m_minimum.z = v;
    }

    public double getXMaximum() {
        return this.m_maximum.x;
    }

    public void setXMaximum(double v) {
        this.m_maximum.x = v;
    }

    public double getYMaximum() {
        return this.m_maximum.y;
    }

    public void setYMaximum(double v) {
        this.m_maximum.y = v;
    }

    public double getZMaximum() {
        return this.m_maximum.z;
    }

    public void setZMaximum(double v) {
        this.m_maximum.z = v;
    }

    public Point3 getCenter(Point3 rv) {
        rv.set((this.m_minimum.x + this.m_maximum.x) / 2.0, (this.m_minimum.y + this.m_maximum.y) / 2.0, (this.m_minimum.z + this.m_maximum.z) / 2.0);
        return rv;
    }

    public Point3 getCenter() {
        return this.getCenter(new Point3());
    }

    public Point3 getCenterOfFrontFace(Point3 rv) {
        rv.set((this.m_minimum.x + this.m_maximum.x) / 2.0, (this.m_minimum.y + this.m_maximum.y) / 2.0, this.m_minimum.z);
        return rv;
    }

    public Point3 getCenterOfFrontFace() {
        return this.getCenterOfFrontFace(new Point3());
    }

    public Point3 getCenterOfBackFace(Point3 rv) {
        rv.set((this.m_minimum.x + this.m_maximum.x) / 2.0, (this.m_minimum.y + this.m_maximum.y) / 2.0, this.m_maximum.z);
        return rv;
    }

    public Point3 getCenterOfBackFace() {
        return this.getCenterOfBackFace(new Point3());
    }

    public Point3 getCenterOfLeftFace(Point3 rv) {
        rv.set(this.m_minimum.x, (this.m_minimum.y + this.m_maximum.y) / 2.0, (this.m_minimum.z + this.m_maximum.z) / 2.0);
        return rv;
    }

    public Point3 getCenterOfLeftFace() {
        return this.getCenterOfLeftFace(new Point3());
    }

    public Point3 getCenterOfRightFace(Point3 rv) {
        rv.set(this.m_maximum.x, (this.m_minimum.y + this.m_maximum.y) / 2.0, (this.m_minimum.z + this.m_maximum.z) / 2.0);
        return rv;
    }

    public Point3 getCenterOfRightFace() {
        return this.getCenterOfRightFace(new Point3());
    }

    public Point3 getCenterOfTopFace(Point3 rv) {
        rv.set((this.m_minimum.x + this.m_maximum.x) / 2.0, this.m_maximum.y, (this.m_minimum.z + this.m_maximum.z) / 2.0);
        return rv;
    }

    public Point3 getCenterOfTopFace() {
        return this.getCenterOfTopFace(new Point3());
    }

    public Point3 getCenterOfBottomFace(Point3 rv) {
        rv.set((this.m_minimum.x + this.m_maximum.x) / 2.0, this.m_minimum.y, (this.m_minimum.z + this.m_maximum.z) / 2.0);
        return rv;
    }

    public Point3 getCenterOfBottomFace() {
        return this.getCenterOfBottomFace(new Point3());
    }

    public double getWidth() {
        return this.m_maximum.x - this.m_minimum.x;
    }

    public double getHeight() {
        return this.m_maximum.y - this.m_minimum.y;
    }

    public double getDepth() {
        return this.m_maximum.z - this.m_minimum.z;
    }

    public double getVolume() {
        return this.getWidth() * this.getHeight() * this.getDepth();
    }

    public void union(Point3 p) {
        this.m_minimum.x = Math.min(this.m_minimum.x, p.x);
        this.m_minimum.y = Math.min(this.m_minimum.y, p.y);
        this.m_minimum.z = Math.min(this.m_minimum.z, p.z);
        this.m_maximum.x = Math.max(this.m_maximum.x, p.x);
        this.m_maximum.y = Math.max(this.m_maximum.y, p.y);
        this.m_maximum.z = Math.max(this.m_maximum.z, p.z);
    }

    public void union(AxisAlignedBox other) {
        assert (other != null);
        if (this.isNaN()) {
            if (!other.isNaN()) {
                this.set(other);
            }
        } else if (!other.isNaN()) {
            this.m_minimum.x = Math.min(this.m_minimum.x, other.m_minimum.x);
            this.m_minimum.y = Math.min(this.m_minimum.y, other.m_minimum.y);
            this.m_minimum.z = Math.min(this.m_minimum.z, other.m_minimum.z);
            this.m_maximum.x = Math.max(this.m_maximum.x, other.m_maximum.x);
            this.m_maximum.y = Math.max(this.m_maximum.y, other.m_maximum.y);
            this.m_maximum.z = Math.max(this.m_maximum.z, other.m_maximum.z);
        }
    }

    public Hexahedron getHexahedron(Hexahedron rv) {
        Point3[] points = new Point3[]{new Point3(this.m_minimum.x, this.m_minimum.y, this.m_minimum.z), new Point3(this.m_maximum.x, this.m_minimum.y, this.m_minimum.z), new Point3(this.m_minimum.x, this.m_maximum.y, this.m_minimum.z), new Point3(this.m_maximum.x, this.m_maximum.y, this.m_minimum.z), new Point3(this.m_minimum.x, this.m_minimum.y, this.m_maximum.z), new Point3(this.m_maximum.x, this.m_minimum.y, this.m_maximum.z), new Point3(this.m_minimum.x, this.m_maximum.y, this.m_maximum.z), new Point3(this.m_maximum.x, this.m_maximum.y, this.m_maximum.z)};
        Vector3[] normals = new Vector3[]{new Vector3(1.0, 0.0, 0.0), new Vector3(-1.0, 0.0, 0.0), new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, -1.0, 0.0), new Vector3(0.0, 0.0, 1.0), new Vector3(0.0, 0.0, -1.0)};
        rv.set(points, normals);
        return rv;
    }

    public Hexahedron getHexahedron() {
        return this.getHexahedron(new Hexahedron());
    }

    public void translate(Vector3 v) {
        this.m_minimum.add(v);
        this.m_maximum.add(v);
    }

    public void scale(Matrix3x3 m) {
        double xScale = Tuple3.calculateMagnitude(m.right.x, m.right.y, m.right.z);
        double yScale = Tuple3.calculateMagnitude(m.up.x, m.up.y, m.up.z);
        double zScale = Tuple3.calculateMagnitude(m.backward.x, m.backward.y, m.backward.z);
        this.m_minimum.x *= xScale;
        this.m_maximum.x *= xScale;
        this.m_minimum.y *= yScale;
        this.m_maximum.y *= yScale;
        this.m_minimum.z *= zScale;
        this.m_maximum.z *= zScale;
    }

    public String toString() {
        return AxisAlignedBox.class.getName() + "[minimum=" + this.m_minimum + ",maximum=" + this.m_maximum + "]";
    }
}

