/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleInRadians;
import edu.cmu.cs.dennisc.math.EulerAngles;
import edu.cmu.cs.dennisc.math.ForwardAndUpGuide;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Orientation;
import edu.cmu.cs.dennisc.math.OrthogonalMatrix3x3;
import edu.cmu.cs.dennisc.math.UnitQuaternion;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.random.RandomUtilities;

public class AxisRotation
implements Orientation,
BinaryEncodableAndDecodable {
    public final Vector3 axis = Vector3.createNaN();
    public final Angle angle = new AngleInRadians(Double.NaN);

    private AxisRotation() {
    }

    public AxisRotation(Vector3 axis, Angle angle) {
        this.set(axis, angle);
    }

    public AxisRotation(OrthogonalMatrix3x3 other) {
        this.setValue(other);
    }

    public AxisRotation(UnitQuaternion other) {
        this.setValue(other);
    }

    public AxisRotation(AxisRotation other) {
        this.setValue(other);
    }

    public AxisRotation(EulerAngles other) {
        this.setValue(other);
    }

    public AxisRotation(ForwardAndUpGuide other) {
        this.setValue(other);
    }

    public OrthogonalMatrix3x3 createOrthogonalMatrix3x3() {
        return new OrthogonalMatrix3x3(this);
    }

    public UnitQuaternion createUnitQuaternion() {
        return new UnitQuaternion(this);
    }

    public AxisRotation createAxisRotation() {
        return new AxisRotation(this);
    }

    public EulerAngles createEulerAngles() {
        return new EulerAngles(this);
    }

    public ForwardAndUpGuide createForwardAndUpGuide() {
        return new ForwardAndUpGuide(this);
    }

    public OrthogonalMatrix3x3 getValue(OrthogonalMatrix3x3 rv) {
        rv.setValue(this);
        return rv;
    }

    public UnitQuaternion getValue(UnitQuaternion rv) {
        rv.setValue(this);
        return rv;
    }

    public AxisRotation getValue(AxisRotation rv) {
        rv.setValue(this);
        return rv;
    }

    public EulerAngles getValue(EulerAngles rv) {
        rv.setValue(this);
        return rv;
    }

    public ForwardAndUpGuide getValue(ForwardAndUpGuide rv) {
        rv.setValue(this);
        return rv;
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.axis.decode(binaryDecoder);
        this.angle.decode(binaryDecoder);
    }

    public void encode(BinaryEncoder binaryEncoder) {
        this.axis.encode(binaryEncoder);
        this.angle.encode(binaryEncoder);
    }

    public static AxisRotation createXAxisRotation(Angle angle) {
        return new AxisRotation(Vector3.accessPositiveXAxis(), angle);
    }

    public static AxisRotation createYAxisRotation(Angle angle) {
        return new AxisRotation(Vector3.accessPositiveYAxis(), angle);
    }

    public static AxisRotation createZAxisRotation(Angle angle) {
        return new AxisRotation(Vector3.accessPositiveZAxis(), angle);
    }

    public AxisRotation createCopy() {
        return this.createAxisRotation();
    }

    public static AxisRotation setReturnValueToNaN(AxisRotation rv) {
        rv.axis.setNaN();
        rv.angle.setNaN();
        return rv;
    }

    public static AxisRotation createNaN() {
        return AxisRotation.setReturnValueToNaN(new AxisRotation());
    }

    public void setNaN() {
        AxisRotation.setReturnValueToNaN(this);
    }

    public boolean isNaN() {
        return this.axis.isNaN() || this.angle.isNaN();
    }

    public static AxisRotation setReturnValueToIdentity(AxisRotation rv) {
        rv.axis.set(0.0, 0.0, 1.0);
        rv.angle.setAsRadians(0.0);
        return rv;
    }

    public static AxisRotation createIdentity() {
        return AxisRotation.setReturnValueToIdentity(AxisRotation.createNaN());
    }

    public void setIdentity() {
        AxisRotation.setReturnValueToIdentity(this);
    }

    public boolean isIdentity() {
        return this.axis.isPositiveXAxis() && this.angle.getAsRadians() == 0.0;
    }

    private boolean isWithinReasonableEpsilonOfZero(double d) {
        return Math.abs(d) < 0.001;
    }

    private void set(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        double thetaInRadians;
        if (this.isWithinReasonableEpsilonOfZero(m01 - m10) && this.isWithinReasonableEpsilonOfZero(m02 - m20) && this.isWithinReasonableEpsilonOfZero(m12 - m21)) {
            if (this.isWithinReasonableEpsilonOfZero(m01 + m10) && this.isWithinReasonableEpsilonOfZero(m02 + m20) && this.isWithinReasonableEpsilonOfZero(m12 + m21) && this.isWithinReasonableEpsilonOfZero(m12 + m21) && this.isWithinReasonableEpsilonOfZero(m00 + m11 + m22 - 3.0)) {
                thetaInRadians = 0.0;
                this.axis.set(0.0, 1.0, 0.0);
            } else {
                boolean isYZNegativeOrZero;
                thetaInRadians = Math.PI;
                double x = (m00 + 1.0) * 0.5;
                double y = (m11 + 1.0) * 0.5;
                double z = (m22 + 1.0) * 0.5;
                this.axis.x = x > 0.0 ? Math.sqrt(x) : 0.0;
                this.axis.y = y > 0.0 ? Math.sqrt(y) : 0.0;
                this.axis.z = z > 0.0 ? Math.sqrt(z) : 0.0;
                assert (!this.axis.isNaN());
                boolean isXZero = this.isWithinReasonableEpsilonOfZero(this.axis.x);
                boolean isYZero = this.isWithinReasonableEpsilonOfZero(this.axis.y);
                boolean isZZero = this.isWithinReasonableEpsilonOfZero(this.axis.z);
                boolean isXYNegativeOrZero = m01 <= 0.0;
                boolean isXZNegativeOrZero = m02 <= 0.0;
                boolean bl = isYZNegativeOrZero = m12 <= 0.0;
                if (isXZero && !isYZero && !isZZero) {
                    if (isYZNegativeOrZero) {
                        this.axis.y = -this.axis.y;
                    }
                } else if (isYZero && !isZZero) {
                    if (isXZNegativeOrZero) {
                        this.axis.z = -this.axis.z;
                    }
                } else if (isZZero && isXYNegativeOrZero) {
                    this.axis.x = -this.axis.x;
                }
                this.axis.normalize();
            }
        } else {
            double c = (m00 + m11 + m22 - 1.0) * 0.5;
            assert (Math.abs(c) <= 1.001);
            c = Math.max(c, -1.0);
            thetaInRadians = Math.acos(c = Math.min(c, 1.0));
            if (Double.isNaN(thetaInRadians)) {
                PrintUtilities.println("WARNING AxisRotationD isNaN");
            }
            assert (!Double.isNaN(thetaInRadians));
            this.axis.x = m21 - m12;
            this.axis.y = m02 - m20;
            this.axis.z = m10 - m01;
            this.axis.normalize();
        }
        this.angle.setAsRadians(thetaInRadians);
        assert (!this.isNaN());
    }

    @Deprecated
    public void setToOrientationComponentOf(Matrix4x4 m) {
        if (m.isNaN()) {
            this.setNaN();
        } else {
            this.set(m.right.x, m.up.x, m.backward.x, m.right.y, m.up.y, m.backward.y, m.right.z, m.up.z, m.backward.z);
        }
    }

    public void setValue(OrthogonalMatrix3x3 m) {
        if (m.isNaN()) {
            this.setNaN();
        } else {
            this.set(m.right.x, m.up.x, m.backward.x, m.right.y, m.up.y, m.backward.y, m.right.z, m.up.z, m.backward.z);
        }
    }

    public void setValue(AxisRotation other) {
        this.axis.set(other.axis);
        this.angle.set(other.angle);
    }

    public void setValue(UnitQuaternion q) {
        assert (Math.abs(q.w) <= 1.0);
        this.angle.setAsRadians(2.0 * Math.acos(q.w));
        double s = Math.sqrt(1.0 - q.w * q.w);
        double THESHOLD = 1.0E-4;
        if (s < 1.0E-4) {
            this.axis.set(1.0, 0.0, 0.0);
        } else {
            this.axis.set(q.x / s, q.y / s, q.z / s);
        }
    }

    public void setValue(EulerAngles ea) {
        this.setValue(new OrthogonalMatrix3x3(ea));
    }

    public void setValue(ForwardAndUpGuide faug) {
        this.setValue(new OrthogonalMatrix3x3(faug));
    }

    public void set(Vector3 axis, Angle angle) {
        this.axis.set(axis);
        this.angle.set(angle);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AxisRotation) {
            AxisRotation aa = (AxisRotation)o;
            return this.axis.equals(aa.axis) && this.angle.equals(aa.angle);
        }
        return false;
    }

    public static AxisRotation setReturnValueToRandom(AxisRotation rv) {
        double magnitudeSquared;
        do {
            rv.axis.x = RandomUtilities.nextDoubleInRange(-1, 1);
            rv.axis.y = RandomUtilities.nextDoubleInRange(-1, 1);
            rv.axis.z = RandomUtilities.nextDoubleInRange(-1, 1);
        } while ((magnitudeSquared = rv.axis.calculateMagnitudeSquared()) == 0.0);
        rv.axis.divide(Math.sqrt(magnitudeSquared));
        rv.angle.setAsRadians(RandomUtilities.nextDoubleInRange(-Math.PI, Math.PI));
        return rv;
    }

    public static AxisRotation createRandom() {
        return AxisRotation.setReturnValueToRandom(new AxisRotation());
    }

    public void setRandom() {
        AxisRotation.setReturnValueToRandom(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(AxisRotation.class.getName());
        sb.append("[axis=");
        sb.append(this.axis);
        sb.append(";angle=");
        sb.append(this.angle);
        sb.append("]");
        return sb.toString();
    }
}

