/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import java.awt.Rectangle;
import java.io.Serializable;

public class ClippedZPlane
implements Serializable {
    private double m_xMinimum = -1.0;
    private double m_yMinimum = Double.NaN;
    private double m_xMaximum = 1.0;
    private double m_yMaximum = Double.NaN;

    public ClippedZPlane() {
        this(-1.0, Double.NaN, 1.0, Double.NaN);
    }

    public ClippedZPlane(double xMinimum, double yMinimum, double xMaximum, double yMaximum) {
        this.set(xMinimum, yMinimum, xMaximum, yMaximum);
    }

    public ClippedZPlane(ClippedZPlane other) {
        this.set(other);
    }

    public ClippedZPlane(ClippedZPlane other, Rectangle viewport) {
        this.set(other, viewport);
    }

    public void set(double xMinimum, double yMinimum, double xMaximum, double yMaximum) {
        this.setXMinimum(xMinimum);
        this.setYMinimum(yMinimum);
        this.setXMaximum(xMaximum);
        this.setYMaximum(yMaximum);
    }

    public void set(ClippedZPlane other) {
        this.set(other.m_xMinimum, other.m_yMinimum, other.m_xMaximum, other.m_yMaximum);
    }

    public void set(ClippedZPlane other, Rectangle viewport) {
        double minX = other.getXMinimum();
        double minY = other.getYMinimum();
        double maxX = other.getXMaximum();
        double maxY = other.getYMaximum();
        if (Double.isNaN(minX) || Double.isNaN(maxX)) {
            if (Double.isNaN(minY) || Double.isNaN(maxY)) {
                minY = -1.0;
                maxY = 1.0;
            }
            double factor = (double)viewport.width / (double)viewport.height;
            minX = factor * minY;
            maxX = factor * maxY;
        } else if (Double.isNaN(minY) || Double.isNaN(maxY)) {
            double factor = (double)viewport.height / (double)viewport.width;
            minY = factor * minX;
            maxY = factor * maxY;
        }
        this.setXMinimum(minX);
        this.setYMinimum(minY);
        this.setXMaximum(maxX);
        this.setYMaximum(maxY);
    }

    public double getXMinimum() {
        return this.m_xMinimum;
    }

    public void setXMinimum(double xMinimum) {
        this.m_xMinimum = xMinimum;
    }

    public double getXMaximum() {
        return this.m_xMaximum;
    }

    public void setXMaximum(double xMaximum) {
        this.m_xMaximum = xMaximum;
    }

    public double getYMinimum() {
        return this.m_yMinimum;
    }

    public void setYMinimum(double yMinimum) {
        this.m_yMinimum = yMinimum;
    }

    public double getYMaximum() {
        return this.m_yMaximum;
    }

    public void setYMaximum(double yMaximum) {
        this.m_yMaximum = yMaximum;
    }
}

