/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.AngleInRadians;
import edu.cmu.cs.dennisc.math.AxisRotation;
import edu.cmu.cs.dennisc.math.EulerNumbers;
import edu.cmu.cs.dennisc.math.ForwardAndUpGuide;
import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Orientation;
import edu.cmu.cs.dennisc.math.OrthogonalMatrix3x3;
import edu.cmu.cs.dennisc.math.UnitQuaternion;
import edu.cmu.cs.dennisc.math.Vector3;

public class EulerAngles
implements Orientation,
BinaryEncodableAndDecodable {
    public final Angle yaw = new AngleInRadians(Double.NaN);
    public final Angle pitch = new AngleInRadians(Double.NaN);
    public final Angle roll = new AngleInRadians(Double.NaN);
    public Order order = Order.NOT_APPLICABLE;
    private static final EulerAngles IDENTITY = EulerAngles.createNaN();

    private EulerAngles() {
    }

    public EulerAngles(OrthogonalMatrix3x3 other) {
        this.setValue(other);
    }

    public EulerAngles(UnitQuaternion other) {
        this.setValue(other);
    }

    public EulerAngles(AxisRotation other) {
        this.setValue(other);
    }

    public EulerAngles(EulerAngles other) {
        this.setValue(other);
    }

    public EulerAngles(ForwardAndUpGuide other) {
        this.setValue(other);
    }

    public OrthogonalMatrix3x3 createOrthogonalMatrix3x3() {
        return new OrthogonalMatrix3x3(this);
    }

    public UnitQuaternion createUnitQuaternion() {
        return new UnitQuaternion(this);
    }

    public AxisRotation createAxisRotation() {
        return new AxisRotation(this);
    }

    public EulerAngles createEulerAngles() {
        return new EulerAngles(this);
    }

    public ForwardAndUpGuide createForwardAndUpGuide() {
        return new ForwardAndUpGuide(this);
    }

    public OrthogonalMatrix3x3 getValue(OrthogonalMatrix3x3 rv) {
        rv.setValue(this);
        return rv;
    }

    public UnitQuaternion getValue(UnitQuaternion rv) {
        rv.setValue(this);
        return rv;
    }

    public AxisRotation getValue(AxisRotation rv) {
        rv.setValue(this);
        return rv;
    }

    public EulerAngles getValue(EulerAngles rv) {
        rv.setValue(this);
        return rv;
    }

    public ForwardAndUpGuide getValue(ForwardAndUpGuide rv) {
        rv.setValue(this);
        return rv;
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.yaw.decode(binaryDecoder);
        this.pitch.decode(binaryDecoder);
        this.roll.decode(binaryDecoder);
        this.order = binaryDecoder.decodeEnum(Order.class);
    }

    public void encode(BinaryEncoder binaryEncoder) {
        this.yaw.encode(binaryEncoder);
        this.pitch.encode(binaryEncoder);
        this.roll.encode(binaryEncoder);
        binaryEncoder.encode(this.order);
    }

    public static EulerAngles setReturnValueToNaN(EulerAngles rv) {
        rv.yaw.setNaN();
        rv.pitch.setNaN();
        rv.roll.setNaN();
        rv.order = Order.NOT_APPLICABLE;
        return rv;
    }

    public static EulerAngles createNaN() {
        return EulerAngles.setReturnValueToNaN(new EulerAngles());
    }

    public void setNaN() {
        EulerAngles.setReturnValueToNaN(this);
    }

    public boolean isNaN() {
        return this.yaw.isNaN() || this.pitch.isNaN() || this.roll.isNaN();
    }

    public static EulerAngles accessIdentity() {
        IDENTITY.setIdentity();
        return IDENTITY;
    }

    public static EulerAngles setReturnValueToIdentity(EulerAngles rv) {
        rv.yaw.setAsRadians(0.0);
        rv.pitch.setAsRadians(0.0);
        rv.roll.setAsRadians(0.0);
        if (rv.order == Order.NOT_APPLICABLE) {
            rv.order = Order.YAW_PITCH_ROLL;
        }
        return rv;
    }

    public static EulerAngles createIdentity() {
        return EulerAngles.setReturnValueToIdentity(EulerAngles.createNaN());
    }

    public void setIdentity() {
        EulerAngles.setReturnValueToIdentity(this);
    }

    public boolean isIdentity() {
        return this.yaw.getAsRadians() == 0.0 && this.pitch.getAsRadians() == 0.0 && this.roll.getAsRadians() == 0.0 && this.order != Order.NOT_APPLICABLE;
    }

    public void setPitchYawRollOrder(Angle pitch, Angle yaw, Angle roll, Order order) {
        this.pitch.set(pitch);
        this.yaw.set(yaw);
        this.roll.set(roll);
        this.order = order;
    }

    private void set(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        m20 = Math.max(m20, -1.0);
        m20 = Math.min(m20, 1.0);
        this.yaw.setAsRadians(Math.asin(-m20));
        this.pitch.setAsRadians(Math.atan2(m21, m22));
        this.roll.setAsRadians(Math.atan2(m10, m00));
        this.order = Order.YAW_PITCH_ROLL;
        assert (!this.isNaN());
    }

    public void setValue(OrthogonalMatrix3x3 m) {
        assert (m != null);
        assert (!m.isNaN());
        this.set(m.right.x, m.up.x, m.backward.x, m.right.y, m.up.y, m.backward.y, m.right.z, m.up.z, m.backward.z);
    }

    public void setValue(UnitQuaternion q) {
        this.setValue(new OrthogonalMatrix3x3(q));
    }

    public void setValue(AxisRotation aa) {
        this.setValue(new OrthogonalMatrix3x3(aa));
    }

    public void setValue(EulerAngles other) {
        if (other != null) {
            this.setPitchYawRollOrder(other.pitch, other.yaw, other.roll, other.order);
        } else {
            this.setNaN();
        }
    }

    public void setValue(ForwardAndUpGuide faug) {
        this.setValue(new OrthogonalMatrix3x3(faug));
    }

    public void setToOrientationComponentOf(Matrix4x4 m) {
        assert (m != null);
        assert (!m.isNaN());
        this.set(m.right.x, m.up.x, m.backward.x, m.right.y, m.up.y, m.backward.y, m.right.z, m.up.z, m.backward.z);
    }

    public void interpolate(EulerAngles ea0, EulerAngles ea1, double portion) {
        assert (ea0.order == ea1.order);
        double yaw0 = ea0.yaw.getAsRadians();
        double pitch0 = ea0.pitch.getAsRadians();
        double roll0 = ea0.roll.getAsRadians();
        double yaw1 = ea1.yaw.getAsRadians();
        double pitch1 = ea1.pitch.getAsRadians();
        double roll1 = ea1.roll.getAsRadians();
        this.yaw.setAsRadians(yaw0 + (yaw1 - yaw0) * portion);
        this.pitch.setAsRadians(pitch0 + (pitch1 - pitch0) * portion);
        this.roll.setAsRadians(roll0 + (roll1 - roll0) * portion);
    }

    public String toString() {
        return EulerAngles.class.getName() + "[pitch=" + this.pitch + ",yaw=" + this.yaw + ",roll=" + this.roll + ",order=" + (Object)((Object)this.order) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CardinalRotation {
        PITCH,
        YAW,
        ROLL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Order
    extends Enum<Order> {
        public static final /* enum */ Order PITCH_YAW_ROLL = new Order(CardinalRotation.PITCH, CardinalRotation.YAW, CardinalRotation.ROLL);
        public static final /* enum */ Order YAW_ROLL_PITCH = new Order(CardinalRotation.YAW, CardinalRotation.ROLL, CardinalRotation.PITCH);
        public static final /* enum */ Order ROLL_PITCH_YAW = new Order(CardinalRotation.ROLL, CardinalRotation.PITCH, CardinalRotation.YAW);
        public static final /* enum */ Order PITCH_ROLL_YAW = new Order(CardinalRotation.PITCH, CardinalRotation.ROLL, CardinalRotation.YAW);
        public static final /* enum */ Order YAW_PITCH_ROLL = new Order(CardinalRotation.YAW, CardinalRotation.PITCH, CardinalRotation.ROLL);
        public static final /* enum */ Order ROLL_YAW_PITCH = new Order(CardinalRotation.ROLL, CardinalRotation.YAW, CardinalRotation.PITCH);
        public static final /* enum */ Order NOT_APPLICABLE = new Order(new CardinalRotation[0]);
        private int m_pitchIndex = -1;
        private int m_yawIndex = -1;
        private int m_rollIndex = -1;
        private static final /* synthetic */ Order[] $VALUES;

        public static final Order[] values() {
            return (Order[])$VALUES.clone();
        }

        public static Order valueOf(String name) {
            return Enum.valueOf(Order.class, name);
        }

        private Order(CardinalRotation ... angles) {
            if (angles.length == 3) {
                int index = 0;
                for (CardinalRotation angle : angles) {
                    if (angle == CardinalRotation.PITCH) {
                        assert (this.m_pitchIndex == -1);
                        this.m_pitchIndex = index;
                    } else if (angle == CardinalRotation.YAW) {
                        assert (this.m_yawIndex == -1);
                        this.m_yawIndex = index;
                    } else if (angle == CardinalRotation.ROLL) {
                        assert (this.m_rollIndex == -1);
                        this.m_rollIndex = index;
                    }
                    ++index;
                }
                assert (this.m_pitchIndex != -1);
                assert (this.m_yawIndex != -1);
                assert (this.m_rollIndex != -1);
            } else assert (angles.length == 0);
        }

        private double getValue(int index, double a, double b, double c) {
            switch (index) {
                case 0: {
                    return a;
                }
                case 1: {
                    return b;
                }
                case 2: {
                    return c;
                }
            }
            throw new Error();
        }

        private double getValue(int index, EulerNumbers numbers) {
            return this.getValue(index, numbers.pitch, numbers.yaw, numbers.roll);
        }

        private Vector3 accessAxis(int index) {
            if (index == this.m_pitchIndex) {
                return Vector3.accessPositiveXAxis();
            }
            if (index == this.m_yawIndex) {
                return Vector3.accessPositiveYAxis();
            }
            if (index == this.m_rollIndex) {
                return Vector3.accessPositiveZAxis();
            }
            assert (false);
            return null;
        }

        public OrthogonalMatrix3x3 setReturnValueToPitchYawRoll(OrthogonalMatrix3x3 rv, Angle pitch, Angle yaw, Angle roll) {
            EulerNumbers numbers = new EulerNumbers();
            numbers.pitch = pitch.getAsRadians();
            numbers.yaw = yaw.getAsRadians();
            numbers.roll = roll.getAsRadians();
            rv.setIdentity();
            for (int i = 0; i < 3; ++i) {
                rv.applyRotationAboutArbitraryAxis(this.accessAxis(i), new AngleInRadians(this.getValue(i, numbers)));
            }
            return rv;
        }

        public double getPitch(double a, double b, double c) {
            return this.getValue(this.m_pitchIndex, a, b, c);
        }

        public double getYaw(double a, double b, double c) {
            return this.getValue(this.m_yawIndex, a, b, c);
        }

        public double getRoll(double a, double b, double c) {
            return this.getValue(this.m_rollIndex, a, b, c);
        }

        static {
            $VALUES = new Order[]{PITCH_YAW_ROLL, YAW_ROLL_PITCH, ROLL_PITCH_YAW, PITCH_ROLL_YAW, YAW_PITCH_ROLL, ROLL_YAW_PITCH, NOT_APPLICABLE};
        }
    }
}

