/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.EulerAngles;

public class EulerNumbers
implements BinaryEncodableAndDecodable {
    public double pitch;
    public double yaw;
    public double roll;

    public EulerNumbers() {
        this.pitch = 0.0;
        this.yaw = 0.0;
        this.roll = 0.0;
    }

    public EulerNumbers(double[] array, EulerAngles.Order order) {
        this.set(array, order);
    }

    public EulerNumbers(double a, double b, double c, EulerAngles.Order order) {
        this.set(a, b, c, order);
    }

    public EulerNumbers(EulerNumbers other) {
        this.set(other);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.pitch = binaryDecoder.decodeDouble();
        this.yaw = binaryDecoder.decodeDouble();
        this.roll = binaryDecoder.decodeDouble();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.pitch);
        binaryEncoder.encode(this.yaw);
        binaryEncoder.encode(this.roll);
    }

    public boolean isNaN() {
        return Double.isNaN(this.pitch) || Double.isNaN(this.yaw) || Double.isNaN(this.roll);
    }

    public void setNaN() {
        this.pitch = Double.NaN;
        this.yaw = Double.NaN;
        this.roll = Double.NaN;
    }

    public void set(double a, double b, double c, EulerAngles.Order order) {
        this.pitch = order.getPitch(a, b, c);
        this.yaw = order.getYaw(a, b, c);
        this.roll = order.getRoll(a, b, c);
    }

    public void set(double[] pyr, EulerAngles.Order order) {
        this.set(pyr[0], pyr[1], pyr[2], order);
    }

    public void set(EulerNumbers other) {
        this.pitch = other.pitch;
        this.yaw = other.yaw;
        this.roll = other.roll;
    }

    public String toString() {
        return EulerNumbers.class.getName() + "[pitch=" + this.pitch + ",yaw=" + this.yaw + ",roll=" + this.roll + "]";
    }

    public static EulerNumbers valueOf(String s) {
        String[] markers = new String[]{EulerNumbers.class.getName() + "[pitch=", ",yaw=", ",roll=", "]"};
        double[] values = new double[markers.length - 1];
        for (int i = 0; i < values.length; ++i) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            values[i] = Double.valueOf(s.substring(begin, end));
        }
        return new EulerNumbers(values, EulerAngles.Order.PITCH_YAW_ROLL);
    }
}

