/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.AxisRotation;
import edu.cmu.cs.dennisc.math.EulerAngles;
import edu.cmu.cs.dennisc.math.Orientation;
import edu.cmu.cs.dennisc.math.OrthogonalMatrix3x3;
import edu.cmu.cs.dennisc.math.UnitQuaternion;
import edu.cmu.cs.dennisc.math.Vector3;

public class ForwardAndUpGuide
implements Orientation,
BinaryEncodableAndDecodable {
    public final Vector3 forward = new Vector3();
    public final Vector3 upGuide = new Vector3();

    private ForwardAndUpGuide() {
    }

    public ForwardAndUpGuide(Vector3 forward, Vector3 upGuide) {
        this.setValueFrom(forward, upGuide);
    }

    public ForwardAndUpGuide(OrthogonalMatrix3x3 other) {
        this.setValue(other);
    }

    public ForwardAndUpGuide(UnitQuaternion other) {
        this.setValue(other);
    }

    public ForwardAndUpGuide(AxisRotation other) {
        this.setValue(other);
    }

    public ForwardAndUpGuide(EulerAngles other) {
        this.setValue(other);
    }

    public ForwardAndUpGuide(ForwardAndUpGuide other) {
        this.setValue(other);
    }

    public OrthogonalMatrix3x3 createOrthogonalMatrix3x3() {
        return new OrthogonalMatrix3x3(this);
    }

    public UnitQuaternion createUnitQuaternion() {
        return new UnitQuaternion(this);
    }

    public AxisRotation createAxisRotation() {
        return new AxisRotation(this);
    }

    public EulerAngles createEulerAngles() {
        return new EulerAngles(this);
    }

    public ForwardAndUpGuide createForwardAndUpGuide() {
        return new ForwardAndUpGuide(this);
    }

    public OrthogonalMatrix3x3 getValue(OrthogonalMatrix3x3 rv) {
        rv.setValue(this);
        return rv;
    }

    public UnitQuaternion getValue(UnitQuaternion rv) {
        rv.setValue(this);
        return rv;
    }

    public AxisRotation getValue(AxisRotation rv) {
        rv.setValue(this);
        return rv;
    }

    public EulerAngles getValue(EulerAngles rv) {
        rv.setValue(this);
        return rv;
    }

    public ForwardAndUpGuide getValue(ForwardAndUpGuide rv) {
        rv.setValue(this);
        return rv;
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.forward.decode(binaryDecoder);
        this.upGuide.decode(binaryDecoder);
    }

    public void encode(BinaryEncoder binaryEncoder) {
        this.forward.encode(binaryEncoder);
        this.upGuide.encode(binaryEncoder);
    }

    public static ForwardAndUpGuide setReturnValueToNaN(ForwardAndUpGuide rv) {
        rv.forward.setNaN();
        rv.upGuide.setNaN();
        return rv;
    }

    public static ForwardAndUpGuide createFromNaN() {
        return ForwardAndUpGuide.setReturnValueToNaN(new ForwardAndUpGuide());
    }

    public void setNaN() {
        ForwardAndUpGuide.setReturnValueToNaN(this);
    }

    public boolean isNaN() {
        return this.forward.isNaN() || this.upGuide.isNaN();
    }

    public static ForwardAndUpGuide setReturnValueToIdentity(ForwardAndUpGuide rv) {
        rv.forward.set(0.0, 0.0, -1.0);
        rv.upGuide.set(0.0, 1.0, 0.0);
        return rv;
    }

    public static ForwardAndUpGuide createFromIdentity() {
        return ForwardAndUpGuide.setReturnValueToIdentity(ForwardAndUpGuide.createFromNaN());
    }

    public void setIdentity() {
        ForwardAndUpGuide.setReturnValueToIdentity(this);
    }

    public boolean isIdentity() {
        return this.forward.isNegativeZAxis() && this.upGuide.isPositiveYAxis();
    }

    public void setValue(OrthogonalMatrix3x3 m) {
        this.forward.set(m.backward);
        this.forward.negate();
        this.upGuide.set(m.up);
    }

    public void setValue(UnitQuaternion q) {
        this.setValue(new OrthogonalMatrix3x3(q));
    }

    public void setValue(AxisRotation aa) {
        this.setValue(new OrthogonalMatrix3x3(aa));
    }

    public void setValue(EulerAngles ea) {
        this.setValue(new OrthogonalMatrix3x3(ea));
    }

    public void setValue(ForwardAndUpGuide faug) {
        this.setValueFrom(faug.forward, faug.upGuide);
    }

    public void setValueFrom(Vector3 forward, Vector3 upGuide) {
        this.forward.set(forward);
        this.upGuide.set(upGuide);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ForwardAndUpGuide.class.getName());
        sb.append("[forward=");
        sb.append(this.forward);
        sb.append(";upGuide=");
        sb.append(this.upGuide);
        sb.append("]");
        return sb.toString();
    }
}

