/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.math.AbstractMatrix4x4;
import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.ClippedPlane;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import java.io.Serializable;

public class Hexahedron
implements Serializable {
    private Point3[] m_points = new Point3[]{new Point3(), new Point3(), new Point3(), new Point3(), new Point3(), new Point3(), new Point3(), new Point3()};
    private Vector3[] m_normals = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3()};

    public Hexahedron() {
        this.setNaN();
    }

    public Hexahedron(Point3[] points, Vector3[] normals) {
        this.set(points, normals);
    }

    public Hexahedron(Hexahedron other) {
        this.set(other);
    }

    protected boolean isEqual(Hexahedron other) {
        int i;
        for (i = 0; i < this.m_points.length; ++i) {
            if (this.m_points[i].equals(other.m_points[i])) continue;
            return false;
        }
        for (i = 0; i < this.m_normals.length; ++i) {
            if (this.m_normals[i].equals(other.m_normals[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Hexahedron) {
            return this.isEqual((Hexahedron)other);
        }
        return false;
    }

    public void set(Point3[] points, Vector3[] normals) {
        int i;
        for (i = 0; i < this.m_points.length; ++i) {
            this.m_points[i].set(points[i]);
        }
        for (i = 0; i < this.m_normals.length; ++i) {
            this.m_normals[i].set(normals[i]);
        }
    }

    public void set(Hexahedron other) {
        if (other != null) {
            this.set(other.m_points, other.m_normals);
        } else {
            this.setNaN();
        }
    }

    public void setNaN() {
        for (Point3 point3 : this.m_points) {
            point3.setNaN();
        }
        for (Tuple3 tuple3 : this.m_normals) {
            tuple3.setNaN();
        }
    }

    public boolean isNaN() {
        for (Point3 point3 : this.m_points) {
            if (!point3.isNaN()) continue;
            return true;
        }
        for (Tuple3 tuple3 : this.m_normals) {
            if (!tuple3.isNaN()) continue;
            return true;
        }
        return false;
    }

    public void transform(AbstractMatrix4x4 m) {
        for (Point3 point3 : this.m_points) {
            m.transform(point3);
        }
        for (Tuple3 tuple3 : this.m_normals) {
            m.transform((Vector3)tuple3);
        }
    }

    @Deprecated
    public Point3 getPointAt(int index) {
        return new Point3(this.m_points[index]);
    }

    @Deprecated
    public Point3[] getPoints() {
        return this.m_points;
    }

    @Deprecated
    public Vector3[] getNormals() {
        return this.m_normals;
    }

    private int getPointIndex(RightOrLeft rightOrLeft, TopOrBottom topOrBottom, BackOrFront backOrFront) {
        return rightOrLeft.getMask() | topOrBottom.getMask() | backOrFront.getMask();
    }

    public Point3 getPoint(Point3 rv, RightOrLeft rightOrLeft, TopOrBottom topOrBottom, BackOrFront backOrFront) {
        rv.set(this.m_points[this.getPointIndex(rightOrLeft, topOrBottom, backOrFront)]);
        return rv;
    }

    public Point3 getPoint(RightOrLeft rightOrLeft, TopOrBottom topOrBottom, BackOrFront backOrFront) {
        return this.getPoint(new Point3(), rightOrLeft, topOrBottom, backOrFront);
    }

    private Point3[] getPoints(Side side) {
        Point3[] rv = new Point3[4];
        for (int i = 0; i < rv.length; ++i) {
            rv[i] = this.m_points[side.getPointIndexAt(i)];
        }
        return rv;
    }

    public ClippedPlane getClippedPlane(ClippedPlane rv, Side side) {
        Point3[] points = this.getPoints(side);
        Vector3 normal = this.m_normals[side.getNormalIndex()];
        rv.set(points, normal);
        return rv;
    }

    public ClippedPlane getClippedPlane(Side side) {
        return this.getClippedPlane(new ClippedPlane(), side);
    }

    public AxisAlignedBox getAxisAlignedMinimumBoundingBox(AxisAlignedBox rv) {
        Point3 minimum = new Point3(this.m_points[0]);
        Point3 maximum = new Point3(this.m_points[0]);
        for (int i = 1; i < this.m_points.length; ++i) {
            Point3 p = this.m_points[i];
            minimum.x = Math.min(minimum.x, p.x);
            minimum.y = Math.min(minimum.y, p.y);
            minimum.z = Math.min(minimum.z, p.z);
            maximum.x = Math.max(maximum.x, p.x);
            maximum.y = Math.max(maximum.y, p.y);
            maximum.z = Math.max(maximum.z, p.z);
        }
        rv.setMinimum(minimum);
        rv.setMaximum(maximum);
        return rv;
    }

    public AxisAlignedBox getAxisAlignedMinimumBoundingBox() {
        return this.getAxisAlignedMinimumBoundingBox(new AxisAlignedBox());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BackOrFront {
        BACK(0),
        FRONT(4);

        private int m_mask;

        private BackOrFront(int mask) {
            this.m_mask = mask;
        }

        public int getMask() {
            return this.m_mask;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RightOrLeft {
        RIGHT(0),
        LEFT(1);

        private int m_mask;

        private RightOrLeft(int mask) {
            this.m_mask = mask;
        }

        public int getMask() {
            return this.m_mask;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Side
    extends Enum<Side> {
        public static final /* enum */ Side RIGHT = new Side(0, 0, 1, 2, 3);
        public static final /* enum */ Side LEFT = new Side(1, 0, 1, 2, 3);
        public static final /* enum */ Side TOP = new Side(2, 0, 1, 2, 3);
        public static final /* enum */ Side BOTTOM = new Side(3, 0, 1, 2, 3);
        public static final /* enum */ Side BACK = new Side(4, 0, 1, 2, 3);
        public static final /* enum */ Side FRONT = new Side(5, 0, 1, 2, 3);
        private int m_normalIndex;
        private int[] m_pointIndices;
        private static final /* synthetic */ Side[] $VALUES;

        public static final Side[] values() {
            return (Side[])$VALUES.clone();
        }

        public static Side valueOf(String name) {
            return Enum.valueOf(Side.class, name);
        }

        private Side(int normalIndex, int ... pointIndices) {
            assert (0 <= normalIndex && normalIndex < 6);
            assert (pointIndices.length == 4);
            for (int pointIndex : pointIndices) {
                assert (0 <= pointIndex && pointIndex < 8);
            }
            this.m_normalIndex = normalIndex;
            this.m_pointIndices = pointIndices;
        }

        public int getNormalIndex() {
            return this.m_normalIndex;
        }

        public int[] getPointIndices() {
            return this.m_pointIndices;
        }

        public int getPointIndexAt(int i) {
            return this.m_pointIndices[i];
        }

        static {
            $VALUES = new Side[]{RIGHT, LEFT, TOP, BOTTOM, BACK, FRONT};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TopOrBottom {
        TOP(0),
        BOTTOM(2);

        private int m_mask;

        private TopOrBottom(int mask) {
            this.m_mask = mask;
        }

        public int getMask() {
            return this.m_mask;
        }
    }
}

