/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.equivalence.EquivalenceUtilities;
import edu.cmu.cs.dennisc.math.AbstractMatrix4x4;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Point3f;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.Vector3f;
import edu.cmu.cs.dennisc.math.Vector4;
import edu.cmu.cs.dennisc.math.Vector4f;

public final class Matrix4x4
extends AbstractMatrix4x4
implements BinaryEncodableAndDecodable {
    public final Vector4 right = new Vector4(1.0, 0.0, 0.0, 0.0);
    public final Vector4 up = new Vector4(0.0, 1.0, 0.0, 0.0);
    public final Vector4 backward = new Vector4(0.0, 0.0, 1.0, 0.0);
    public final Vector4 translation = new Vector4(0.0, 0.0, 0.0, 1.0);
    private static final Matrix4x4 IDENTITY = Matrix4x4.createNaN();

    public Matrix4x4() {
    }

    public Matrix4x4(Matrix4x4 other) {
        this.set(other);
    }

    public Matrix4x4(AffineMatrix4x4 other) {
        this.set(other);
    }

    public Matrix4x4(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        this.set(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.right.decode(binaryDecoder);
        this.up.decode(binaryDecoder);
        this.backward.decode(binaryDecoder);
        this.translation.decode(binaryDecoder);
    }

    public void encode(BinaryEncoder binaryEncoder) {
        this.right.encode(binaryEncoder);
        this.up.encode(binaryEncoder);
        this.backward.encode(binaryEncoder);
        this.translation.encode(binaryEncoder);
    }

    public boolean isWithinEpsilonOf(Matrix4x4 other, double epsilon) {
        return this.right.isWithinEpsilonOf(other.right, epsilon) && this.up.isWithinEpsilonOf(other.up, epsilon) && this.backward.isWithinEpsilonOf(other.backward, epsilon) && this.translation.isWithinEpsilonOf(other.translation, epsilon);
    }

    public boolean isWithinReasonableEpsilonOf(Matrix4x4 other) {
        return this.isWithinEpsilonOf(other, 0.001);
    }

    public boolean isAffine() {
        return this.right.w == 0.0 && this.up.w == 0.0 && this.backward.w == 0.0 && this.translation.w == 1.0;
    }

    public boolean isWithinEpsilonOfAffine(double epsilon) {
        return EpsilonUtilities.isWithinEpsilon((Number)this.right.w, 0.0, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)this.up.w, 0.0, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)this.backward.w, 0.0, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)this.translation.w, 1.0, epsilon);
    }

    public boolean isWithinReasonableEpsilonOfAffine() {
        return this.isWithinEpsilonOfAffine(0.001);
    }

    public double[] getAsColumnMajorArray16(double[] rv) {
        assert (rv.length == 16);
        rv[0] = this.right.x;
        rv[1] = this.right.y;
        rv[2] = this.right.z;
        rv[3] = this.right.w;
        rv[4] = this.up.x;
        rv[5] = this.up.y;
        rv[6] = this.up.z;
        rv[7] = this.up.w;
        rv[8] = this.backward.x;
        rv[9] = this.backward.y;
        rv[10] = this.backward.z;
        rv[11] = this.backward.w;
        rv[12] = this.translation.x;
        rv[13] = this.translation.y;
        rv[14] = this.translation.z;
        rv[15] = this.translation.w;
        return rv;
    }

    public static Matrix4x4 setReturnValueToNaN(Matrix4x4 rv) {
        rv.right.setNaN();
        rv.up.setNaN();
        rv.backward.setNaN();
        rv.translation.setNaN();
        return rv;
    }

    public static Matrix4x4 createNaN() {
        return Matrix4x4.setReturnValueToNaN(new Matrix4x4());
    }

    public void setNaN() {
        Matrix4x4.setReturnValueToNaN(this);
    }

    public boolean isNaN() {
        return this.right.isNaN() || this.up.isNaN() || this.backward.isNaN() || this.translation.isNaN();
    }

    public static Matrix4x4 accessIdentity() {
        IDENTITY.setIdentity();
        return IDENTITY;
    }

    public static Matrix4x4 setReturnValueToIdentity(Matrix4x4 rv) {
        rv.set(Matrix4x4.accessIdentity());
        return rv;
    }

    public static Matrix4x4 createIdentity() {
        return Matrix4x4.setReturnValueToIdentity(Matrix4x4.createNaN());
    }

    public void setIdentity() {
        Matrix4x4.setReturnValueToIdentity(this);
    }

    public boolean isIdentity() {
        return this.equals(Matrix4x4.accessIdentity());
    }

    public static Matrix4x4 setReturnValueToZero(Matrix4x4 rv) {
        rv.right.setZero();
        rv.up.setZero();
        rv.backward.setZero();
        rv.translation.setZero();
        return rv;
    }

    public static Matrix4x4 createFromZero() {
        return Matrix4x4.setReturnValueToZero(Matrix4x4.createNaN());
    }

    public void setZero() {
        Matrix4x4.setReturnValueToZero(this);
    }

    public boolean isZero() {
        return this.right.isZero() && this.up.isZero() && this.backward.isZero() && this.translation.isZero();
    }

    public void set(Matrix4x4 other) {
        this.right.x = other.right.x;
        this.up.x = other.up.x;
        this.backward.x = other.backward.x;
        this.translation.x = other.translation.x;
        this.right.y = other.right.y;
        this.up.y = other.up.y;
        this.backward.y = other.backward.y;
        this.translation.y = other.translation.y;
        this.right.z = other.right.z;
        this.up.z = other.up.z;
        this.backward.z = other.backward.z;
        this.translation.z = other.translation.z;
        this.right.w = other.right.w;
        this.up.w = other.up.w;
        this.backward.w = other.backward.w;
        this.translation.w = other.translation.w;
    }

    public void set(AffineMatrix4x4 other) {
        this.right.x = other.orientation.right.x;
        this.up.x = other.orientation.up.x;
        this.backward.x = other.orientation.backward.x;
        this.translation.x = other.translation.x;
        this.right.y = other.orientation.right.y;
        this.up.y = other.orientation.up.y;
        this.backward.y = other.orientation.backward.y;
        this.translation.y = other.translation.y;
        this.right.z = other.orientation.right.z;
        this.up.z = other.orientation.up.z;
        this.backward.z = other.orientation.backward.z;
        this.translation.z = other.translation.z;
        this.right.w = 0.0;
        this.up.w = 0.0;
        this.backward.w = 0.0;
        this.translation.w = 1.0;
    }

    public void set(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23, double m30, double m31, double m32, double m33) {
        this.right.x = m00;
        this.up.x = m01;
        this.backward.x = m02;
        this.translation.x = m03;
        this.right.y = m10;
        this.up.y = m11;
        this.backward.y = m12;
        this.translation.y = m13;
        this.right.z = m20;
        this.up.z = m21;
        this.backward.z = m22;
        this.translation.z = m23;
        this.right.w = m30;
        this.up.w = m31;
        this.backward.w = m32;
        this.translation.w = m33;
    }

    public double determinate() {
        double m00 = this.right.x;
        double m10 = this.right.y;
        double m20 = this.right.z;
        double m30 = this.right.w;
        double m01 = this.up.x;
        double m11 = this.up.y;
        double m21 = this.up.z;
        double m31 = this.up.w;
        double m02 = this.backward.x;
        double m12 = this.backward.y;
        double m22 = this.backward.z;
        double m32 = this.backward.w;
        double m03 = this.translation.x;
        double m13 = this.translation.y;
        double m23 = this.translation.z;
        double m33 = this.translation.w;
        return m03 * m12 * m21 * m30 - m02 * m13 * m21 * m30 - m03 * m11 * m22 * m30 + m01 * m13 * m22 * m30 + m02 * m11 * m23 * m30 - m01 * m12 * m23 * m30 - m03 * m12 * m20 * m31 + m02 * m13 * m20 * m31 + m03 * m10 * m22 * m31 - m00 * m13 * m22 * m31 - m02 * m10 * m23 * m31 + m00 * m12 * m23 * m31 + m03 * m11 * m20 * m32 - m01 * m13 * m20 * m32 - m03 * m10 * m21 * m32 + m00 * m13 * m21 * m32 + m01 * m10 * m23 * m32 - m00 * m11 * m23 * m32 - m02 * m11 * m20 * m33 + m01 * m12 * m20 * m33 + m02 * m10 * m21 * m33 - m00 * m12 * m21 * m33 - m01 * m10 * m22 * m33 + m00 * m11 * m22 * m33;
    }

    public void invert() {
        double d = this.determinate();
        double m00 = this.right.x;
        double m10 = this.right.y;
        double m20 = this.right.z;
        double m30 = this.right.w;
        double m01 = this.up.x;
        double m11 = this.up.y;
        double m21 = this.up.z;
        double m31 = this.up.w;
        double m02 = this.backward.x;
        double m12 = this.backward.y;
        double m22 = this.backward.z;
        double m32 = this.backward.w;
        double m03 = this.translation.x;
        double m13 = this.translation.y;
        double m23 = this.translation.z;
        double m33 = this.translation.w;
        this.set(m12 * m23 * m31 - m13 * m22 * m31 + m13 * m21 * m32 - m11 * m23 * m32 - m12 * m21 * m33 + m11 * m22 * m33, m03 * m22 * m31 - m02 * m23 * m31 - m03 * m21 * m32 + m01 * m23 * m32 + m02 * m21 * m33 - m01 * m22 * m33, m02 * m13 * m31 - m03 * m12 * m31 + m03 * m11 * m32 - m01 * m13 * m32 - m02 * m11 * m33 + m01 * m12 * m33, m03 * m12 * m21 - m02 * m13 * m21 - m03 * m11 * m22 + m01 * m13 * m22 + m02 * m11 * m23 - m01 * m12 * m23, m13 * m22 * m30 - m12 * m23 * m30 - m13 * m20 * m32 + m10 * m23 * m32 + m12 * m20 * m33 - m10 * m22 * m33, m02 * m23 * m30 - m03 * m22 * m30 + m03 * m20 * m32 - m00 * m23 * m32 - m02 * m20 * m33 + m00 * m22 * m33, m03 * m12 * m30 - m02 * m13 * m30 - m03 * m10 * m32 + m00 * m13 * m32 + m02 * m10 * m33 - m00 * m12 * m33, m02 * m13 * m20 - m03 * m12 * m20 + m03 * m10 * m22 - m00 * m13 * m22 - m02 * m10 * m23 + m00 * m12 * m23, m11 * m23 * m30 - m13 * m21 * m30 + m13 * m20 * m31 - m10 * m23 * m31 - m11 * m20 * m33 + m10 * m21 * m33, m03 * m21 * m30 - m01 * m23 * m30 - m03 * m20 * m31 + m00 * m23 * m31 + m01 * m20 * m33 - m00 * m21 * m33, m01 * m13 * m30 - m03 * m11 * m30 + m03 * m10 * m31 - m00 * m13 * m31 - m01 * m10 * m33 + m00 * m11 * m33, m03 * m11 * m20 - m01 * m13 * m20 - m03 * m10 * m21 + m00 * m13 * m21 + m01 * m10 * m23 - m00 * m11 * m23, m12 * m21 * m30 - m11 * m22 * m30 - m12 * m20 * m31 + m10 * m22 * m31 + m11 * m20 * m32 - m10 * m21 * m32, m01 * m22 * m30 - m02 * m21 * m30 + m02 * m20 * m31 - m00 * m22 * m31 - m01 * m20 * m32 + m00 * m21 * m32, m02 * m11 * m30 - m01 * m12 * m30 - m02 * m10 * m31 + m00 * m12 * m31 + m01 * m10 * m32 - m00 * m11 * m32, m01 * m12 * m20 - m02 * m11 * m20 + m02 * m10 * m21 - m00 * m12 * m21 - m01 * m10 * m22 + m00 * m11 * m22);
        this.scale(1.0 / d);
    }

    public void setToMultiplication(Matrix4x4 a, Matrix4x4 b) {
        double m00 = a.right.x * b.right.x + a.up.x * b.right.y + a.backward.x * b.right.z + a.translation.x * b.right.w;
        double m01 = a.right.x * b.up.x + a.up.x * b.up.y + a.backward.x * b.up.z + a.translation.x * b.up.w;
        double m02 = a.right.x * b.backward.x + a.up.x * b.backward.y + a.backward.x * b.backward.z + a.translation.x * b.backward.w;
        double m03 = a.right.x * b.translation.x + a.up.x * b.translation.y + a.backward.x * b.translation.z + a.translation.x * b.translation.w;
        double m10 = a.right.y * b.right.x + a.up.y * b.right.y + a.backward.y * b.right.z + a.translation.y * b.right.w;
        double m11 = a.right.y * b.up.x + a.up.y * b.up.y + a.backward.y * b.up.z + a.translation.y * b.up.w;
        double m12 = a.right.y * b.backward.x + a.up.y * b.backward.y + a.backward.y * b.backward.z + a.translation.y * b.backward.w;
        double m13 = a.right.y * b.translation.x + a.up.y * b.translation.y + a.backward.y * b.translation.z + a.translation.y * b.translation.w;
        double m20 = a.right.z * b.right.x + a.up.z * b.right.y + a.backward.z * b.right.z + a.translation.z * b.right.w;
        double m21 = a.right.z * b.up.x + a.up.z * b.up.y + a.backward.z * b.up.z + a.translation.z * b.up.w;
        double m22 = a.right.z * b.backward.x + a.up.z * b.backward.y + a.backward.z * b.backward.z + a.translation.z * b.backward.w;
        double m23 = a.right.z * b.translation.x + a.up.z * b.translation.y + a.backward.z * b.translation.z + a.translation.z * b.translation.w;
        double m30 = a.right.w * b.right.x + a.up.w * b.right.y + a.backward.w * b.right.z + a.translation.w * b.right.w;
        double m31 = a.right.w * b.up.x + a.up.w * b.up.y + a.backward.w * b.up.z + a.translation.w * b.up.w;
        double m32 = a.right.w * b.backward.x + a.up.w * b.backward.y + a.backward.w * b.backward.z + a.translation.w * b.backward.w;
        double m33 = a.right.w * b.translation.x + a.up.w * b.translation.y + a.backward.w * b.translation.z + a.translation.w * b.translation.w;
        this.right.set(m00, m10, m20, m30);
        this.up.set(m01, m11, m21, m31);
        this.backward.set(m02, m12, m22, m32);
        this.translation.set(m03, m13, m23, m33);
    }

    public void applyMultiplication(Matrix4x4 b) {
        this.setToMultiplication(this, b);
    }

    public void add(Matrix4x4 b) {
        this.right.add(b.right);
        this.up.add(b.up);
        this.backward.add(b.backward);
        this.translation.add(b.translation);
    }

    public void add(Matrix4x4 a, Matrix4x4 b) {
        this.right.setToAddition(a.right, b.right);
        this.up.setToAddition(a.up, b.up);
        this.backward.setToAddition(a.backward, b.backward);
        this.translation.setToAddition(a.translation, b.translation);
    }

    public void sub(Matrix4x4 b) {
        this.right.subtract(b.right);
        this.up.subtract(b.up);
        this.backward.subtract(b.backward);
        this.translation.subtract(b.translation);
    }

    public void sub(Matrix4x4 a, Matrix4x4 b) {
        this.right.setToSubtraction(a.right, b.right);
        this.up.setToSubtraction(a.up, b.up);
        this.backward.setToSubtraction(a.backward, b.backward);
        this.translation.setToSubtraction(a.translation, b.translation);
    }

    public void scale(double s) {
        this.right.multiply(s);
        this.up.multiply(s);
        this.backward.multiply(s);
        this.translation.multiply(s);
    }

    public void transpose() {
        double m00 = this.right.x;
        double m10 = this.right.y;
        double m20 = this.right.z;
        double m30 = this.right.w;
        double m01 = this.up.x;
        double m11 = this.up.y;
        double m21 = this.up.z;
        double m31 = this.up.w;
        double m02 = this.backward.x;
        double m12 = this.backward.y;
        double m22 = this.backward.z;
        double m32 = this.backward.w;
        double m03 = this.translation.x;
        double m13 = this.translation.y;
        double m23 = this.translation.z;
        double m33 = this.translation.w;
        this.set(m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33);
    }

    public Vector4 setReturnValueToTransformed(Vector4 rv, Vector4 b) {
        double m00 = this.right.x;
        double m10 = this.right.y;
        double m20 = this.right.z;
        double m30 = this.right.w;
        double m01 = this.up.x;
        double m11 = this.up.y;
        double m21 = this.up.z;
        double m31 = this.up.w;
        double m02 = this.backward.x;
        double m12 = this.backward.y;
        double m22 = this.backward.z;
        double m32 = this.backward.w;
        double m03 = this.translation.x;
        double m13 = this.translation.y;
        double m23 = this.translation.z;
        double m33 = this.translation.w;
        double x = m00 * b.x + m01 * b.y + m02 * b.z + m03 * b.w;
        double y = m10 * b.x + m11 * b.y + m12 * b.z + m13 * b.w;
        double z = m20 * b.x + m21 * b.y + m22 * b.z + m23 * b.w;
        double w = m30 * b.x + m31 * b.y + m32 * b.z + m33 * b.w;
        rv.x = x;
        rv.y = y;
        rv.z = z;
        rv.w = w;
        return rv;
    }

    public Vector3 setReturnValueToTransformed(Vector3 rv, Vector3 b) {
        double m00 = this.right.x;
        double m10 = this.right.y;
        double m20 = this.right.z;
        double m01 = this.up.x;
        double m11 = this.up.y;
        double m21 = this.up.z;
        double m02 = this.backward.x;
        double m12 = this.backward.y;
        double m22 = this.backward.z;
        double x = m00 * b.x + m01 * b.y + m02 * b.z;
        double y = m10 * b.x + m11 * b.y + m12 * b.z;
        double z = m20 * b.x + m21 * b.y + m22 * b.z;
        rv.x = x;
        rv.y = y;
        rv.z = z;
        return rv;
    }

    public Point3 setReturnValueToTransformed(Point3 rv, Point3 b) {
        double m00 = this.right.x;
        double m10 = this.right.y;
        double m20 = this.right.z;
        double m01 = this.up.x;
        double m11 = this.up.y;
        double m21 = this.up.z;
        double m02 = this.backward.x;
        double m12 = this.backward.y;
        double m22 = this.backward.z;
        double m03 = this.translation.x;
        double m13 = this.translation.y;
        double m23 = this.translation.z;
        double x = m00 * b.x + m01 * b.y + m02 * b.z + m03;
        double y = m10 * b.x + m11 * b.y + m12 * b.z + m13;
        double z = m20 * b.x + m21 * b.y + m22 * b.z + m23;
        rv.x = x;
        rv.y = y;
        rv.z = z;
        return rv;
    }

    public Vector4f setReturnValueToTransformed(Vector4f rv, Vector4f b) {
        float m00 = (float)this.right.x;
        float m10 = (float)this.right.y;
        float m20 = (float)this.right.z;
        float m30 = (float)this.right.w;
        float m01 = (float)this.up.x;
        float m11 = (float)this.up.y;
        float m21 = (float)this.up.z;
        float m31 = (float)this.up.w;
        float m02 = (float)this.backward.x;
        float m12 = (float)this.backward.y;
        float m22 = (float)this.backward.z;
        float m32 = (float)this.backward.w;
        float m03 = (float)this.translation.x;
        float m13 = (float)this.translation.y;
        float m23 = (float)this.translation.z;
        float m33 = (float)this.translation.w;
        float x = m00 * b.x + m01 * b.y + m02 * b.z + m03 * b.w;
        float y = m10 * b.x + m11 * b.y + m12 * b.z + m13 * b.w;
        float z = m20 * b.x + m21 * b.y + m22 * b.z + m23 * b.w;
        float w = m30 * b.x + m31 * b.y + m32 * b.z + m33 * b.w;
        rv.x = x;
        rv.y = y;
        rv.z = z;
        rv.w = w;
        return rv;
    }

    public Vector3f setReturnValueToTransformed(Vector3f rv, Vector3f b) {
        float m00 = (float)this.right.x;
        float m10 = (float)this.right.y;
        float m20 = (float)this.right.z;
        float m01 = (float)this.up.x;
        float m11 = (float)this.up.y;
        float m21 = (float)this.up.z;
        float m02 = (float)this.backward.x;
        float m12 = (float)this.backward.y;
        float m22 = (float)this.backward.z;
        float x = m00 * b.x + m01 * b.y + m02 * b.z;
        float y = m10 * b.x + m11 * b.y + m12 * b.z;
        float z = m20 * b.x + m21 * b.y + m22 * b.z;
        rv.x = x;
        rv.y = y;
        rv.z = z;
        return rv;
    }

    public Point3f setReturnValueToTransformed(Point3f rv, Point3f b) {
        float m00 = (float)this.right.x;
        float m10 = (float)this.right.y;
        float m20 = (float)this.right.z;
        float m01 = (float)this.up.x;
        float m11 = (float)this.up.y;
        float m21 = (float)this.up.z;
        float m02 = (float)this.backward.x;
        float m12 = (float)this.backward.y;
        float m22 = (float)this.backward.z;
        float m03 = (float)this.translation.x;
        float m13 = (float)this.translation.y;
        float m23 = (float)this.translation.z;
        float x = m00 * b.x + m01 * b.y + m02 * b.z + m03;
        float y = m10 * b.x + m11 * b.y + m12 * b.z + m13;
        float z = m20 * b.x + m21 * b.y + m22 * b.z + m23;
        rv.x = x;
        rv.y = y;
        rv.z = z;
        return rv;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Matrix4x4) {
            Matrix4x4 other = (Matrix4x4)o;
            return EquivalenceUtilities.areEquivalent(this.right, other.right) && EquivalenceUtilities.areEquivalent(this.up, other.up) && EquivalenceUtilities.areEquivalent(this.backward, other.backward) && EquivalenceUtilities.areEquivalent(this.translation, other.translation);
        }
        return false;
    }

    public int hashCode() {
        int rv = 17;
        if (this.right != null) {
            rv = 37 * rv + this.right.hashCode();
        }
        if (this.up != null) {
            rv = 37 * rv + this.up.hashCode();
        }
        if (this.backward != null) {
            rv = 37 * rv + this.backward.hashCode();
        }
        if (this.translation != null) {
            rv = 37 * rv + this.translation.hashCode();
        }
        return rv;
    }
}

