/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Ray;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;

public class Plane {
    private double m_a;
    private double m_b;
    private double m_c;
    private double m_d;

    public Plane() {
        this.set(0.0, 1.0, 0.0, 0.0);
    }

    public Plane(double a, double b, double c, double d) {
        this.set(a, b, c, d);
    }

    public Plane(double[] array) {
        this.set(array);
    }

    public Plane(Point3 position, Vector3 normal) {
        this.set(position, normal);
    }

    public Plane(AffineMatrix4x4 m) {
        this.set(m);
    }

    public Plane(Point3 a, Point3 b, Point3 c) {
        this.set(a, b, c);
    }

    public void set(double a, double b, double c, double d) {
        this.m_a = a;
        this.m_b = b;
        this.m_c = c;
        this.m_d = d;
    }

    public void set(double[] array) {
        this.set(array[0], array[1], array[2], array[3]);
    }

    private void set(double xPosition, double yPosition, double zPosition, double xNormal, double yNormal, double zNormal) {
        double EPSILON = 0.01;
        assert (EpsilonUtilities.isWithinEpsilonOf1InSquaredSpace(Tuple3.calculateMagnitudeSquared(xNormal, yNormal, zNormal), 0.01));
        this.set(xNormal, yNormal, zNormal, -(xNormal * xPosition + yNormal * yPosition + zNormal * zPosition));
    }

    public void set(Point3 position, Vector3 normal) {
        assert (!position.isNaN());
        assert (!normal.isNaN());
        this.set(position.x, position.y, position.z, normal.x, normal.y, normal.z);
    }

    public void set(AffineMatrix4x4 m) {
        assert (!m.isNaN());
        this.set(m.translation.x, m.translation.y, m.translation.z, -m.orientation.backward.x, -m.orientation.backward.y, -m.orientation.backward.z);
    }

    public void set(Point3 a, Point3 b, Point3 c) {
        assert (!a.isNaN());
        assert (!b.isNaN());
        assert (!c.isNaN());
        Vector3 ac = Vector3.createSubtraction(c, a);
        Vector3 ab = Vector3.createSubtraction(b, a);
        ac.normalize();
        ab.normalize();
        Vector3 normal = Vector3.createCrossProduct(ac, ab);
        this.set(a, normal);
    }

    public boolean isNaN() {
        return Double.isNaN(this.m_a) || Double.isNaN(this.m_b) || Double.isNaN(this.m_c) || Double.isNaN(this.m_d);
    }

    public void setNaN() {
        this.set(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public double[] getEquation(double[] rv) {
        rv[0] = this.m_a;
        rv[1] = this.m_b;
        rv[2] = this.m_c;
        rv[3] = this.m_d;
        return rv;
    }

    public double[] getEquation() {
        return this.getEquation(new double[4]);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Plane) {
            Plane plane = (Plane)o;
            return this.m_a == plane.m_a && this.m_b == plane.m_b && this.m_c == plane.m_c && this.m_d == plane.m_d;
        }
        return false;
    }

    public double intersect(Ray ray) {
        Point3 p = ray.getOrigin();
        Vector3 d = ray.getDirection();
        double denom = this.m_a * d.x + this.m_b * d.y + this.m_c * d.z;
        if (denom == 0.0) {
            return Double.NaN;
        }
        double numer = this.m_a * p.x + this.m_b * p.y + this.m_c * p.z + this.m_d;
        return -numer / denom;
    }

    public double evaluate(Point3 p) {
        return this.m_a * p.x + this.m_b * p.y + this.m_c * p.z + this.m_d;
    }

    public String toString() {
        return "edu.cmu.cs.dennisc.math.Plane[a=" + this.m_a + ",b=" + this.m_b + ",c=" + this.m_c + ",d=" + this.m_d + "]";
    }

    public static Plane valueOf(String s) {
        String[] markers = new String[]{"edu.cmu.cs.dennisc.math.Plane[a=", ",b=", ",c=", ",d=", "]"};
        double[] values = new double[markers.length - 1];
        for (int i = 0; i < values.length; ++i) {
            int begin = s.indexOf(markers[i]) + markers[i].length();
            int end = s.indexOf(markers[i + 1]);
            values[i] = Double.valueOf(s.substring(begin, end));
        }
        return new Plane(values);
    }
}

