/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

public class SineCosineCache {
    public double dTheta;
    public double[] cosines;
    public double[] sines;
    public double[] angles;

    public SineCosineCache(int length) {
        this.cosines = new double[length];
        this.sines = new double[length];
        this.angles = new double[length];
        double theta = 0.0;
        double dtheta = 1.5707963267948966 / (double)this.cosines.length;
        for (int i = 0; i < length; ++i) {
            this.angles[i] = theta;
            this.cosines[i] = Math.cos(theta);
            this.sines[i] = Math.sin(theta);
            theta += dtheta;
        }
    }

    public double getSine(int quadrant, int i) {
        int max = this.sines.length - 1;
        switch (quadrant) {
            case 0: {
                return this.sines[i];
            }
            case 1: {
                return this.sines[max - i];
            }
            case 2: {
                return -this.sines[i];
            }
            case 3: {
                return -this.sines[max - i];
            }
        }
        throw new IllegalArgumentException();
    }

    public double getCosine(int quadrant, int i) {
        int max = this.sines.length - 1;
        switch (quadrant) {
            case 0: {
                return this.cosines[i];
            }
            case 1: {
                return -this.cosines[max - i];
            }
            case 2: {
                return -this.cosines[i];
            }
            case 3: {
                return this.cosines[max - i];
            }
        }
        throw new IllegalArgumentException();
    }

    public double getAngle(int quadrant, int i) {
        return 1.5707963267948966 * (double)quadrant + this.angles[i];
    }
}

