/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.print.Printable;
import java.text.DecimalFormat;

public abstract class Tuple2
implements BinaryEncodableAndDecodable,
Printable {
    public double x = 0.0;
    public double y = 0.0;

    public Tuple2() {
    }

    public Tuple2(Tuple2 other) {
        this.set(other);
    }

    public Tuple2(double x, double y) {
        this.set(x, y);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.x = binaryDecoder.decodeDouble();
        this.y = binaryDecoder.decodeDouble();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.x);
        binaryEncoder.encode(this.y);
    }

    public StringBuffer append(StringBuffer rv, DecimalFormat decimalFormat, boolean isLines) {
        if (isLines) {
            rv.append("+-       -+\n");
            rv.append("| ");
        }
        rv.append(decimalFormat.format(this.x));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.y));
        if (isLines) {
            rv.append(" |\n");
            rv.append("+-       -+\n");
        }
        return rv;
    }

    public boolean isWithinEpsilonOf(Tuple2 other, double epsilon) {
        return EpsilonUtilities.isWithinEpsilon((Number)this.x, other.x, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)this.y, other.y, epsilon);
    }

    public boolean isWithinReasonableEpsilonOf(Tuple2 other) {
        return this.isWithinEpsilonOf(other, 0.001);
    }

    public boolean isWithinEpsilonOfUnitLengthSquared(double epsilon) {
        return EpsilonUtilities.isWithinEpsilonOf1InSquaredSpace(this.calculateMagnitudeSquared(), epsilon);
    }

    public boolean isWithinReasonableEpsilonOfUnitLengthSquared() {
        return this.isWithinEpsilonOfUnitLengthSquared(0.001);
    }

    public void set(Tuple2 other) {
        if (other != null) {
            this.x = other.x;
            this.y = other.y;
        } else {
            this.setNaN();
        }
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static Tuple2 setReturnValueToZero(Tuple2 rv) {
        rv.y = 0.0;
        rv.x = 0.0;
        return rv;
    }

    public void setZero() {
        Tuple2.setReturnValueToZero(this);
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0;
    }

    public static Tuple2 setReturnValueToNaN(Tuple2 rv) {
        rv.y = Double.NaN;
        rv.x = Double.NaN;
        return rv;
    }

    public void setNaN() {
        Tuple2.setReturnValueToNaN(this);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) && Double.isNaN(this.y);
    }

    public static Tuple2 setReturnValueToAddition(Tuple2 rv, Tuple2 a, Tuple2 b) {
        rv.x = a.x + b.x;
        rv.y = a.y + b.y;
        return rv;
    }

    public void setToAddition(Tuple2 a, Tuple2 b) {
        Tuple2.setReturnValueToAddition(this, a, b);
    }

    public void add(Tuple2 b) {
        this.setToAddition(this, b);
    }

    public static Tuple2 setReturnValueToSubtraction(Tuple2 rv, Tuple2 a, Tuple2 b) {
        rv.x = a.x - b.x;
        rv.y = a.y - b.y;
        return rv;
    }

    public void setToSubtraction(Tuple2 a, Tuple2 b) {
        Tuple2.setReturnValueToSubtraction(this, a, b);
    }

    public void subtract(Tuple2 b) {
        this.setToSubtraction(this, b);
    }

    public static Tuple2 setReturnValueToNegation(Tuple2 rv, Tuple2 a) {
        rv.x = -a.x;
        rv.y = -a.y;
        return rv;
    }

    public void setToNegation(Tuple2 a) {
        Tuple2.setReturnValueToNegation(this, a);
    }

    public void negate() {
        this.setToNegation(this);
    }

    public static Tuple2 setReturnValueToMultiplication(Tuple2 rv, Tuple2 a, Tuple2 b) {
        rv.x = a.x * b.x;
        rv.y = a.y * b.y;
        return rv;
    }

    public void setToMultiplication(Tuple2 a, Tuple2 b) {
        Tuple2.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(Tuple2 b) {
        this.setToMultiplication(this, b);
    }

    public static Tuple2 setReturnValueToMultiplication(Tuple2 rv, Tuple2 a, double b) {
        rv.x = a.x * b;
        rv.y = a.y * b;
        return rv;
    }

    public void setToMultiplication(Tuple2 a, double b) {
        Tuple2.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(double b) {
        this.setToMultiplication(this, b);
    }

    public static Tuple2 setReturnValueToDivision(Tuple2 rv, Tuple2 a, Tuple2 b) {
        rv.x = a.x / b.x;
        rv.y = a.y / b.y;
        return rv;
    }

    public void setToDivision(Tuple2 a, Tuple2 b) {
        Tuple2.setReturnValueToDivision(this, a, b);
    }

    public void divide(Tuple2 b) {
        this.setToDivision(this, b);
    }

    public static Tuple2 setReturnValueToDivision(Tuple2 rv, Tuple2 a, double b) {
        rv.x = a.x / b;
        rv.y = a.y / b;
        return rv;
    }

    public void setToDivision(Tuple2 a, double b) {
        Tuple2.setReturnValueToDivision(this, a, b);
    }

    public void divide(double b) {
        this.setToDivision(this, b);
    }

    public static Tuple2 setReturnValueToInterpolation(Tuple2 rv, Tuple2 a, Tuple2 b, double portion) {
        rv.x = a.x + (b.x - a.x) * portion;
        rv.y = a.y + (b.y - a.y) * portion;
        return rv;
    }

    public void setToInterpolation(Tuple2 a, Tuple2 b, double portion) {
        Tuple2.setReturnValueToInterpolation(this, a, b, portion);
    }

    public static double calculateMagnitudeSquared(double x, double y) {
        return x * x + y * y;
    }

    public static double calculateMagnitude(double x, double y) {
        double magnitudeSquared = Tuple2.calculateMagnitudeSquared(x, y);
        if (magnitudeSquared == 1.0) {
            return 1.0;
        }
        return Math.sqrt(magnitudeSquared);
    }

    public double calculateMagnitudeSquared() {
        return Tuple2.calculateMagnitudeSquared(this.x, this.y);
    }

    public double calculateMagnitude() {
        return Tuple2.calculateMagnitude(this.x, this.y);
    }

    public static Tuple2 setReturnValueToNormalized(Tuple2 rv, Tuple2 a) {
        rv.set(a);
        double magnitudeSquared = rv.calculateMagnitudeSquared();
        if (magnitudeSquared != 1.0) {
            rv.divide(Math.sqrt(magnitudeSquared));
        }
        return rv;
    }

    public void setToNormalized(Tuple2 a) {
        Tuple2.setReturnValueToNormalized(this, a);
    }

    public void normalize() {
        this.setToNormalized(this);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null) {
            if (this.getClass().equals(o.getClass())) {
                Tuple2 other = (Tuple2)o;
                return Double.compare(this.x, other.x) == 0 && Double.compare(this.y, other.y) == 0;
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        int rv = 17;
        rv = 37 * rv + this.getClass().hashCode();
        long lng = Double.doubleToLongBits(this.x);
        rv = 37 * rv + (int)(lng ^ lng >>> 32);
        lng = Double.doubleToLongBits(this.y);
        rv = 37 * rv + (int)(lng ^ lng >>> 32);
        return rv;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[x=");
        sb.append(this.x);
        sb.append(";y=");
        sb.append(this.y);
        sb.append("]");
        return sb.toString();
    }
}

