/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.print.Printable;
import java.text.DecimalFormat;

public abstract class Tuple3f
implements BinaryEncodableAndDecodable,
Printable {
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;

    public Tuple3f() {
    }

    public Tuple3f(Tuple3f other) {
        this.set(other);
    }

    public Tuple3f(float x, float y, float z) {
        this.set(x, y, z);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.x = binaryDecoder.decodeFloat();
        this.y = binaryDecoder.decodeFloat();
        this.z = binaryDecoder.decodeFloat();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.x);
        binaryEncoder.encode(this.y);
        binaryEncoder.encode(this.z);
    }

    public StringBuffer append(StringBuffer rv, DecimalFormat decimalFormat, boolean isLines) {
        if (isLines) {
            rv.append("+-       -+\n");
            rv.append("| ");
        }
        rv.append(decimalFormat.format(this.x));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.y));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.z));
        if (isLines) {
            rv.append(" |\n");
            rv.append("+-       -+\n");
        }
        return rv;
    }

    public boolean isWithinEpsilonOf(Tuple3f other, float epsilon) {
        return EpsilonUtilities.isWithinEpsilon((Number)Float.valueOf(this.x), other.x, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)Float.valueOf(this.y), other.y, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)Float.valueOf(this.z), other.z, epsilon);
    }

    public boolean isWithinReasonableEpsilonOf(Tuple3f other) {
        return this.isWithinEpsilonOf(other, 0.001f);
    }

    public boolean isWithinEpsilonOfUnitLengthSquared(float epsilon) {
        return EpsilonUtilities.isWithinEpsilonOf1InSquaredSpace(this.calculateMagnitudeSquared(), epsilon);
    }

    public boolean isWithinReasonableEpsilonOfUnitLengthSquared() {
        return this.isWithinEpsilonOfUnitLengthSquared(0.001f);
    }

    public void set(Tuple3f other) {
        if (other != null) {
            this.x = other.x;
            this.y = other.y;
            this.z = other.z;
        } else {
            this.setNaN();
        }
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Tuple3f setReturnValueToZero(Tuple3f rv) {
        rv.z = 0.0f;
        rv.y = 0.0f;
        rv.x = 0.0f;
        return rv;
    }

    public void setZero() {
        Tuple3f.setReturnValueToZero(this);
    }

    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    public static Tuple3f setReturnValueToNaN(Tuple3f rv) {
        rv.z = Float.NaN;
        rv.y = Float.NaN;
        rv.x = Float.NaN;
        return rv;
    }

    public void setNaN() {
        Tuple3f.setReturnValueToNaN(this);
    }

    public boolean isNaN() {
        return Float.isNaN(this.x) && Float.isNaN(this.y) && Float.isNaN(this.z);
    }

    public static Tuple3f setReturnValueToAddition(Tuple3f rv, Tuple3f a, Tuple3f b) {
        rv.x = a.x + b.x;
        rv.y = a.y + b.y;
        rv.z = a.z + b.z;
        return rv;
    }

    public void setToAddition(Tuple3f a, Tuple3f b) {
        Tuple3f.setReturnValueToAddition(this, a, b);
    }

    public void add(Tuple3f b) {
        this.setToAddition(this, b);
    }

    public static Tuple3f setReturnValueToSubtraction(Tuple3f rv, Tuple3f a, Tuple3f b) {
        rv.x = a.x - b.x;
        rv.y = a.y - b.y;
        rv.z = a.z - b.z;
        return rv;
    }

    public void setToSubtraction(Tuple3f a, Tuple3f b) {
        Tuple3f.setReturnValueToSubtraction(this, a, b);
    }

    public void subtract(Tuple3f b) {
        this.setToSubtraction(this, b);
    }

    public static Tuple3f setReturnValueToNegation(Tuple3f rv, Tuple3f a) {
        rv.x = -a.x;
        rv.y = -a.y;
        rv.z = -a.z;
        return rv;
    }

    public void setToNegation(Tuple3f a) {
        Tuple3f.setReturnValueToNegation(this, a);
    }

    public void negate() {
        this.setToNegation(this);
    }

    public static Tuple3f setReturnValueToMultiplication(Tuple3f rv, Tuple3f a, Tuple3f b) {
        rv.x = a.x * b.x;
        rv.y = a.y * b.y;
        rv.z = a.z * b.z;
        return rv;
    }

    public void setToMultiplication(Tuple3f a, Tuple3f b) {
        Tuple3f.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(Tuple3f b) {
        this.setToMultiplication(this, b);
    }

    public static Tuple3f setReturnValueToMultiplication(Tuple3f rv, Tuple3f a, float b) {
        rv.x = a.x * b;
        rv.y = a.y * b;
        rv.z = a.z * b;
        return rv;
    }

    public void setToMultiplication(Tuple3f a, float b) {
        Tuple3f.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(float b) {
        this.setToMultiplication(this, b);
    }

    public static Tuple3f setReturnValueToDivision(Tuple3f rv, Tuple3f a, Tuple3f b) {
        rv.x = a.x / b.x;
        rv.y = a.y / b.y;
        rv.z = a.z / b.z;
        return rv;
    }

    public void setToDivision(Tuple3f a, Tuple3f b) {
        Tuple3f.setReturnValueToDivision(this, a, b);
    }

    public void divide(Tuple3f b) {
        this.setToDivision(this, b);
    }

    public static Tuple3f setReturnValueToDivision(Tuple3f rv, Tuple3f a, float b) {
        rv.x = a.x / b;
        rv.y = a.y / b;
        rv.z = a.z / b;
        return rv;
    }

    public void setToDivision(Tuple3f a, float b) {
        Tuple3f.setReturnValueToDivision(this, a, b);
    }

    public void divide(float b) {
        this.setToDivision(this, b);
    }

    public static Tuple3f setReturnValueToInterpolation(Tuple3f rv, Tuple3f a, Tuple3f b, float portion) {
        rv.x = a.x + (b.x - a.x) * portion;
        rv.y = a.y + (b.y - a.y) * portion;
        rv.z = a.z + (b.z - a.z) * portion;
        return rv;
    }

    public void setToInterpolation(Tuple3f a, Tuple3f b, float portion) {
        Tuple3f.setReturnValueToInterpolation(this, a, b, portion);
    }

    public static float calculateMagnitudeSquared(float x, float y, float z) {
        return x * x + y * y + z * z;
    }

    public static float calculateMagnitude(float x, float y, float z) {
        float magnitudeSquared = Tuple3f.calculateMagnitudeSquared(x, y, z);
        if (magnitudeSquared == 1.0f) {
            return 1.0f;
        }
        return (float)Math.sqrt(magnitudeSquared);
    }

    public float calculateMagnitudeSquared() {
        return Tuple3f.calculateMagnitudeSquared(this.x, this.y, this.z);
    }

    public float calculateMagnitude() {
        return Tuple3f.calculateMagnitude(this.x, this.y, this.z);
    }

    public static Tuple3f setReturnValueToNormalized(Tuple3f rv, Tuple3f a) {
        rv.set(a);
        float magnitudeSquared = rv.calculateMagnitudeSquared();
        if ((double)magnitudeSquared != 1.0) {
            rv.divide((float)Math.sqrt(magnitudeSquared));
        }
        return rv;
    }

    public void setToNormalized(Tuple3f a) {
        Tuple3f.setReturnValueToNormalized(this, a);
    }

    public void normalize() {
        this.setToNormalized(this);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null) {
            if (this.getClass().equals(o.getClass())) {
                Tuple3f other = (Tuple3f)o;
                return Float.compare(this.x, other.x) == 0 && Float.compare(this.y, other.y) == 0 && Float.compare(this.z, other.z) == 0;
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        int rv = 17;
        rv = 37 * rv + this.getClass().hashCode();
        rv = 37 * rv + Float.floatToIntBits(this.x);
        rv = 37 * rv + Float.floatToIntBits(this.y);
        rv = 37 * rv + Float.floatToIntBits(this.z);
        return rv;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[x=");
        sb.append(this.x);
        sb.append(";y=");
        sb.append(this.y);
        sb.append(";z=");
        sb.append(this.z);
        sb.append("]");
        return sb.toString();
    }
}

