/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.print.Printable;
import java.text.DecimalFormat;

public abstract class Tuple4
implements BinaryEncodableAndDecodable,
Printable {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;
    public double w = 0.0;

    public Tuple4() {
    }

    public Tuple4(Tuple4 other) {
        this.set(other);
    }

    public Tuple4(double x, double y, double z, double w) {
        this.set(x, y, z, w);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.x = binaryDecoder.decodeDouble();
        this.y = binaryDecoder.decodeDouble();
        this.z = binaryDecoder.decodeDouble();
        this.w = binaryDecoder.decodeDouble();
    }

    public void encode(BinaryEncoder binaryEncoder) {
        binaryEncoder.encode(this.x);
        binaryEncoder.encode(this.y);
        binaryEncoder.encode(this.z);
        binaryEncoder.encode(this.w);
    }

    public StringBuffer append(StringBuffer rv, DecimalFormat decimalFormat, boolean isLines) {
        if (isLines) {
            rv.append("+-       -+\n");
            rv.append("| ");
        }
        rv.append(decimalFormat.format(this.x));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.y));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.z));
        if (isLines) {
            rv.append(" |\n");
            rv.append("| ");
        } else {
            rv.append(' ');
        }
        rv.append(decimalFormat.format(this.w));
        if (isLines) {
            rv.append(" |\n");
            rv.append("+-       -+\n");
        }
        return rv;
    }

    public boolean isWithinEpsilonOf(Tuple4 other, double epsilon) {
        return EpsilonUtilities.isWithinEpsilon((Number)this.x, other.x, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)this.y, other.y, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)this.z, other.z, epsilon) && EpsilonUtilities.isWithinEpsilon((Number)this.w, other.w, epsilon);
    }

    public boolean isWithinReasonableEpsilonOf(Tuple4 other) {
        return this.isWithinEpsilonOf(other, 0.001);
    }

    public boolean isWithinEpsilonOfUnitLengthSquared(double epsilon) {
        return EpsilonUtilities.isWithinEpsilonOf1InSquaredSpace(this.calculateMagnitudeSquared(), epsilon);
    }

    public boolean isWithinReasonableEpsilonOfUnitLengthSquared() {
        return this.isWithinEpsilonOfUnitLengthSquared(0.001);
    }

    public void set(Tuple4 other) {
        if (other != null) {
            this.x = other.x;
            this.y = other.y;
            this.z = other.z;
            this.w = other.w;
        } else {
            this.setNaN();
        }
    }

    public void set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public static Tuple4 setReturnValueToZero(Tuple4 rv) {
        rv.w = 0.0;
        rv.z = 0.0;
        rv.y = 0.0;
        rv.x = 0.0;
        return rv;
    }

    public void setZero() {
        Tuple4.setReturnValueToZero(this);
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0 && this.w == 0.0;
    }

    public static Tuple4 setReturnValueToNaN(Tuple4 rv) {
        rv.w = Double.NaN;
        rv.z = Double.NaN;
        rv.y = Double.NaN;
        rv.x = Double.NaN;
        return rv;
    }

    public void setNaN() {
        Tuple4.setReturnValueToNaN(this);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) && Double.isNaN(this.y) && Double.isNaN(this.z) && Double.isNaN(this.w);
    }

    public static Tuple4 setReturnValueToAddition(Tuple4 rv, Tuple4 a, Tuple4 b) {
        rv.x = a.x + b.x;
        rv.y = a.y + b.y;
        rv.z = a.z + b.z;
        rv.w = a.w + b.w;
        return rv;
    }

    public void setToAddition(Tuple4 a, Tuple4 b) {
        Tuple4.setReturnValueToAddition(this, a, b);
    }

    public void add(Tuple4 b) {
        this.setToAddition(this, b);
    }

    public static Tuple4 setReturnValueToSubtraction(Tuple4 rv, Tuple4 a, Tuple4 b) {
        rv.x = a.x - b.x;
        rv.y = a.y - b.y;
        rv.z = a.z - b.z;
        rv.w = a.w - b.w;
        return rv;
    }

    public void setToSubtraction(Tuple4 a, Tuple4 b) {
        Tuple4.setReturnValueToSubtraction(this, a, b);
    }

    public void subtract(Tuple4 b) {
        this.setToSubtraction(this, b);
    }

    public static Tuple4 setReturnValueToNegation(Tuple4 rv, Tuple4 a) {
        rv.x = -a.x;
        rv.y = -a.y;
        rv.z = -a.z;
        rv.w = -a.w;
        return rv;
    }

    public void setToNegation(Tuple4 a) {
        Tuple4.setReturnValueToNegation(this, a);
    }

    public void negate() {
        this.setToNegation(this);
    }

    public static Tuple4 setReturnValueToMultiplication(Tuple4 rv, Tuple4 a, Tuple4 b) {
        rv.x = a.x * b.x;
        rv.y = a.y * b.y;
        rv.z = a.z * b.z;
        rv.w = a.w * b.w;
        return rv;
    }

    public void setToMultiplication(Tuple4 a, Tuple4 b) {
        Tuple4.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(Tuple4 b) {
        this.setToMultiplication(this, b);
    }

    public static Tuple4 setReturnValueToMultiplication(Tuple4 rv, Tuple4 a, double b) {
        rv.x = a.x * b;
        rv.y = a.y * b;
        rv.z = a.z * b;
        rv.w = a.w * b;
        return rv;
    }

    public void setToMultiplication(Tuple4 a, double b) {
        Tuple4.setReturnValueToMultiplication(this, a, b);
    }

    public void multiply(double b) {
        this.setToMultiplication(this, b);
    }

    public static Tuple4 setReturnValueToDivision(Tuple4 rv, Tuple4 a, Tuple4 b) {
        rv.x = a.x / b.x;
        rv.y = a.y / b.y;
        rv.z = a.z / b.z;
        rv.w = a.w / b.w;
        return rv;
    }

    public void setToDivision(Tuple4 a, Tuple4 b) {
        Tuple4.setReturnValueToDivision(this, a, b);
    }

    public void divide(Tuple4 b) {
        this.setToDivision(this, b);
    }

    public static Tuple4 setReturnValueToDivision(Tuple4 rv, Tuple4 a, double b) {
        rv.x = a.x / b;
        rv.y = a.y / b;
        rv.z = a.z / b;
        rv.w = a.w / b;
        return rv;
    }

    public void setToDivision(Tuple4 a, double b) {
        Tuple4.setReturnValueToDivision(this, a, b);
    }

    public void divide(double b) {
        this.setToDivision(this, b);
    }

    public static Tuple4 setReturnValueToInterpolation(Tuple4 rv, Tuple4 a, Tuple4 b, double portion) {
        rv.x = a.x + (b.x - a.x) * portion;
        rv.y = a.y + (b.y - a.y) * portion;
        rv.z = a.z + (b.z - a.z) * portion;
        rv.w = a.w + (b.w - a.w) * portion;
        return rv;
    }

    public void setToInterpolation(Tuple4 a, Tuple4 b, double portion) {
        Tuple4.setReturnValueToInterpolation(this, a, b, portion);
    }

    public static double calculateMagnitudeSquared(double x, double y, double z, double w) {
        return x * x + y * y + z * z + w * w;
    }

    public static double calculateMagnitude(double x, double y, double z, double w) {
        double magnitudeSquared = Tuple4.calculateMagnitudeSquared(x, y, z, w);
        if (magnitudeSquared == 1.0) {
            return 1.0;
        }
        return Math.sqrt(magnitudeSquared);
    }

    public double calculateMagnitudeSquared() {
        return Tuple4.calculateMagnitudeSquared(this.x, this.y, this.z, this.w);
    }

    public double calculateMagnitude() {
        return Tuple4.calculateMagnitude(this.x, this.y, this.z, this.w);
    }

    public static Tuple4 setReturnValueToNormalized(Tuple4 rv, Tuple4 a) {
        rv.set(a);
        double magnitudeSquared = rv.calculateMagnitudeSquared();
        if (magnitudeSquared != 1.0) {
            rv.divide(Math.sqrt(magnitudeSquared));
        }
        return rv;
    }

    public void setToNormalized(Tuple4 a) {
        Tuple4.setReturnValueToNormalized(this, a);
    }

    public void normalize() {
        this.setToNormalized(this);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null) {
            if (this.getClass().equals(o.getClass())) {
                Tuple4 other = (Tuple4)o;
                return Double.compare(this.x, other.x) == 0 && Double.compare(this.y, other.y) == 0 && Double.compare(this.z, other.z) == 0 && Double.compare(this.w, other.w) == 0;
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        int rv = 17;
        rv = 37 * rv + this.getClass().hashCode();
        long lng = Double.doubleToLongBits(this.x);
        rv = 37 * rv + (int)(lng ^ lng >>> 32);
        lng = Double.doubleToLongBits(this.y);
        rv = 37 * rv + (int)(lng ^ lng >>> 32);
        lng = Double.doubleToLongBits(this.z);
        rv = 37 * rv + (int)(lng ^ lng >>> 32);
        lng = Double.doubleToLongBits(this.w);
        rv = 37 * rv + (int)(lng ^ lng >>> 32);
        return rv;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[x=");
        sb.append(this.x);
        sb.append(";y=");
        sb.append(this.y);
        sb.append(";z=");
        sb.append(this.z);
        sb.append(";w=");
        sb.append(this.w);
        sb.append("]");
        return sb.toString();
    }
}

