/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math.animation;

import edu.cmu.cs.dennisc.animation.DurationBasedAnimation;
import edu.cmu.cs.dennisc.animation.Style;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.UnitQuaternion;

public abstract class AffineMatrix4x4Animation
extends DurationBasedAnimation {
    private UnitQuaternion m_q0;
    private UnitQuaternion m_q1;
    private UnitQuaternion m_qBuffer;
    private AffineMatrix4x4 m_m0;
    private AffineMatrix4x4 m_m1;
    private AffineMatrix4x4 m_mBuffer;

    public AffineMatrix4x4Animation(Number duration, Style style, AffineMatrix4x4 m0, AffineMatrix4x4 m1) {
        super(duration, style);
        this.m_q0 = m0.orientation.createUnitQuaternion();
        this.m_q1 = m1.orientation.createUnitQuaternion();
        this.m_qBuffer = UnitQuaternion.createNaN();
        this.m_m0 = m0;
        this.m_m1 = m1;
        this.m_mBuffer = AffineMatrix4x4.createNaN();
    }

    protected abstract void updateValue(AffineMatrix4x4 var1);

    protected void prologue() {
        this.updateValue(this.m_m0);
    }

    protected void setPortion(double portion) {
        this.m_mBuffer.translation.setToInterpolation(this.m_m0.translation, this.m_m1.translation, portion);
        this.m_qBuffer.setToInterpolation(this.m_q0, this.m_q1, portion);
        this.m_mBuffer.orientation.setValue(this.m_qBuffer);
        this.updateValue(this.m_mBuffer);
    }

    protected void epilogue() {
        this.updateValue(this.m_m1);
    }
}

