/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.math.polynomial;

import edu.cmu.cs.dennisc.math.Matrix4x4;
import edu.cmu.cs.dennisc.math.Vector4;
import edu.cmu.cs.dennisc.math.polynomial.Cubic;

public abstract class BasisMatrixCubic
implements Cubic {
    private Matrix4x4 m_h;
    private Vector4 m_g;

    protected BasisMatrixCubic(Matrix4x4 h, Vector4 g) {
        this.m_h = h;
        this.m_g = g;
    }

    public boolean isNaN() {
        return this.m_h == null || this.m_h.isNaN() || this.m_g == null || this.m_g.isNaN();
    }

    public double evaluate(double t) {
        double ttt = t * t * t;
        double tt = t * t;
        return (ttt * this.m_h.right.x + tt * this.m_h.right.y + t * this.m_h.right.z + this.m_h.right.w) * this.m_g.x + (ttt * this.m_h.up.x + tt * this.m_h.up.y + t * this.m_h.up.z + this.m_h.up.w) * this.m_g.y + (ttt * this.m_h.backward.x + tt * this.m_h.backward.y + t * this.m_h.backward.z + this.m_h.backward.w) * this.m_g.z + (ttt * this.m_h.translation.x + tt * this.m_h.translation.y + t * this.m_h.translation.z + this.m_h.translation.w) * this.m_g.w;
    }

    public double evaluateDerivative(double t) {
        double tt3 = t * t * 3.0;
        double t2 = t * 2.0;
        return (tt3 * this.m_h.right.x + t2 * this.m_h.right.y + this.m_h.right.z) * this.m_g.x + (tt3 * this.m_h.up.x + t2 * this.m_h.up.y + this.m_h.up.z) * this.m_g.y + (tt3 * this.m_h.backward.x + t2 * this.m_h.backward.y + this.m_h.backward.z) * this.m_g.z + (tt3 * this.m_h.translation.x + t2 * this.m_h.translation.y + this.m_h.translation.z) * this.m_g.w;
    }
}

