/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.media.jmf;

import edu.cmu.cs.dennisc.awt.DimensionUtilties;
import edu.cmu.cs.dennisc.awt.WindowUtilties;
import edu.cmu.cs.dennisc.croquet.swing.BorderPane;
import edu.cmu.cs.dennisc.math.EpsilonUtilities;
import edu.cmu.cs.dennisc.media.jmf.PrefetchControllerListener;
import edu.cmu.cs.dennisc.media.jmf.RealizeControllerListener;
import edu.cmu.cs.dennisc.media.jmf.StopControllerListener;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.swing.JDialogUtilities;
import java.awt.Component;
import java.awt.Dimension;
import javax.media.ControllerListener;
import javax.media.GainControl;
import javax.media.Time;
import javax.swing.JDialog;

public class Player
extends edu.cmu.cs.dennisc.media.Player {
    private javax.media.Player player;
    private double volumeLevel;
    private double startTime;
    private double stopTime;

    Player(javax.media.Player player, double volumeLevel, double startTime, double stopTime) {
        this.player = player;
        this.volumeLevel = volumeLevel;
        this.startTime = startTime;
        this.stopTime = stopTime;
    }

    public void realize() {
        if (this.player.getState() < 300) {
            PrintUtilities.println("realize: ", this.player.getState());
            RealizeControllerListener controllerListener = new RealizeControllerListener();
            this.player.addControllerListener((ControllerListener)controllerListener);
            this.player.realize();
            controllerListener.await();
            this.player.removeControllerListener((ControllerListener)controllerListener);
        }
    }

    public void prefetch() {
        if (this.player.getState() < 500) {
            PrefetchControllerListener controllerListener = new PrefetchControllerListener();
            this.player.addControllerListener((ControllerListener)controllerListener);
            this.player.prefetch();
            controllerListener.await();
            this.player.removeControllerListener((ControllerListener)controllerListener);
        }
    }

    public void start() {
        this.realize();
        if (!Double.isNaN(this.startTime)) {
            this.player.setMediaTime(new Time(this.startTime));
        }
        if (!Double.isNaN(this.stopTime)) {
            this.player.setStopTime(new Time(this.stopTime));
        }
        if (!EpsilonUtilities.isWithinReasonableEpsilon((Number)this.volumeLevel, 1.0)) {
            GainControl gainControl = this.player.getGainControl();
            float defaultVolumeLevel = gainControl.getLevel();
            float v = (float)(this.volumeLevel * (double)defaultVolumeLevel);
            v = Math.max(v, 0.0f);
            v = Math.min(v, 1.0f);
            gainControl.setLevel(v);
        }
        this.player.start();
    }

    public void stop() {
        this.player.stop();
    }

    public double getDuration() {
        return this.player.getDuration().getSeconds();
    }

    public double getTimeRemaining() {
        Time duration = this.player.getDuration();
        Time stop = this.player.getStopTime();
        Time curr = this.player.getMediaTime();
        return Math.min(duration.getSeconds(), stop.getSeconds()) - curr.getSeconds();
    }

    public void playUntilStop() {
        StopControllerListener controllerListener = new StopControllerListener();
        this.player.addControllerListener((ControllerListener)controllerListener);
        this.start();
        controllerListener.await();
        this.player.removeControllerListener((ControllerListener)controllerListener);
    }

    public Component getControlPanelComponent() {
        this.realize();
        return this.player.getControlPanelComponent();
    }

    public Component getVisualComponent() {
        this.realize();
        return this.player.getVisualComponent();
    }

    public void test(Component owner) {
        Component visualComponent;
        BorderPane content = new BorderPane(){

            public Dimension getPreferredSize() {
                return DimensionUtilties.constrainToMinimumWidth(super.getPreferredSize(), 320);
            }
        };
        final JDialog dialog = JDialogUtilities.createJDialog(owner, "test", true);
        dialog.getContentPane().add((Component)content, "Center");
        Component controlPanelComponent = this.getControlPanelComponent();
        if (controlPanelComponent != null) {
            content.add(controlPanelComponent, "South");
        }
        if ((visualComponent = this.getVisualComponent()) != null) {
            content.add(visualComponent, "Center");
        }
        dialog.pack();
        WindowUtilties.setLocationOnScreenToCenteredWithin(dialog, owner);
        new Thread(){

            public void run() {
                Player.this.playUntilStop();
                dialog.setVisible(false);
            }
        }.start();
        dialog.setVisible(true);
        this.stop();
    }
}

