/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.pathfinding;

public class Cell {
    public static final Cell OUT_OF_BOUNDS_CELL = new Cell(-1, -1);
    private int m_row;
    private int m_column;
    private boolean m_isOccupied;
    private Cell m_parent = null;

    Cell() {
    }

    Cell(int row, int column) {
        this.setRow(row);
        this.setColumn(column);
    }

    public boolean equals(Object other) {
        if (other instanceof Cell) {
            Cell otherCell = (Cell)other;
            return this.isLocatedAt(otherCell.m_row, otherCell.m_column);
        }
        return super.equals(other);
    }

    public boolean isLocatedAt(int row, int column) {
        return this.m_row == row && this.m_column == column;
    }

    public int getRow() {
        if (this.isOutOfBounds()) {
            throw new RuntimeException();
        }
        return this.m_row;
    }

    public int getColumn() {
        if (this.isOutOfBounds()) {
            throw new RuntimeException();
        }
        return this.m_column;
    }

    private void setRow(int row) {
        this.m_row = row;
    }

    private void setColumn(int column) {
        this.m_column = column;
    }

    public boolean isOutOfBounds() {
        return this.m_row < 0 || this.m_column < 0;
    }

    public boolean isOccupied() {
        if (this.isOutOfBounds()) {
            throw new RuntimeException();
        }
        return this.m_isOccupied;
    }

    public void setOccupied(boolean isOccupied) {
        if (this.isOutOfBounds()) {
            throw new RuntimeException();
        }
        this.m_isOccupied = isOccupied;
    }

    public Cell getParent() {
        if (this.isOutOfBounds()) {
            throw new RuntimeException();
        }
        return this.m_parent;
    }

    public void setParent(Cell parent) {
        if (this.isOutOfBounds()) {
            throw new RuntimeException();
        }
        if (parent == this) {
            throw new RuntimeException();
        }
        this.m_parent = parent;
    }

    public int getGToNeighbor(Cell neighbor) {
        if (this.isOutOfBounds()) {
            throw new RuntimeException();
        }
        if (this.m_row == neighbor.m_row) {
            return 10;
        }
        if (this.m_column == neighbor.m_column) {
            return 10;
        }
        return 14;
    }

    public int getG() {
        if (this.isOutOfBounds()) {
            throw new RuntimeException();
        }
        if (this.m_parent != null) {
            return this.getGToNeighbor(this.m_parent) + this.m_parent.getG();
        }
        return 0;
    }

    public int getH(Cell dst) {
        if (this.isOutOfBounds()) {
            throw new RuntimeException();
        }
        int rowCount = Math.abs(this.m_row - dst.m_row);
        int columnCount = Math.abs(this.m_column - dst.m_column);
        int max = Math.max(rowCount, columnCount);
        int min = Math.min(rowCount, columnCount);
        return max * 10 + min * 4;
    }

    public String toString() {
        return "[ " + this.m_row + ", " + this.m_column + " ]";
    }
}

