/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.pathfinding;

import edu.cmu.cs.dennisc.lang.ThreadUtilities;
import edu.cmu.cs.dennisc.pathfinding.Cell;
import edu.cmu.cs.dennisc.pathfinding.Heading;
import java.awt.Component;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grid {
    private Random s_random = new Random(System.currentTimeMillis());
    private Cell[][] m_cells;

    public Grid(int rowCount, int columnCount) {
        this.m_cells = new Cell[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int column = 0; column < columnCount; ++column) {
                this.m_cells[row][column] = new Cell(row, column);
            }
        }
    }

    public int getRowCount() {
        return this.m_cells.length;
    }

    public int getColumnCount() {
        if (this.m_cells.length > 0) {
            return this.m_cells[0].length;
        }
        return 0;
    }

    private Cell getAdjacentCell(Cell cell, Heading heading) {
        int row = cell.getRow();
        int column = cell.getColumn();
        switch (heading) {
            case NORTH: 
            case NORTH_EAST: 
            case NORTH_WEST: {
                --row;
                break;
            }
            case SOUTH: 
            case SOUTH_EAST: 
            case SOUTH_WEST: {
                ++row;
            }
        }
        switch (heading) {
            case NORTH_EAST: 
            case SOUTH_EAST: 
            case EAST: {
                ++column;
                break;
            }
            case NORTH_WEST: 
            case SOUTH_WEST: 
            case WEST: {
                --column;
            }
        }
        try {
            return this.m_cells[row][column];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return Cell.OUT_OF_BOUNDS_CELL;
        }
    }

    public Cell getCellAt(int row, int column) {
        return this.m_cells[row][column];
    }

    public Cell getRandomCell() {
        return this.getCellAt(this.s_random.nextInt(this.getRowCount()), this.s_random.nextInt(this.getColumnCount()));
    }

    public boolean isWalkableBetweenNeighbors(Cell src, Cell dst) {
        if (src.isOccupied()) {
            return false;
        }
        if (dst.isOccupied()) {
            return false;
        }
        int srcRow = src.getRow();
        int srcColumn = src.getColumn();
        int dstRow = dst.getRow();
        int dstColumn = dst.getColumn();
        if (srcRow != dstRow && srcColumn != dstColumn) {
            if (this.getCellAt(srcRow, dstColumn).isOccupied()) {
                return false;
            }
            if (this.getCellAt(dstRow, srcColumn).isOccupied()) {
                return false;
            }
        }
        return true;
    }

    private Cell[] getNeighbors(Cell src) {
        Cell[] neighbors = new Cell[]{this.getAdjacentCell(src, Heading.NORTH), this.getAdjacentCell(src, Heading.NORTH_EAST), this.getAdjacentCell(src, Heading.EAST), this.getAdjacentCell(src, Heading.SOUTH_EAST), this.getAdjacentCell(src, Heading.SOUTH), this.getAdjacentCell(src, Heading.SOUTH_WEST), this.getAdjacentCell(src, Heading.WEST), this.getAdjacentCell(src, Heading.NORTH_WEST)};
        return neighbors;
    }

    private Cell getCellWithMinimumF(Set<Cell> open, Cell dst) {
        int fMin = Integer.MAX_VALUE;
        Cell cellMin = null;
        for (Cell cell : open) {
            int h;
            int g = cell.getG();
            int f = g + (h = cell.getH(dst));
            if (f >= fMin) continue;
            fMin = f;
            cellMin = cell;
        }
        return cellMin;
    }

    public Vector<Cell> findShortestPathBetween(Cell src, Cell dst, Set<Cell> open, Set<Cell> closed, Component observer) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column = 0; column < this.getColumnCount(); ++column) {
                this.m_cells[row][column].setParent(null);
            }
        }
        for (Cell neighbor : this.getNeighbors(src)) {
            if (neighbor.isOutOfBounds() || !this.isWalkableBetweenNeighbors(src, neighbor)) continue;
            neighbor.setParent(src);
            open.add(neighbor);
        }
        closed.add(src);
        while (!open.isEmpty()) {
            Cell bestNeighbor;
            if (observer != null) {
                observer.repaint();
                ThreadUtilities.sleep(100L);
            }
            if ((bestNeighbor = this.getCellWithMinimumF(open, dst)).equals(dst)) {
                Vector<Cell> path = new Vector<Cell>(closed.size() + 1);
                for (Cell cell = dst; cell != null; cell = cell.getParent()) {
                    path.addElement(cell);
                }
                return path;
            }
            open.remove(bestNeighbor);
            closed.add(bestNeighbor);
            int gCurrent = bestNeighbor.getG();
            for (Cell cell : this.getNeighbors(bestNeighbor)) {
                Cell parentCache;
                if (cell.isOutOfBounds() || !this.isWalkableBetweenNeighbors(bestNeighbor, cell) || closed.contains(cell)) continue;
                if (open.contains(cell)) {
                    parentCache = gCurrent + bestNeighbor.getGToNeighbor(cell) < cell.getG() ? bestNeighbor : cell.getParent();
                } else {
                    parentCache = bestNeighbor;
                    open.add(cell);
                }
                cell.setParent(parentCache);
            }
        }
        return null;
    }

    public Vector<Cell> findShortestPathBetween(Cell src, Cell dst) {
        if (src.equals(dst)) {
            Vector<Cell> path = new Vector<Cell>(2);
            path.add(src);
            path.add(dst);
            return path;
        }
        return this.findShortestPathBetween(src, dst, new HashSet<Cell>(), new HashSet<Cell>(), null);
    }
}

