/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.pattern;

import edu.cmu.cs.dennisc.equivalence.EquivalenceUtilities;
import edu.cmu.cs.dennisc.pattern.DefaultReleasable;
import edu.cmu.cs.dennisc.pattern.NameChangeListenable;
import edu.cmu.cs.dennisc.pattern.Nameable;
import edu.cmu.cs.dennisc.pattern.event.NameEvent;
import edu.cmu.cs.dennisc.pattern.event.NameListener;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElement
extends DefaultReleasable
implements Nameable,
NameChangeListenable {
    private List<NameListener> m_nameListeners = new LinkedList<NameListener>();
    private String m_name = null;

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String name) {
        if (EquivalenceUtilities.areNotEquivalent(this.m_name, name)) {
            NameEvent nameEvent = new NameEvent(this, name);
            for (NameListener nameListeners : this.m_nameListeners) {
                nameListeners.nameChanging(nameEvent);
            }
            this.m_name = name;
            for (NameListener nameListeners : this.m_nameListeners) {
                nameListeners.nameChanged(nameEvent);
            }
        }
    }

    @Override
    public void addNameListener(NameListener nameListener) {
        this.m_nameListeners.add(nameListener);
    }

    @Override
    public void removeNameListener(NameListener nameListener) {
        this.m_nameListeners.remove(nameListener);
    }

    @Override
    public Iterable<NameListener> getNameListeners() {
        return this.m_nameListeners;
    }
}

