/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.pattern;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.codec.ReferenceableBinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.equivalence.EquivalenceUtilities;
import edu.cmu.cs.dennisc.lang.reflect.ReflectionUtilities;
import edu.cmu.cs.dennisc.pattern.AbstractElement;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import edu.cmu.cs.dennisc.property.GetterSetterProperty;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.property.InstancePropertyOwner;
import edu.cmu.cs.dennisc.property.Property;
import edu.cmu.cs.dennisc.property.PropertyOwner;
import edu.cmu.cs.dennisc.property.event.AddListPropertyEvent;
import edu.cmu.cs.dennisc.property.event.ClearListPropertyEvent;
import edu.cmu.cs.dennisc.property.event.ListPropertyListener;
import edu.cmu.cs.dennisc.property.event.PropertyEvent;
import edu.cmu.cs.dennisc.property.event.PropertyListener;
import edu.cmu.cs.dennisc.property.event.RemoveListPropertyEvent;
import edu.cmu.cs.dennisc.property.event.SetListPropertyEvent;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultInstancePropertyOwner
extends AbstractElement
implements InstancePropertyOwner,
ReferenceableBinaryEncodableAndDecodable {
    private static HashMap<Class<? extends PropertyOwner>, List<Property<?>>> s_classToPropertiesMap = new HashMap();
    private List<Property<?>> m_properties = null;
    private List<PropertyListener> m_propertyListeners = new LinkedList<PropertyListener>();
    private List<ListPropertyListener<?>> m_listPropertyListeners = new LinkedList();

    public abstract boolean isComposedOfGetterAndSetterProperties();

    public void addPropertyListener(PropertyListener propertyListener) {
        this.m_propertyListeners.add(propertyListener);
    }

    public void removePropertyListener(PropertyListener propertyListener) {
        this.m_propertyListeners.remove(propertyListener);
    }

    public Iterable<PropertyListener> accessPropertyListeners() {
        return this.m_propertyListeners;
    }

    @Override
    public void firePropertyChanging(PropertyEvent e) {
        for (PropertyListener propertyListener : this.m_propertyListeners) {
            propertyListener.propertyChanging(e);
        }
    }

    @Override
    public void firePropertyChanged(PropertyEvent e) {
        for (PropertyListener propertyListener : this.m_propertyListeners) {
            propertyListener.propertyChanged(e);
        }
    }

    public void addListPropertyListener(ListPropertyListener<?> listPropertyListener) {
        this.m_listPropertyListeners.add(listPropertyListener);
    }

    public void removeListPropertyListener(ListPropertyListener<?> listPropertyListener) {
        this.m_listPropertyListeners.remove(listPropertyListener);
    }

    public Iterable<ListPropertyListener<?>> accessListPropertyListeners() {
        return this.m_listPropertyListeners;
    }

    public void fireAdding(AddListPropertyEvent e) {
        for (ListPropertyListener<?> l : this.m_listPropertyListeners) {
            l.adding(e);
        }
    }

    public void fireAdded(AddListPropertyEvent e) {
        for (ListPropertyListener<?> l : this.m_listPropertyListeners) {
            l.added(e);
        }
    }

    public void fireClearing(ClearListPropertyEvent e) {
        for (ListPropertyListener<?> l : this.m_listPropertyListeners) {
            l.clearing(e);
        }
    }

    public void fireCleared(ClearListPropertyEvent e) {
        for (ListPropertyListener<?> l : this.m_listPropertyListeners) {
            l.cleared(e);
        }
    }

    public void fireRemoving(RemoveListPropertyEvent e) {
        for (ListPropertyListener<?> l : this.m_listPropertyListeners) {
            l.removing(e);
        }
    }

    public void fireRemoved(RemoveListPropertyEvent e) {
        for (ListPropertyListener<?> l : this.m_listPropertyListeners) {
            l.removed(e);
        }
    }

    public void fireSetting(SetListPropertyEvent e) {
        for (ListPropertyListener<?> l : this.m_listPropertyListeners) {
            l.setting(e);
        }
    }

    public void fireSet(SetListPropertyEvent e) {
        for (ListPropertyListener<?> l : this.m_listPropertyListeners) {
            l.set(e);
        }
    }

    @Override
    public Property<?> getPropertyNamed(String name) {
        if (this.isComposedOfGetterAndSetterProperties()) {
            for (Property<?> property : this.getProperties()) {
                if (!property.getName().equals(name)) continue;
                return property;
            }
            return null;
        }
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        try {
            Field field = this.getClass().getField(name);
            return (Property)ReflectionUtilities.get(field, this);
        }
        catch (NoSuchFieldException nsfe) {
            return null;
        }
    }

    @Override
    public InstanceProperty<?> getInstancePropertyNamed(String name) {
        return (InstanceProperty)this.getPropertyNamed(name);
    }

    @Override
    public Iterable<Property<?>> getProperties() {
        Class<?> cls = this.getClass();
        if (this.isComposedOfGetterAndSetterProperties()) {
            List<Property<?>> rv = s_classToPropertiesMap.get(cls);
            if (rv == null) {
                rv = new LinkedList();
                for (Field field : cls.getFields()) {
                    int modifiers = field.getModifiers();
                    if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !GetterSetterProperty.class.isAssignableFrom(field.getType())) continue;
                    rv.add((Property)ReflectionUtilities.get(field, null));
                }
                s_classToPropertiesMap.put(cls, rv);
            }
            return rv;
        }
        if (this.m_properties == null) {
            this.m_properties = new LinkedList();
            for (Field field : cls.getFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || !InstanceProperty.class.isAssignableFrom(field.getType())) continue;
                InstanceProperty instanceProperty = (InstanceProperty)ReflectionUtilities.get(field, this);
                assert (instanceProperty.getOwner() == this);
                this.m_properties.add(instanceProperty);
            }
        }
        return this.m_properties;
    }

    @Override
    public String lookupNameFor(InstanceProperty<?> instanceProperty) {
        for (Field field : this.getClass().getFields()) {
            int modifiers;
            if (!Property.class.isAssignableFrom(field.getType()) || !Modifier.isPublic(modifiers = field.getModifiers()) || Modifier.isStatic(modifiers) || ReflectionUtilities.get(field, this) != instanceProperty) continue;
            return field.getName();
        }
        return null;
    }

    private Object decodeObject(BinaryDecoder binaryDecoder, Class valueCls, Map<Integer, ReferenceableBinaryEncodableAndDecodable> map) {
        Object rv;
        if (BinaryEncodableAndDecodable.class.isAssignableFrom(valueCls)) {
            rv = binaryDecoder.decodeBinaryEncodableAndDecodable(valueCls);
        } else if (ReferenceableBinaryEncodableAndDecodable.class.isAssignableFrom(valueCls)) {
            rv = binaryDecoder.decodeReferenceableBinaryEncodableAndDecodable(valueCls, map);
        } else if (Boolean.class == valueCls) {
            rv = binaryDecoder.decodeBoolean();
        } else if (Byte.class == valueCls) {
            rv = binaryDecoder.decodeByte();
        } else if (Character.class == valueCls) {
            rv = Character.valueOf(binaryDecoder.decodeChar());
        } else if (Double.class == valueCls) {
            rv = binaryDecoder.decodeDouble();
        } else if (Float.class == valueCls) {
            rv = Float.valueOf(binaryDecoder.decodeFloat());
        } else if (Integer.class == valueCls) {
            rv = binaryDecoder.decodeInt();
        } else if (Long.class == valueCls) {
            rv = binaryDecoder.decodeLong();
        } else if (Short.class == valueCls) {
            rv = binaryDecoder.decodeShort();
        } else if (String.class == valueCls) {
            rv = binaryDecoder.decodeString();
        } else if (Enum.class.isAssignableFrom(valueCls)) {
            rv = binaryDecoder.decodeEnum(valueCls);
        } else {
            throw new RuntimeException(valueCls.getName());
        }
        return rv;
    }

    @Override
    public void decode(BinaryDecoder binaryDecoder, Map<Integer, ReferenceableBinaryEncodableAndDecodable> map) {
        String propertyName;
        while ((propertyName = binaryDecoder.decodeString()).length() > 0) {
            Object value;
            Property<?> property = this.getPropertyNamed(propertyName);
            assert (property != null);
            String valueClsName = binaryDecoder.decodeString();
            assert (valueClsName != null);
            if (valueClsName.equals("")) {
                value = null;
            } else {
                Class<?> valueCls = ReflectionUtilities.getClassForName(valueClsName);
                if (valueCls.isArray()) {
                    if (boolean[].class == valueCls) {
                        value = binaryDecoder.decodeBooleanArray();
                    } else if (byte[].class == valueCls) {
                        value = binaryDecoder.decodeByteArray();
                    } else if (char[].class == valueCls) {
                        value = binaryDecoder.decodeCharArray();
                    } else if (double[].class == valueCls) {
                        value = binaryDecoder.decodeDoubleArray();
                    } else if (float[].class == valueCls) {
                        value = binaryDecoder.decodeFloatArray();
                    } else if (int[].class == valueCls) {
                        value = binaryDecoder.decodeIntArray();
                    } else if (long[].class == valueCls) {
                        value = binaryDecoder.decodeLongArray();
                    } else if (short[].class == valueCls) {
                        value = binaryDecoder.decodeShortArray();
                    } else if (String[].class == valueCls) {
                        value = binaryDecoder.decodeStringArray();
                    } else if (Enum[].class.isAssignableFrom(valueCls)) {
                        value = binaryDecoder.decodeEnumArray(valueCls.getComponentType());
                    } else if (BinaryEncodableAndDecodable[].class.isAssignableFrom(valueCls)) {
                        value = binaryDecoder.decodeBinaryEncodableAndDecodableArray(valueCls.getComponentType());
                    } else if (ReferenceableBinaryEncodableAndDecodable[].class.isAssignableFrom(valueCls)) {
                        value = binaryDecoder.decodeReferenceableBinaryEncodableAndDecodableArray(valueCls.getComponentType(), map);
                    } else {
                        int length = binaryDecoder.decodeInt();
                        value = Array.newInstance(valueCls.getComponentType(), length);
                        for (int i = 0; i < length; ++i) {
                            Array.set(value, i, this.decodeObject(binaryDecoder, valueCls.getComponentType(), map));
                        }
                    }
                } else if (Collection.class.isAssignableFrom(valueCls)) {
                    int size = binaryDecoder.decodeInt();
                    Collection collection = (Collection)ReflectionUtilities.newInstance(valueCls);
                    for (int i = 0; i < size; ++i) {
                        String componentTypeName = binaryDecoder.decodeString();
                        Class<?> componentType = ReflectionUtilities.getClassForName(componentTypeName);
                        collection.add(this.decodeObject(binaryDecoder, componentType, map));
                    }
                    value = null;
                } else {
                    value = this.decodeObject(binaryDecoder, valueCls, map);
                }
            }
            property.setValue(this, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void encodeObject(BinaryEncoder binaryEncoder, Object value, Map<ReferenceableBinaryEncodableAndDecodable, Integer> map) {
        if (value != null) {
            Class<?> valueCls = value.getClass();
            if (BinaryEncodableAndDecodable.class.isAssignableFrom(valueCls)) {
                binaryEncoder.encode((BinaryEncodableAndDecodable)value);
                return;
            } else if (ReferenceableBinaryEncodableAndDecodable.class.isAssignableFrom(valueCls)) {
                binaryEncoder.encode((ReferenceableBinaryEncodableAndDecodable)value, map);
                return;
            } else if (Boolean.class == valueCls) {
                binaryEncoder.encode((Boolean)value);
                return;
            } else if (Byte.class == valueCls) {
                binaryEncoder.encode((Byte)value);
                return;
            } else if (Character.class == valueCls) {
                binaryEncoder.encode(((Character)value).charValue());
                return;
            } else if (Double.class == valueCls) {
                binaryEncoder.encode((Double)value);
                return;
            } else if (Float.class == valueCls) {
                binaryEncoder.encode(((Float)value).floatValue());
                return;
            } else if (Integer.class == valueCls) {
                binaryEncoder.encode((Integer)value);
                return;
            } else if (Long.class == valueCls) {
                binaryEncoder.encode((Long)value);
                return;
            } else if (Short.class == valueCls) {
                binaryEncoder.encode((Short)value);
                return;
            } else if (String.class == valueCls) {
                binaryEncoder.encode((String)value);
                return;
            } else {
                if (!Enum.class.isAssignableFrom(valueCls)) throw new RuntimeException(value.getClass().getName() + " " + value.toString());
                binaryEncoder.encode((Enum)value);
            }
            return;
        } else {
            binaryEncoder.encode("");
        }
    }

    @Override
    public void encode(BinaryEncoder binaryEncoder, Map<ReferenceableBinaryEncodableAndDecodable, Integer> map) {
        for (Property<?> property : this.getProperties()) {
            binaryEncoder.encode(property.getName());
            Object value = property.getValue(this);
            if (value != null) {
                Class<?> valueCls = value.getClass();
                binaryEncoder.encode(valueCls.getName());
                if (valueCls.isArray()) {
                    if (boolean[].class == valueCls) {
                        binaryEncoder.encode((boolean[])value);
                        continue;
                    }
                    if (byte[].class == valueCls) {
                        binaryEncoder.encode((byte[])value);
                        continue;
                    }
                    if (char[].class == valueCls) {
                        binaryEncoder.encode((char[])value);
                        continue;
                    }
                    if (double[].class == valueCls) {
                        binaryEncoder.encode((double[])value);
                        continue;
                    }
                    if (float[].class == valueCls) {
                        binaryEncoder.encode((float[])value);
                        continue;
                    }
                    if (int[].class == valueCls) {
                        binaryEncoder.encode((int[])value);
                        continue;
                    }
                    if (long[].class == valueCls) {
                        binaryEncoder.encode((long[])value);
                        continue;
                    }
                    if (short[].class == valueCls) {
                        binaryEncoder.encode((short[])value);
                        continue;
                    }
                    if (String[].class == valueCls) {
                        binaryEncoder.encode((String[])value);
                        continue;
                    }
                    if (Enum[].class.isAssignableFrom(valueCls)) {
                        binaryEncoder.encode((Enum[])value);
                        continue;
                    }
                    if (BinaryEncodableAndDecodable[].class.isAssignableFrom(valueCls)) {
                        binaryEncoder.encode((BinaryEncodableAndDecodable[])value);
                        continue;
                    }
                    if (ReferenceableBinaryEncodableAndDecodable[].class.isAssignableFrom(valueCls)) {
                        binaryEncoder.encode((ReferenceableBinaryEncodableAndDecodable[])value, map);
                        continue;
                    }
                    int length = Array.getLength(value);
                    binaryEncoder.encode(length);
                    for (int i = 0; i < length; ++i) {
                        this.encodeObject(binaryEncoder, Array.get(value, i), map);
                    }
                    continue;
                }
                if (Collection.class.isAssignableFrom(valueCls)) {
                    Collection collection = (Collection)value;
                    int size = collection.size();
                    binaryEncoder.encode(size);
                    for (Object o : collection) {
                        this.encodeObject(binaryEncoder, o, map);
                    }
                    continue;
                }
                this.encodeObject(binaryEncoder, value, map);
                continue;
            }
            binaryEncoder.encode("");
        }
        binaryEncoder.encode("");
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public boolean isEquivalentTo(Object other) {
        if (this == other || super.equals(other)) {
            return true;
        }
        if (other instanceof DefaultInstancePropertyOwner) {
            DefaultInstancePropertyOwner otherDIPO = (DefaultInstancePropertyOwner)other;
            int propertyCount = 0;
            for (Property<?> thisProperty : this.getProperties()) {
                String propertyName = thisProperty.getName();
                try {
                    Property<?> otherProperty = otherDIPO.getPropertyNamed(propertyName);
                    if (otherProperty != null) {
                        Object thisValue = thisProperty.getValue(this);
                        Object otherValue = otherProperty.getValue(otherDIPO);
                        if (thisValue instanceof DefaultInstancePropertyOwner) {
                            if (!((DefaultInstancePropertyOwner)thisValue).isEquivalentTo(otherValue)) {
                                return false;
                            }
                        } else if (!EquivalenceUtilities.areEquivalent(thisValue, otherValue)) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    ++propertyCount;
                }
                catch (Exception e) {
                    PrintUtilities.println("WARNING: exception in equivalence check:", e);
                    e.printStackTrace();
                    return false;
                }
            }
            for (Property<?> otherProperty : otherDIPO.getProperties()) {
                --propertyCount;
            }
            return propertyCount == 0;
        }
        return false;
    }
}

