/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.preference;

import edu.cmu.cs.dennisc.preference.CollectionOfPreferences;
import edu.cmu.cs.dennisc.preference.event.PreferenceEvent;
import edu.cmu.cs.dennisc.preference.event.PreferenceListener;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Preference<E> {
    private CollectionOfPreferences collectionOfPreferences;
    private String key;
    private E defaultValue;
    private boolean isTransient;
    private E currentValueIfTransient;
    private List<PreferenceListener<E>> preferenceListeners = new LinkedList<PreferenceListener<E>>();

    public Preference(E defaultValue) {
        this.defaultValue = defaultValue;
    }

    void initialize(CollectionOfPreferences collectionOfPreferences, String key, boolean isTransient) {
        this.collectionOfPreferences = collectionOfPreferences;
        this.key = key;
        this.isTransient = isTransient;
        if (this.isTransient) {
            this.currentValueIfTransient = this.defaultValue;
        }
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public String getKey() {
        return this.key;
    }

    public E getDefaultValue() {
        return this.defaultValue;
    }

    protected abstract E getValue(Preferences var1, String var2, E var3);

    protected abstract void setAndCommitValue(Preferences var1, String var2, E var3);

    public final E getValue() {
        if (this.isTransient) {
            return this.currentValueIfTransient;
        }
        Preferences utilPrefs = this.collectionOfPreferences.getUtilPrefs();
        return this.getValue(utilPrefs, this.key, this.defaultValue);
    }

    public final void setAndCommitValue(E nextValue) {
        PreferenceEvent<E> e;
        Preferences utilPrefs = this.collectionOfPreferences.getUtilPrefs();
        if (this.preferenceListeners != null) {
            E prevValue = this.isTransient ? this.currentValueIfTransient : this.getValue(utilPrefs, this.key, this.defaultValue);
            e = new PreferenceEvent<E>(this, prevValue, nextValue);
        } else {
            e = null;
        }
        if (e != null) {
            this.firePropertyChanging(e);
        }
        if (this.isTransient) {
            this.currentValueIfTransient = nextValue;
        } else {
            this.setAndCommitValue(utilPrefs, this.key, nextValue);
        }
        if (e != null) {
            this.firePropertyChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyListener(PreferenceListener<E> propertyListener) {
        List<PreferenceListener<E>> list = this.preferenceListeners;
        synchronized (list) {
            this.preferenceListeners.add(propertyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyListener(PreferenceListener<E> propertyListener) {
        List<PreferenceListener<E>> list = this.preferenceListeners;
        synchronized (list) {
            this.preferenceListeners.remove(propertyListener);
        }
    }

    public Iterable<PreferenceListener<E>> getPropertyListeners() {
        return this.preferenceListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChanging(PreferenceEvent<E> e) {
        if (this.preferenceListeners != null) {
            List<PreferenceListener<E>> list = this.preferenceListeners;
            synchronized (list) {
                for (PreferenceListener<E> propertyListener : this.preferenceListeners) {
                    propertyListener.valueChanging(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChanged(PreferenceEvent<E> e) {
        if (this.preferenceListeners != null) {
            List<PreferenceListener<E>> list = this.preferenceListeners;
            synchronized (list) {
                for (PreferenceListener<E> propertyListener : this.preferenceListeners) {
                    propertyListener.valueChanged(e);
                }
            }
        }
    }
}

