/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.program;

import edu.cmu.cs.dennisc.alice.ProgramClosedException;
import edu.cmu.cs.dennisc.clipboard.ClipboardUtilities;
import edu.cmu.cs.dennisc.lang.ThreadWithRevealingToString;
import edu.cmu.cs.dennisc.print.PrintUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public abstract class Program
extends JApplet {
    private Map<String, String> argNameToValueMap = null;
    private boolean isClosed = false;
    private JLayeredPane layeredPane;
    private boolean isInitializationSuccessful = false;
    private Semaphore semaphore = new Semaphore(0);

    protected boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
    }

    public String getParameter(String name) {
        if (this.argNameToValueMap != null) {
            return this.argNameToValueMap.get(name);
        }
        return super.getParameter(name);
    }

    public void setParameter(String name, String value) {
        this.argNameToValueMap.put(name, value);
    }

    public void setArgs(String[] args) {
        this.isClosed = false;
        this.argNameToValueMap = new HashMap<String, String>();
        for (String arg : args) {
            int i = arg.indexOf(61);
            assert (i != -1);
            String key = arg.substring(0, i);
            String value = arg.substring(i + 1);
            this.argNameToValueMap.put(key, value);
        }
    }

    public JLayeredPane getLayeredPane() {
        if (this.layeredPane != null) {
            return this.layeredPane;
        }
        return super.getLayeredPane();
    }

    public final void init() {
        super.init();
        class InitializeThread
        extends ThreadWithRevealingToString {
            InitializeThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Program.this.preInitialize();
                Program.this.isInitializationSuccessful = false;
                try {
                    Program.this.initialize();
                    Program.this.isInitializationSuccessful = true;
                }
                finally {
                    Program.this.getContentPane().validate();
                    Program.this.postInitialize(Program.this.isInitializationSuccessful);
                    Program.this.semaphore.release();
                }
            }
        }
        new InitializeThread().start();
    }

    public final void start() {
        super.start();
        class RunThread
        extends ThreadWithRevealingToString {
            RunThread() {
            }

            public void run() {
                Program.this.semaphore.acquireUninterruptibly();
                if (Program.this.isInitializationSuccessful) {
                    Program.this.preRun();
                    ProgramClosedException.invokeAndCatchProgramClosedException(new Runnable(){

                        public void run() {
                            Program.this.run();
                        }
                    });
                    Program.this.postRun();
                } else {
                    System.err.println("WARNING: initialization not successful; run() method will not be invoked.");
                }
            }
        }
        new RunThread().start();
    }

    protected abstract void preInitialize();

    protected abstract void initialize();

    protected abstract void postInitialize(boolean var1);

    protected abstract void preRun();

    protected abstract void run();

    protected abstract void postRun();

    protected abstract boolean handleWindowClosing(WindowEvent var1);

    protected abstract void handleWindowClosed(WindowEvent var1);

    private static int toInt(String s, int valueIfNull) {
        if (s != null) {
            return Integer.parseInt(s);
        }
        return valueIfNull;
    }

    protected void showInWindow(final Window window, final boolean isExitDesiredOnClose) {
        int xLocation = Program.toInt(this.getParameter("X_LOCATION"), 0);
        int yLocation = Program.toInt(this.getParameter("Y_LOCATION"), 0);
        window.setLocation(xLocation, yLocation);
        window.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                if (Program.this.handleWindowClosing(e)) {
                    window.dispose();
                }
            }

            public void windowClosed(WindowEvent e) {
                Program.this.handleWindowClosed(e);
                if (isExitDesiredOnClose) {
                    System.exit(0);
                }
                Program.this.setClosed(true);
            }
        });
        window.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
                Program.this.setParameter("X_LOCATION", Integer.toString(e.getComponent().getX()));
                Program.this.setParameter("Y_LOCATION", Integer.toString(e.getComponent().getY()));
            }

            public void componentResized(ComponentEvent e) {
            }
        });
        window.setVisible(true);
    }

    public void showInJFrame(String[] args, boolean isExitDesiredOnClose) {
        boolean isFlickerOnResizeDesired;
        this.setArgs(args);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(0);
        int width = Program.toInt(this.getParameter("WIDTH"), 640);
        int height = Program.toInt(this.getParameter("HEIGHT"), 480);
        this.getContentPane().setPreferredSize(new Dimension(width, height));
        String title = this.getParameter("TITLE");
        if (title != null) {
            frame.setTitle(title);
        }
        if (isFlickerOnResizeDesired = true) {
            frame.getContentPane().add(this);
        } else {
            frame.getContentPane().add(this.getContentPane());
            this.layeredPane = frame.getLayeredPane();
        }
        this.init();
        frame.pack();
        frame.addComponentListener(new StartProgramComponentAdapter());
        this.showInWindow(frame, isExitDesiredOnClose);
        frame.validate();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Program.this.getContentPane().repaint();
            }
        });
    }

    public void showInJDialog(Component owner, boolean isModal, String[] args) {
        this.setArgs(args);
        String title = this.getParameter("TITLE");
        Component root = SwingUtilities.getRoot(owner);
        JDialog dialog = root instanceof Frame ? new JDialog((Frame)root) : (root instanceof Dialog ? new JDialog((Frame)root) : new JDialog());
        dialog.setTitle(title);
        dialog.setModal(isModal);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)this, "Center");
        int width = Program.toInt(this.getParameter("WIDTH"), 640);
        int height = Program.toInt(this.getParameter("HEIGHT"), 480);
        this.getContentPane().setPreferredSize(new Dimension(width, height));
        this.init();
        dialog.pack();
        if (root != null) {
            dialog.setLocationRelativeTo(root);
        }
        dialog.addComponentListener(new StartProgramComponentAdapter());
        this.showInWindow(dialog, false);
    }

    public void showInJWindow(String[] args) {
        this.setArgs(args);
        JWindow window = new JWindow();
        window.getContentPane().setLayout(new BorderLayout());
        window.getContentPane().add((Component)this, "Center");
        int width = Program.toInt(this.getParameter("WIDTH"), 640);
        int height = Program.toInt(this.getParameter("HEIGHT"), 480);
        this.getContentPane().setPreferredSize(new Dimension(width, height));
        this.init();
        window.pack();
        window.addComponentListener(new StartProgramComponentAdapter());
        this.showInWindow(window, false);
    }

    public void showInAWTContainer(Container awtContainer, String[] args) {
        this.setArgs(args);
        this.init();
        awtContainer.setLayout(new GridLayout(1, 1));
        awtContainer.add(this);
        if (awtContainer instanceof JComponent) {
            ((JComponent)awtContainer).revalidate();
        }
        awtContainer.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Container contentPane = Program.this.getContentPane();
                contentPane.repaint();
                Program.this.start();
            }
        });
    }

    public static void main(final String[] args) {
        String programClassname = System.getProperty("java.main");
        if (programClassname != null) {
            programClassname.replace('.', '/');
            try {
                Class<?> programClass = Class.forName(programClassname);
                final Program program = (Program)programClass.newInstance();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        program.showInJFrame(args, true);
                    }
                });
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(ie);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
        } else {
            String javaMainText = "-Djava.main=package.Class";
            ClipboardUtilities.setClipboardContents(javaMainText);
            PrintUtilities.println();
            PrintUtilities.println();
            PrintUtilities.println();
            PrintUtilities.println("UNABLE TO START PROGRAM");
            PrintUtilities.println("------ -- ----- -------");
            PrintUtilities.println("In order to run this program as an application, you need to set the system property java.main.  Please update your VM arguments.");
            PrintUtilities.println("The text below (NOTE: requires editing) has been copied to the clipboard for your convenience.");
            PrintUtilities.println(javaMainText);
            PrintUtilities.println();
            PrintUtilities.println();
            PrintUtilities.println();
        }
    }

    public class StartProgramComponentAdapter
    implements ComponentListener {
        private boolean isAlreadyStarted = false;

        public void componentShown(ComponentEvent e) {
            if (!this.isAlreadyStarted) {
                this.isAlreadyStarted = true;
                Program.this.start();
            }
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
        }
    }
}

