/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.progress;

import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jdesktop.swingworker.SwingWorker;

public abstract class ProgressDialog
extends JDialog {
    private JTextArea textArea = new JTextArea();
    private JProgressBar progressBar = new JProgressBar();
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            Object propertyValue = e.getNewValue();
            if ("progress".equals(propertyName)) {
                ProgressDialog.this.handleProgressChange((Integer)propertyValue);
            } else if ("state".equals(propertyName)) {
                ProgressDialog.this.handleStateChange((Worker)((Object)e.getSource()), (SwingWorker.StateValue)propertyValue);
            } else {
                System.out.println(propertyName + " " + propertyValue);
            }
        }
    };

    public ProgressDialog(JDialog owner) {
        super(owner);
    }

    public ProgressDialog(JFrame owner) {
        super(owner);
    }

    protected void addComponentsToPageAxisContentPane(Container contentPane) {
        JScrollPane scrollPane = new JScrollPane(this.textArea){

            public Dimension getPreferredSize() {
                return new Dimension(320, 240);
            }
        };
        contentPane.add(scrollPane);
        if (this.isProgressBarDesired()) {
            contentPane.add(this.progressBar);
        }
    }

    public void addNotify() {
        super.addNotify();
        Container contentPane = this.getContentPane();
        if (contentPane.getComponentCount() == 0) {
            contentPane.setLayout(new BoxLayout(contentPane, 3));
            this.addComponentsToPageAxisContentPane(contentPane);
        }
    }

    public void removeNotify() {
        super.removeNotify();
    }

    protected abstract Worker createWorker();

    protected abstract void handleDone(Boolean var1);

    protected abstract boolean isProgressBarDesired();

    public void createAndExecuteWorker() {
        Worker worker = this.createWorker();
        worker.addPropertyChangeListener(this.propertyChangeListener);
        worker.execute();
    }

    protected void handleProgressChange(Integer progress) {
        this.progressBar.setValue(progress);
    }

    protected void handleStateChange(Worker worker, SwingWorker.StateValue state) {
        if (SwingWorker.StateValue.DONE.equals((Object)state)) {
            try {
                worker.removePropertyChangeListener(this.propertyChangeListener);
                Boolean result = (Boolean)worker.get();
                if (result.booleanValue()) {
                    this.progressBar.setValue(100);
                }
                this.handleDone(result);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame();
                ProgressDialog dialog = new ProgressDialog(frame){

                    protected boolean isProgressBarDesired() {
                        return true;
                    }

                    protected void handleDone(Boolean result) {
                        if (result.booleanValue()) {
                            this.setVisible(false);
                        }
                    }

                    protected Worker createWorker() {
                        return new Worker(){

                            protected Boolean doInBackground() throws Exception {
                                int N = 10;
                                for (int i = 0; i < 10; ++i) {
                                    this.setPortionCompleted((double)i / 10.0);
                                    this.publish(new String[]{Integer.toString(i) + "\n"});
                                    Thread.sleep(100L);
                                }
                                this.publish(new String[]{"complete"});
                                return true;
                            }
                        };
                    }
                };
                dialog.createAndExecuteWorker();
                dialog.pack();
                dialog.setVisible(true);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class Worker
    extends SwingWorker<Boolean, String> {
        protected Worker() {
        }

        protected void setPortionCompleted(double portionCompleted) {
            this.setProgress((int)(100.0 * portionCompleted));
        }

        protected void process(List<String> texts) {
            super.process(texts);
            for (String text : texts) {
                ProgressDialog.this.textArea.append(text);
            }
        }
    }
}

