/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.property;

import edu.cmu.cs.dennisc.property.InstancePropertyOwner;
import edu.cmu.cs.dennisc.property.Property;
import edu.cmu.cs.dennisc.property.PropertyOwner;
import edu.cmu.cs.dennisc.property.event.PropertyEvent;
import edu.cmu.cs.dennisc.property.event.PropertyListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceProperty<E>
implements Property<E> {
    private InstancePropertyOwner m_owner;
    private String m_name;
    private transient E m_value;
    private List<PropertyListener> m_propertyListeners = null;

    public InstanceProperty(InstancePropertyOwner owner, E value) {
        this.m_owner = owner;
        this.m_value = value;
    }

    @Override
    public String getName() {
        if (this.m_name == null) {
            this.m_name = this.m_owner.lookupNameFor(this);
        }
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyListener(PropertyListener propertyListener) {
        if (this.m_propertyListeners == null) {
            this.m_propertyListeners = new LinkedList<PropertyListener>();
        }
        List<PropertyListener> list = this.m_propertyListeners;
        synchronized (list) {
            this.m_propertyListeners.add(propertyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyListener(PropertyListener propertyListener) {
        assert (this.m_propertyListeners != null);
        List<PropertyListener> list = this.m_propertyListeners;
        synchronized (list) {
            this.m_propertyListeners.remove(propertyListener);
        }
    }

    public Iterable<PropertyListener> accessPropertyListeners() {
        return this.m_propertyListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChanging(PropertyEvent e) {
        if (this.m_propertyListeners != null) {
            List<PropertyListener> list = this.m_propertyListeners;
            synchronized (list) {
                for (PropertyListener propertyListener : this.m_propertyListeners) {
                    propertyListener.propertyChanging(e);
                }
            }
        }
        this.getOwner().firePropertyChanging(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChanged(PropertyEvent e) {
        if (this.m_propertyListeners != null) {
            List<PropertyListener> list = this.m_propertyListeners;
            synchronized (list) {
                for (PropertyListener propertyListener : this.m_propertyListeners) {
                    propertyListener.propertyChanged(e);
                }
            }
        }
        this.getOwner().firePropertyChanged(e);
    }

    public PropertyOwner getOwner() {
        return this.m_owner;
    }

    @Override
    public E getValue(PropertyOwner owner) {
        assert (this.m_owner == owner) : this;
        return this.m_value;
    }

    @Override
    public void setValue(PropertyOwner owner, E value) {
        assert (this.m_owner == owner);
        PropertyEvent e = new PropertyEvent(this, owner, value);
        this.firePropertyChanging(e);
        this.m_value = value;
        this.firePropertyChanged(e);
    }

    public final E getValue() {
        return this.getValue(this.m_owner);
    }

    public final void setValue(E value) {
        this.setValue(this.m_owner, value);
    }

    protected void writeValue(ObjectOutputStream oos) throws IOException {
        assert (this.m_value == null || this.m_value instanceof Serializable);
        oos.writeObject(this.m_value);
    }

    protected void readValue(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.m_value = ois.readObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        this.writeValue(oos);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.readValue(ois);
    }

    public String toString() {
        return this.getClass().getName() + "[owner=" + this.getOwner() + ";name=" + this.getName() + "]";
    }
}

