/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph;

import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Sphere;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.Shape;

public class Box
extends Shape {
    public final Geometry.BoundDoubleProperty xMinimum = new Geometry.BoundDoubleProperty(this, this, -0.5);
    public final Geometry.BoundDoubleProperty xMaximum = new Geometry.BoundDoubleProperty(this, this, 0.5);
    public final Geometry.BoundDoubleProperty yMinimum = new Geometry.BoundDoubleProperty(this, this, -0.5);
    public final Geometry.BoundDoubleProperty yMaximum = new Geometry.BoundDoubleProperty(this, this, 0.5);
    public final Geometry.BoundDoubleProperty zMinimum = new Geometry.BoundDoubleProperty(this, this, -0.5);
    public final Geometry.BoundDoubleProperty zMaximum = new Geometry.BoundDoubleProperty(this, this, 0.5);

    public Point3 getMinimum(Point3 rv) {
        rv.set((Double)this.xMinimum.getValue(), (Double)this.yMinimum.getValue(), (Double)this.zMinimum.getValue());
        return rv;
    }

    public Point3 getMinimum() {
        return this.getMinimum(new Point3());
    }

    public void setMinimum(double x, double y, double z) {
        this.xMinimum.setValue(x);
        this.yMinimum.setValue(y);
        this.zMinimum.setValue(z);
    }

    public void setMinimum(Point3 minimum) {
        this.setMinimum(minimum.x, minimum.y, minimum.z);
    }

    public Point3 getMaximum(Point3 rv) {
        rv.set((Double)this.xMaximum.getValue(), (Double)this.yMaximum.getValue(), (Double)this.zMaximum.getValue());
        return rv;
    }

    public Point3 getMaximum() {
        return this.getMaximum(new Point3());
    }

    public void setMaximum(double x, double y, double z) {
        this.xMaximum.setValue(x);
        this.yMaximum.setValue(y);
        this.zMaximum.setValue(z);
    }

    public void setMaximum(Point3 maximum) {
        this.setMaximum(maximum.x, maximum.y, maximum.z);
    }

    public void set(Point3 minimum, Point3 maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
    }

    public void set(AxisAlignedBox box) {
        this.setMinimum(box.getXMinimum(), box.getYMinimum(), box.getZMinimum());
        this.setMaximum(box.getXMaximum(), box.getYMaximum(), box.getZMaximum());
    }

    protected void updateBoundingBox(AxisAlignedBox boundingBox) {
        boundingBox.setMinimum((Double)this.xMinimum.getValue(), (Double)this.yMinimum.getValue(), (Double)this.zMinimum.getValue());
        boundingBox.setMaximum((Double)this.xMaximum.getValue(), (Double)this.yMaximum.getValue(), (Double)this.zMaximum.getValue());
    }

    protected void updateBoundingSphere(Sphere boundingSphere) {
        double xCenter = ((Double)this.xMinimum.getValue() + (Double)this.xMaximum.getValue()) * 0.5;
        double yCenter = ((Double)this.yMinimum.getValue() + (Double)this.yMaximum.getValue()) * 0.5;
        double zCenter = ((Double)this.zMinimum.getValue() + (Double)this.zMaximum.getValue()) * 0.5;
        boundingSphere.center.set(xCenter, yCenter, zCenter);
        double width = (Double)this.xMaximum.getValue() - (Double)this.xMinimum.getValue();
        double height = (Double)this.yMaximum.getValue() - (Double)this.yMinimum.getValue();
        double depth = (Double)this.zMaximum.getValue() - (Double)this.zMinimum.getValue();
        boundingSphere.radius = Math.max(Math.max(width, height), depth) * 0.5;
    }
}

