/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph;

import edu.cmu.cs.dennisc.lookingglass.LookingGlass;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.EulerAngles;
import edu.cmu.cs.dennisc.math.OrthogonalMatrix3x3;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.UnitQuaternion;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.Vector4;
import edu.cmu.cs.dennisc.pattern.Visitable;
import edu.cmu.cs.dennisc.pattern.Visitor;
import edu.cmu.cs.dennisc.scenegraph.AbstractCamera;
import edu.cmu.cs.dennisc.scenegraph.Composite;
import edu.cmu.cs.dennisc.scenegraph.Element;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;
import edu.cmu.cs.dennisc.scenegraph.event.AbsoluteTransformationEvent;
import edu.cmu.cs.dennisc.scenegraph.event.AbsoluteTransformationListener;
import edu.cmu.cs.dennisc.scenegraph.event.HierarchyEvent;
import edu.cmu.cs.dennisc.scenegraph.event.HierarchyListener;
import edu.cmu.cs.dennisc.scenegraph.util.TransformationUtilities;
import java.awt.Point;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Component
extends Element
implements Visitable,
ReferenceFrame {
    private Composite m_vehicle = null;
    private Vector<AbsoluteTransformationListener> m_absoluteTransformationListeners = new Vector();
    private Vector<HierarchyListener> m_hierarchyListeners = new Vector();
    private static AffineMatrix4x4 s_bufferMatrixForReuse = AffineMatrix4x4.createNaN();
    private static final Vector4 s_buffer = new Vector4();

    @Override
    public boolean isLocalOf(Component other) {
        return this == other;
    }

    @Override
    public boolean isVehicleOf(Component other) {
        return this == other.getParent();
    }

    @Override
    public boolean isSceneOf(Component other) {
        return this == other.getRoot();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public Composite getRoot() {
        if (this.m_vehicle != null) {
            return this.m_vehicle.getRoot();
        }
        return null;
    }

    @Override
    public AffineMatrix4x4 getAbsoluteTransformation(AffineMatrix4x4 rv) {
        if (this.m_vehicle != null) {
            rv = this.m_vehicle.getAbsoluteTransformation(rv);
        } else {
            rv.setIdentity();
        }
        return rv;
    }

    @Override
    public final AffineMatrix4x4 getAbsoluteTransformation() {
        return this.getAbsoluteTransformation(AffineMatrix4x4.createNaN());
    }

    @Override
    public AffineMatrix4x4 getInverseAbsoluteTransformation(AffineMatrix4x4 rv) {
        if (this.m_vehicle != null) {
            rv = this.m_vehicle.getInverseAbsoluteTransformation(rv);
        } else {
            rv.setIdentity();
        }
        return rv;
    }

    @Override
    public final AffineMatrix4x4 getInverseAbsoluteTransformation() {
        return this.getInverseAbsoluteTransformation(AffineMatrix4x4.createNaN());
    }

    @Override
    public AffineMatrix4x4 getTransformation(AffineMatrix4x4 rv, ReferenceFrame asSeenBy) {
        if (this.m_vehicle != null) {
            return this.m_vehicle.getTransformation(rv, asSeenBy);
        }
        return asSeenBy.getInverseAbsoluteTransformation(rv);
    }

    @Override
    public final AffineMatrix4x4 getTransformation(ReferenceFrame asSeenBy) {
        return this.getTransformation(AffineMatrix4x4.createNaN(), asSeenBy);
    }

    public Point3 getTranslation(Point3 rv, ReferenceFrame asSeenBy) {
        rv.set(this.getTransformation((ReferenceFrame)asSeenBy).translation);
        return rv;
    }

    public final Point3 getTranslation(ReferenceFrame asSeenBy) {
        return this.getTranslation(new Point3(), asSeenBy);
    }

    public OrthogonalMatrix3x3 getAxes(OrthogonalMatrix3x3 rv, ReferenceFrame asSeenBy) {
        rv.setValue(this.getTransformation((ReferenceFrame)asSeenBy).orientation);
        return rv;
    }

    public final OrthogonalMatrix3x3 getAxes(ReferenceFrame asSeenBy) {
        return this.getAxes(OrthogonalMatrix3x3.createNaN(), asSeenBy);
    }

    public UnitQuaternion getUnitQuaternionD(UnitQuaternion rv, ReferenceFrame asSeenBy) {
        rv.setValue(this.getTransformation((ReferenceFrame)asSeenBy).orientation);
        return rv;
    }

    public final UnitQuaternion getUnitQuaternionD(ReferenceFrame asSeenBy) {
        return this.getUnitQuaternionD(UnitQuaternion.createNaN(), asSeenBy);
    }

    public EulerAngles getEulerAnglesD(EulerAngles rv, ReferenceFrame asSeenBy) {
        rv.setValue(this.getTransformation((ReferenceFrame)asSeenBy).orientation);
        return rv;
    }

    public final EulerAngles getEulerAnglesD(ReferenceFrame asSeenBy) {
        return this.getEulerAnglesD(EulerAngles.createNaN(), asSeenBy);
    }

    public Composite getParent() {
        return this.m_vehicle;
    }

    public void setParent(Composite parent) {
        if (this.m_vehicle != parent) {
            if (this.m_vehicle != null) {
                this.m_vehicle.fireChildRemoved(this);
            }
            this.m_vehicle = parent;
            if (this.m_vehicle != null) {
                this.m_vehicle.fireChildAdded(this);
            }
            this.fireAbsoluteTransformationChange();
            this.fireHierarchyChanged();
        }
    }

    public boolean isDescendantOf(Composite possibleAncestor) {
        if (possibleAncestor == null) {
            return false;
        }
        if (this.m_vehicle == possibleAncestor) {
            return true;
        }
        if (this.m_vehicle == null) {
            return false;
        }
        return this.m_vehicle.isDescendantOf(possibleAncestor);
    }

    public void addAbsoluteTransformationListener(AbsoluteTransformationListener absoluteTransformationListener) {
        this.m_absoluteTransformationListeners.addElement(absoluteTransformationListener);
    }

    public void removeAbsoluteTransformationListener(AbsoluteTransformationListener absoluteTransformationListener) {
        this.m_absoluteTransformationListeners.removeElement(absoluteTransformationListener);
    }

    public Iterable<AbsoluteTransformationListener> accessAbsoluteTransformationListeners() {
        return this.m_absoluteTransformationListeners;
    }

    private void fireAbsoluteTransformationChange(AbsoluteTransformationEvent absoluteTransformationEvent) {
        for (AbsoluteTransformationListener atl : this.m_absoluteTransformationListeners) {
            atl.absoluteTransformationChanged(absoluteTransformationEvent);
        }
    }

    protected void fireAbsoluteTransformationChange() {
        this.fireAbsoluteTransformationChange(new AbsoluteTransformationEvent(this));
    }

    public void addHierarchyListener(HierarchyListener hierarchyListener) {
        this.m_hierarchyListeners.addElement(hierarchyListener);
    }

    public void removeHierarchyListener(HierarchyListener hierarchyListener) {
        this.m_hierarchyListeners.removeElement(hierarchyListener);
    }

    public Iterable<HierarchyListener> accessHierarchyListeners() {
        return this.m_hierarchyListeners;
    }

    private void fireHierarchyChanged(HierarchyEvent hierarchyEvent) {
        for (HierarchyListener hl : this.m_hierarchyListeners) {
            hl.hierarchyChanged(hierarchyEvent);
        }
    }

    protected void fireHierarchyChanged() {
        this.fireHierarchyChanged(new HierarchyEvent(this));
    }

    public Vector4 transformTo(Vector4 rv, Vector4 xyzw, Component to) {
        return TransformationUtilities.transformTo(rv, xyzw, this, to);
    }

    public Vector4 transformFrom(Vector4 rv, Vector4 xyzw, Component from) {
        return from.transformTo(rv, xyzw, this);
    }

    public Point3 transformTo(Point3 rv, Point3 xyz, Component to) {
        return TransformationUtilities.transformTo(rv, xyz, this, to);
    }

    public Point3 transformFrom(Point3 rv, Point3 xyz, Component from) {
        return from.transformTo(rv, xyz, this);
    }

    public Vector3 transformTo(Vector3 rv, Vector3 xyz, Component to) {
        return TransformationUtilities.transformTo(rv, xyz, this, to);
    }

    public Vector3 transformFrom(Vector3 rv, Vector3 xyz, Component from) {
        return from.transformTo(rv, xyz, this);
    }

    public Vector4 transformTo_New(Vector4 xyzw, Component to) {
        return TransformationUtilities.transformTo_New(xyzw, this, to);
    }

    public Vector4 transformFrom_New(Vector4 xyzw, Component from) {
        return from.transformTo_New(xyzw, this);
    }

    public Point3 transformTo_New(Point3 xyz, Component to) {
        return TransformationUtilities.transformTo_New(xyz, this, to);
    }

    public Point3 transformFrom_New(Point3 xyz, Component from) {
        return from.transformTo_New(xyz, this);
    }

    public Vector3 transformTo_New(Vector3 xyz, Component to) {
        return TransformationUtilities.transformTo_New(xyz, this, to);
    }

    public Vector3 transformFrom_New(Vector3 xyz, Component from) {
        return from.transformTo_New(xyz, this);
    }

    public Vector4 transformTo_AffectReturnValuePassedIn(Vector4 xyzw, Component to) {
        return TransformationUtilities.transformTo_AffectReturnValuePassedIn(xyzw, this, to);
    }

    public Vector4 transformFrom_AffectReturnValuePassedIn(Vector4 xyzw, Component from) {
        return from.transformTo_AffectReturnValuePassedIn(xyzw, this);
    }

    public Point3 transformTo_AffectReturnValuePassedIn(Point3 xyz, Component to) {
        return TransformationUtilities.transformTo_AffectReturnValuePassedIn(xyz, this, to);
    }

    public Point3 transformFrom_AffectReturnValuePassedIn(Point3 xyz, Component from) {
        return from.transformTo_AffectReturnValuePassedIn(xyz, this);
    }

    public Vector3 transformTo_AffectReturnValuePassedIn(Vector3 xyz, Component to) {
        return TransformationUtilities.transformTo_AffectReturnValuePassedIn(xyz, this, to);
    }

    public Vector3 transformFrom_AffectReturnValuePassedIn(Vector3 xyz, Component from) {
        return from.transformTo_AffectReturnValuePassedIn(xyz, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point transformToAWT(Point rv, Vector4 xyzw, LookingGlass lookingGlass, AbstractCamera camera) {
        Vector4 vector4 = s_buffer;
        synchronized (vector4) {
            if (this != camera) {
                this.transformTo(s_buffer, xyzw, (Component)camera);
            } else {
                s_buffer.set(xyzw);
            }
            edu.cmu.cs.dennisc.lookingglass.util.TransformationUtilities.transformFromCameraToAWT(rv, s_buffer, lookingGlass, camera);
        }
        return rv;
    }

    public Vector4 transformFromAWT(Vector4 rv, Point p, double z, LookingGlass lookingGlass, AbstractCamera camera) {
        edu.cmu.cs.dennisc.lookingglass.util.TransformationUtilities.transformFromAWTToCamera(rv, p, z, lookingGlass, camera);
        if (this != camera) {
            this.transformFrom_AffectReturnValuePassedIn(rv, (Component)camera);
        }
        return rv;
    }

    public Point transformToAWT_New(Vector4 xyzw, LookingGlass lookingGlass, AbstractCamera camera) {
        return this.transformToAWT(new Point(), xyzw, lookingGlass, camera);
    }

    public Point transformToAWT_New(Point3 xyz, LookingGlass lookingGlass, AbstractCamera camera) {
        return this.transformToAWT_New(new Vector4(xyz.x, xyz.y, xyz.z, 1.0), lookingGlass, camera);
    }

    public Vector4 transformFromAWT_NewVectorD4(Point p, double z, LookingGlass lookingGlass, AbstractCamera camera) {
        return this.transformFromAWT(new Vector4(), p, z, lookingGlass, camera);
    }

    public Point3 transformFromAWT_NewPointD3(Point p, double z, LookingGlass lookingGlass, AbstractCamera camera) {
        return Point3.createFromXYZW(this.transformFromAWT_NewVectorD4(p, z, lookingGlass, camera));
    }
}

