/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph;

import edu.cmu.cs.dennisc.scenegraph.Element;
import edu.cmu.cs.dennisc.scenegraph.Graphic;
import edu.cmu.cs.dennisc.scenegraph.event.GraphicAddedEvent;
import edu.cmu.cs.dennisc.scenegraph.event.GraphicRemovedEvent;
import edu.cmu.cs.dennisc.scenegraph.event.GraphicsListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layer
extends Element {
    private List<Graphic> graphics = Collections.synchronizedList(new LinkedList());
    private List<GraphicsListener> graphicsListeners = Collections.synchronizedList(new LinkedList());

    public void addGraphic(Graphic graphic) {
        graphic.setParent(this);
    }

    public void removeGraphic(Graphic graphic) {
        if (graphic.getParent() != this) {
            throw new RuntimeException();
        }
        graphic.setParent(null);
    }

    public Iterable<Graphic> getGraphics() {
        return this.graphics;
    }

    public void addGraphicsListener(GraphicsListener l) {
        this.graphicsListeners.add(l);
    }

    public void removeGraphicsListener(GraphicsListener l) {
        this.graphicsListeners.remove(l);
    }

    void addGraphicAndFireListeners(Graphic graphic) {
        this.graphics.add(graphic);
        GraphicAddedEvent e = new GraphicAddedEvent(this, graphic);
        for (GraphicsListener l : this.graphicsListeners) {
            l.graphicAdded(e);
        }
    }

    void removeGraphicAndFireListeners(Graphic graphic) {
        this.graphics.remove(graphic);
        GraphicRemovedEvent e = new GraphicRemovedEvent(this, graphic);
        for (GraphicsListener l : this.graphicsListeners) {
            l.graphicRemoved(e);
        }
    }
}

