/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph;

import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Sphere;
import edu.cmu.cs.dennisc.property.InstanceProperty;
import edu.cmu.cs.dennisc.property.InstancePropertyOwner;
import edu.cmu.cs.dennisc.property.PropertyOwner;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.Shape;

public class Torus
extends Shape {
    public final InstanceProperty<CoordinatePlane> coordinatePlane = new InstanceProperty<CoordinatePlane>((InstancePropertyOwner)this, CoordinatePlane.XZ){

        @Override
        public void setValue(PropertyOwner owner, CoordinatePlane value) {
            super.setValue(owner, value);
            Torus.this.fireBoundChange();
        }
    };
    public final Geometry.BoundDoubleProperty minorRadius = new Geometry.BoundDoubleProperty((InstancePropertyOwner)this, (Double)0.1){

        public void setValue(PropertyOwner owner, Double value) {
            assert (value >= 0.0) : value;
            super.setValue(owner, value);
        }
    };
    public final Geometry.BoundDoubleProperty majorRadius = new Geometry.BoundDoubleProperty((InstancePropertyOwner)this, (Double)0.9){

        public void setValue(PropertyOwner owner, Double value) {
            assert (value >= 0.0) : value;
            super.setValue(owner, value);
        }
    };

    protected void updateBoundingBox(AxisAlignedBox boundingBox) {
        double yesRadius = (Double)this.majorRadius.getValue() + (Double)this.minorRadius.getValue();
        double noRadius = (Double)this.minorRadius.getValue();
        this.coordinatePlane.getValue().updateBoundingBox(boundingBox, yesRadius, noRadius);
    }

    protected void updateBoundingSphere(Sphere boundingSphere) {
        double outerRadius = (Double)this.majorRadius.getValue() + (Double)this.minorRadius.getValue();
        boundingSphere.center.set(0.0, 0.0, 0.0);
        boundingSphere.radius = outerRadius;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoordinatePlane {
        XY(true, true, false),
        XZ(true, false, true),
        YZ(false, true, true);

        private boolean isX;
        private boolean isY;
        private boolean isZ;

        private CoordinatePlane(boolean isX, boolean isY, boolean isZ) {
            this.isX = isX;
            this.isY = isY;
            this.isZ = isZ;
        }

        public void updateBoundingBox(AxisAlignedBox boundingBox, double yesRadius, double noRadius) {
            double x = this.isX ? yesRadius : noRadius;
            double y = this.isY ? yesRadius : noRadius;
            double z = this.isZ ? yesRadius : noRadius;
            boundingBox.setMinimum(-x, -y, -z);
            boundingBox.setMaximum(x, y, z);
        }
    }
}

