/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TransformationAffect {
    AFFECT_TRANSLATION_X_ONLY(false, true, false, false),
    AFFECT_TRANSLATION_Y_ONLY(false, false, true, false),
    AFFECT_TRANSLATION_Z_ONLY(false, false, false, true),
    AFFECT_TRANSLATION_XY_ONLY(false, true, true, false),
    AFFECT_TRANSLATION_XZ_ONLY(false, true, false, true),
    AFFECT_TRANSLATION_YZ_ONLY(false, false, true, true),
    AFFECT_TRANSLATION_ONLY(false, true, true, true),
    AFFECT_ORIENTAION_ONLY(true, false, false, false),
    AFFECT_ALL(true, true, true, true);

    private boolean m_isAffectOrientationDesired;
    private boolean m_isAffectTranslationXDesired;
    private boolean m_isAffectTranslationYDesired;
    private boolean m_isAffectTranslationZDesired;

    private TransformationAffect(boolean isAffectOrientationDesired, boolean isAffectTranslationXDesired, boolean isAffectTranslationYDesired, boolean isAffectTranslationZDesired) {
        this.m_isAffectOrientationDesired = isAffectOrientationDesired;
        this.m_isAffectTranslationXDesired = isAffectTranslationXDesired;
        this.m_isAffectTranslationYDesired = isAffectTranslationYDesired;
        this.m_isAffectTranslationZDesired = isAffectTranslationZDesired;
    }

    public void set(AffineMatrix4x4 dst, AffineMatrix4x4 src) {
        if (this.m_isAffectOrientationDesired) {
            dst.orientation.setValue(src.orientation);
        }
        if (this.m_isAffectTranslationXDesired) {
            dst.translation.x = src.translation.x;
        }
        if (this.m_isAffectTranslationYDesired) {
            dst.translation.y = src.translation.y;
        }
        if (this.m_isAffectTranslationZDesired) {
            dst.translation.z = src.translation.z;
        }
    }

    public static TransformationAffect getTranslationAffect(double x, double y, double z) {
        if (Double.isNaN(x)) {
            if (Double.isNaN(y)) {
                if (Double.isNaN(z)) {
                    return null;
                }
                return AFFECT_TRANSLATION_Z_ONLY;
            }
            if (Double.isNaN(z)) {
                return AFFECT_TRANSLATION_Y_ONLY;
            }
            return AFFECT_TRANSLATION_YZ_ONLY;
        }
        if (Double.isNaN(y)) {
            if (Double.isNaN(z)) {
                return AFFECT_TRANSLATION_X_ONLY;
            }
            return AFFECT_TRANSLATION_XZ_ONLY;
        }
        if (Double.isNaN(z)) {
            return AFFECT_TRANSLATION_XY_ONLY;
        }
        return AFFECT_TRANSLATION_ONLY;
    }
}

