/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph;

import edu.cmu.cs.dennisc.codec.BinaryDecoder;
import edu.cmu.cs.dennisc.codec.BinaryEncodableAndDecodable;
import edu.cmu.cs.dennisc.codec.BinaryEncoder;
import edu.cmu.cs.dennisc.color.Color4f;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Vector3f;
import edu.cmu.cs.dennisc.texture.TextureCoordinate2f;

public class Vertex
implements BinaryEncodableAndDecodable {
    public static final int FORMAT_POSITION = 1;
    public static final int FORMAT_NORMAL = 2;
    public static final int FORMAT_DIFFUSE_COLOR = 4;
    public static final int FORMAT_SPECULAR_HIGHLIGHT_COLOR = 8;
    public static final int FORMAT_TEXTURE_COORDINATE_0 = 16;
    public final Point3 position = Point3.createNaN();
    public final Vector3f normal = Vector3f.createNaN();
    public final Color4f diffuseColor = Color4f.createNaN();
    public final Color4f specularHighlightColor = Color4f.createNaN();
    public final TextureCoordinate2f textureCoordinate0 = TextureCoordinate2f.createNaN();

    public Vertex() {
    }

    public Vertex(Point3 position, Vector3f normal, Color4f diffuseColor, Color4f specularHighlightColor, TextureCoordinate2f textureCoordinate0) {
        this.position.set(position);
        this.normal.set(normal);
        this.diffuseColor.set(diffuseColor);
        this.specularHighlightColor.set(specularHighlightColor);
        this.textureCoordinate0.set(textureCoordinate0);
    }

    public Vertex(Vertex other) {
        this(other.position, other.normal, other.diffuseColor, other.specularHighlightColor, other.textureCoordinate0);
    }

    public void decode(BinaryDecoder binaryDecoder) {
        this.position.decode(binaryDecoder);
        this.normal.decode(binaryDecoder);
        this.diffuseColor.decode(binaryDecoder);
        this.specularHighlightColor.decode(binaryDecoder);
        this.textureCoordinate0.decode(binaryDecoder);
    }

    public void encode(BinaryEncoder binaryEncoder) {
        this.position.encode(binaryEncoder);
        this.normal.encode(binaryEncoder);
        this.diffuseColor.encode(binaryEncoder);
        this.specularHighlightColor.encode(binaryEncoder);
        this.textureCoordinate0.encode(binaryEncoder);
    }

    public static Vertex createXYZ(double x, double y, double z) {
        Vertex vertex = new Vertex();
        vertex.position.set(x, y, z);
        return vertex;
    }

    public static Vertex createXYZUV(double x, double y, double z, float u, float v) {
        Vertex vertex = new Vertex();
        vertex.position.set(x, y, z);
        vertex.textureCoordinate0.set(u, v);
        return vertex;
    }

    public static Vertex createXYZIJKUV(double x, double y, double z, float i, float j, float k, float u, float v) {
        Vertex vertex = new Vertex();
        vertex.position.set(x, y, z);
        vertex.normal.set(i, j, k);
        vertex.textureCoordinate0.set(u, v);
        return vertex;
    }

    public static Vertex createXYZIJK(double x, double y, double z, float i, float j, float k) {
        Vertex vertex = new Vertex();
        vertex.position.set(x, y, z);
        vertex.normal.set(i, j, k);
        return vertex;
    }

    public static Vertex createXYZRGBA(double x, double y, double z, float r, float g, float b, float a) {
        Vertex vertex = new Vertex();
        vertex.position.set(x, y, z);
        vertex.diffuseColor.set(r, g, b, a);
        return vertex;
    }

    public static Vertex createXYZRGB(double x, double y, double z, float r, float g, float b) {
        return Vertex.createXYZRGBA(x, y, z, r, g, b, 1.0f);
    }

    public boolean equals(Object o) {
        if (o instanceof Vertex) {
            Vertex v = (Vertex)o;
            if (v.position == null ? this.position != null : !v.position.equals(this.position)) {
                return false;
            }
            if (v.normal == null ? this.normal != null : !v.normal.equals(this.normal)) {
                return false;
            }
            if (v.diffuseColor == null ? this.diffuseColor != null : !v.diffuseColor.equals(this.diffuseColor)) {
                return false;
            }
            if (v.specularHighlightColor == null ? this.specularHighlightColor != null : !v.specularHighlightColor.equals(this.specularHighlightColor)) {
                return false;
            }
            return !(v.textureCoordinate0 == null ? this.textureCoordinate0 != null : !v.textureCoordinate0.equals(this.textureCoordinate0));
        }
        return false;
    }

    @Deprecated
    public int getFormat() {
        int format = 0;
        if (!this.position.isNaN()) {
            format |= 1;
        }
        if (!this.normal.isNaN()) {
            format |= 2;
        }
        if (!this.diffuseColor.isNaN()) {
            format |= 4;
        }
        if (!this.specularHighlightColor.isNaN()) {
            format |= 8;
        }
        if (!this.textureCoordinate0.isNaN()) {
            format |= 0x10;
        }
        return format;
    }

    public void transform(AffineMatrix4x4 m) {
        if (!this.position.isNaN()) {
            m.transform(this.position);
        }
        if (!this.normal.isNaN()) {
            m.transform(this.normal);
        }
    }

    public void set(Vertex other) {
    }

    public String toString() {
        return Vertex.class.getName() + "[position=" + this.position + ",normal=" + this.normal + ",diffuseColor=" + this.diffuseColor + ",specularHighlightColor=" + this.specularHighlightColor + ",textureCoordinate0=" + this.textureCoordinate0 + "]";
    }
}

