/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph;

import edu.cmu.cs.dennisc.math.AbstractMatrix4x4;
import edu.cmu.cs.dennisc.math.AxisAlignedBox;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Sphere;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.Vector3f;
import edu.cmu.cs.dennisc.property.CopyableArrayProperty;
import edu.cmu.cs.dennisc.property.InstancePropertyOwner;
import edu.cmu.cs.dennisc.property.PropertyOwner;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.Vertex;
import edu.cmu.cs.dennisc.scenegraph.bound.BoundUtilities;

public abstract class VertexGeometry
extends Geometry {
    public final VerticesProperty vertices = new VerticesProperty(this, new Vertex[0]);

    protected void updateBoundingBox(AxisAlignedBox boundingBox) {
        BoundUtilities.getBoundingBox(boundingBox, (Vertex[])this.vertices.getValue());
    }

    protected void updateBoundingSphere(Sphere boundingSphere) {
        BoundUtilities.getBoundingSphere(boundingSphere, (Vertex[])this.vertices.getValue());
    }

    protected void updatePlane(Vector3 forward, Vector3 upGuide, Point3 translation) {
        Vertex[] vertices = (Vertex[])this.vertices.getValue();
        assert (vertices.length >= 2);
        Point3 point0 = vertices[0].position;
        Point3 point1 = vertices[1].position;
        Vector3f normal = vertices[0].normal;
        forward.set(normal.x, normal.y, normal.z);
        forward.normalize();
        forward.negate();
        upGuide.set(point0);
        upGuide.subtract(point1);
        upGuide.normalize();
        translation.set(point0);
    }

    public void transform(AbstractMatrix4x4 trans) {
        throw new RuntimeException("todo");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VerticesProperty
    extends CopyableArrayProperty<Vertex> {
        public VerticesProperty(InstancePropertyOwner owner, Vertex ... vertices) {
            super(owner, (E[])vertices);
        }

        protected Vertex[] createArray(int length) {
            return new Vertex[length];
        }

        @Override
        protected Vertex createCopy(Vertex src) {
            return new Vertex(src);
        }

        @Deprecated
        public void touch() {
            PropertyOwner owner = this.getOwner();
            this.setValue(owner, (Object[])this.getValue(owner));
        }
    }
}

