/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.io;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Vector3f;
import edu.cmu.cs.dennisc.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.dennisc.scenegraph.Vertex;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Vector;

public class OBJ {
    private static double getNextNumber(StreamTokenizer streamTokenizer) {
        try {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -2) {
                double f = streamTokenizer.nval;
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.startsWith("E")) {
                    int exponent = Integer.parseInt(streamTokenizer.sval.substring(1));
                    return f * Math.pow(10.0, exponent);
                }
                streamTokenizer.pushBack();
                return f;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return Double.NaN;
    }

    public static IndexedTriangleArray decode(InputStream is) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        StreamTokenizer st = new StreamTokenizer(r);
        st.commentChar(35);
        st.slashSlashComments(false);
        st.slashStarComments(false);
        st.whitespaceChars(47, 47);
        st.parseNumbers();
        Vector<double[]> xyzs = new Vector<double[]>();
        Vector<double[]> ijks = new Vector<double[]>();
        Vector<double[]> uvs = new Vector<double[]>();
        Vector fs = new Vector();
        while (st.nextToken() == -3) {
            if (st.sval.startsWith("vt")) {
                double[] uv = new double[3];
                uv[0] = OBJ.getNextNumber(st);
                uv[1] = OBJ.getNextNumber(st);
                uvs.addElement(uv);
                continue;
            }
            if (st.sval.startsWith("vn")) {
                double[] ijk = new double[]{OBJ.getNextNumber(st), OBJ.getNextNumber(st), OBJ.getNextNumber(st)};
                ijks.addElement(ijk);
                continue;
            }
            if (st.sval.startsWith("v")) {
                double[] xyz = new double[]{OBJ.getNextNumber(st), OBJ.getNextNumber(st), OBJ.getNextNumber(st)};
                xyzs.addElement(xyz);
                continue;
            }
            if (!st.sval.startsWith("f")) break;
            Vector<Integer> f = new Vector<Integer>();
            while (st.nextToken() == -2) {
                int index = (int)st.nval;
                index = index < 0 ? (index += xyzs.size()) : --index;
                f.addElement(index);
            }
            st.pushBack();
            fs.addElement(f);
        }
        int nVertexCount = xyzs.size();
        Vertex[] vertices = new Vertex[nVertexCount];
        double[] ijkDefault = new double[]{0.0, 1.0, 0.0};
        double[] uvDefault = new double[]{0.0, 0.0};
        for (int v = 0; v < nVertexCount; ++v) {
            double[] uv;
            double[] ijk;
            double[] xyz = (double[])xyzs.elementAt(v);
            try {
                ijk = (double[])ijks.elementAt(v);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ijk = ijkDefault;
            }
            try {
                uv = (double[])uvs.elementAt(v);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                uv = uvDefault;
            }
            vertices[v] = Vertex.createXYZIJKUV(xyz[0], xyz[1], xyz[2], (float)ijk[0], (float)ijk[1], (float)ijk[2], (float)uv[0], (float)uv[1]);
        }
        int[] indices = new int[fs.size() * 3];
        int i = 0;
        block12: for (int f = 0; f < fs.size(); ++f) {
            Vector face = (Vector)fs.elementAt(f);
            switch (face.size()) {
                case 3: {
                    indices[i++] = (Integer)face.elementAt(0);
                    indices[i++] = (Integer)face.elementAt(1);
                    indices[i++] = (Integer)face.elementAt(2);
                    continue block12;
                }
                case 6: {
                    indices[i++] = (Integer)face.elementAt(0);
                    indices[i++] = (Integer)face.elementAt(2);
                    indices[i++] = (Integer)face.elementAt(4);
                    continue block12;
                }
                case 9: {
                    indices[i++] = (Integer)face.elementAt(0);
                    indices[i++] = (Integer)face.elementAt(3);
                    indices[i++] = (Integer)face.elementAt(6);
                    continue block12;
                }
                default: {
                    throw new RuntimeException("unhandled face index size");
                }
            }
        }
        IndexedTriangleArray ita = new IndexedTriangleArray();
        ita.vertices.setValue(vertices);
        ita.polygonData.setValue(indices);
        for (int index : indices) {
            assert (index >= 0);
            assert (index < vertices.length);
        }
        return ita;
    }

    public static void encode(OutputStream os, IndexedTriangleArray ita, AffineMatrix4x4 m, String groupName) {
        Vertex[] vertices = (Vertex[])ita.vertices.getValue();
        int[] indices = (int[])ita.polygonData.getValue();
        if (vertices != null && indices != null) {
            BufferedOutputStream bos = new BufferedOutputStream(os);
            PrintWriter pw = new PrintWriter(bos);
            if (groupName != null) {
                pw.println("g " + groupName);
            }
            Point3 p = new Point3();
            Vector3f n = new Vector3f();
            for (int lcv = 0; lcv < vertices.length; ++lcv) {
                p.set(vertices[lcv].position);
                n.set(vertices[lcv].normal);
                double u = vertices[lcv].textureCoordinate0.u;
                double v = vertices[lcv].textureCoordinate0.v;
                if (m != null) {
                    m.transform(p);
                    m.transform(n);
                }
                pw.print("v ");
                pw.print(p.x);
                pw.print(" ");
                pw.print(p.y);
                pw.print(" ");
                pw.print(p.z);
                pw.println();
                pw.print("vt ");
                pw.print(u);
                pw.print(" ");
                pw.print(v);
                pw.println();
                pw.print("vn ");
                pw.print(n.x);
                pw.print(" ");
                pw.print(n.y);
                pw.print(" ");
                pw.print(n.z);
                pw.println();
            }
            for (int i = 0; i < indices.length; i += 3) {
                pw.print("f ");
                for (int j = 0; j < 3; ++j) {
                    int a = indices[i + j] - vertices.length;
                    pw.print(a + "/" + a + "/" + a + " ");
                }
                pw.println();
            }
            pw.flush();
        }
    }
}

