/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.util;

import edu.cmu.cs.dennisc.lang.ThreadUtilities;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.AngleInRevolutions;
import edu.cmu.cs.dennisc.math.Tuple3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.scenegraph.Transformable;

@Deprecated
public class AffineAnimation {
    private static final long SLEEP_MSEC = 25L;
    private static long s_t0 = System.currentTimeMillis();

    private static void waitForLookingGlass() {
        ThreadUtilities.sleep(25L);
    }

    private static double getCurrentTime() {
        return (double)(System.currentTimeMillis() - s_t0) * 0.001;
    }

    public static void setTranslation(Transformable transformable, double x, double y, double z, double rate) {
        double zDelta;
        double yDelta;
        double xDelta;
        double distance;
        double t0 = AffineAnimation.getCurrentTime();
        AffineMatrix4x4 m = transformable.getLocalTransformation();
        double x0 = m.translation.x;
        double y0 = m.translation.y;
        double z0 = m.translation.z;
        if (Double.isNaN(x)) {
            x = x0;
        }
        if (Double.isNaN(y)) {
            y = y0;
        }
        if (Double.isNaN(z)) {
            z = z0;
        }
        if ((distance = Tuple3.calculateMagnitude(xDelta = x - x0, yDelta = y - y0, zDelta = z - z0)) != 0.0) {
            double tCurr;
            double xRate = rate * xDelta / distance;
            double yRate = rate * yDelta / distance;
            double zRate = rate * zDelta / distance;
            double duration = distance / rate;
            double tComplete = t0 + duration;
            while (!((tCurr = AffineAnimation.getCurrentTime()) > tComplete)) {
                double tDelta = tCurr - t0;
                m.translation.set(x0 + xRate * tDelta, y0 + yRate * tDelta, z0 + zRate * tDelta);
                transformable.setLocalTransformation(m);
                AffineAnimation.waitForLookingGlass();
            }
            m.translation.set(x, y, z);
            transformable.setLocalTransformation(m);
            AffineAnimation.waitForLookingGlass();
        }
    }

    private static void rotate(Transformable transformable, Vector3 axis, double angleInRevolutions, double duration) {
        double tCurr;
        double t0 = AffineAnimation.getCurrentTime();
        double tComplete = t0 + duration;
        double angleSum = 0.0;
        while (!((tCurr = AffineAnimation.getCurrentTime()) > tComplete)) {
            double tDelta = tCurr - t0;
            double tPortion = tDelta / duration;
            double anglePortion = angleInRevolutions * tPortion - angleSum;
            transformable.applyRotationAboutArbitraryAxis(axis, new AngleInRevolutions(anglePortion));
            angleSum += anglePortion;
            AffineAnimation.waitForLookingGlass();
        }
        transformable.applyRotationAboutArbitraryAxis(axis, new AngleInRevolutions(angleInRevolutions - angleSum));
        AffineAnimation.waitForLookingGlass();
    }

    public static void turnLeft(Transformable transformable, double angleInRevolutions, double duration) {
        AffineAnimation.rotate(transformable, Vector3.accessPositiveYAxis(), angleInRevolutions, duration);
    }

    public static void turnRight(Transformable transformable, double angleInRevolutions, double duration) {
        AffineAnimation.turnLeft(transformable, -angleInRevolutions, duration);
    }

    public static void turnForward(Transformable transformable, double angleInRevolutions, double duration) {
        AffineAnimation.rotate(transformable, Vector3.accessPositiveXAxis(), angleInRevolutions, duration);
    }

    public static void turnBackward(Transformable transformable, double angleInRevolutions, double duration) {
        AffineAnimation.turnForward(transformable, -angleInRevolutions, duration);
    }

    public static void rollLeft(Transformable transformable, double angleInRevolutions, double duration) {
        AffineAnimation.rotate(transformable, Vector3.accessPositiveZAxis(), angleInRevolutions, duration);
    }

    public static void rollRight(Transformable transformable, double angleInRevolutions, double duration) {
        AffineAnimation.rollLeft(transformable, -angleInRevolutions, duration);
    }
}

