/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.util;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.Angle;
import edu.cmu.cs.dennisc.math.Sphere;
import edu.cmu.cs.dennisc.scenegraph.Component;
import edu.cmu.cs.dennisc.scenegraph.ReferenceFrame;

public abstract class CameraUtilities {
    public static AffineMatrix4x4 calculateGoodLookAt(AffineMatrix4x4 rv, Angle smallerViewingAngle, Component sgTarget, Sphere sphere, ReferenceFrame sgAsSeenBy) {
        sgTarget.getTransformation(rv, sgAsSeenBy);
        double thetaInRadians = smallerViewingAngle.getAsRadians();
        double distance = sphere.radius / Math.sin(thetaInRadians / 2.0);
        rv.applyTranslationAlongZAxis(distance);
        return rv;
    }

    public static AffineMatrix4x4 calculateGoodLookAt(Angle smallerViewingAngle, Component sgTarget, Sphere sphere, ReferenceFrame sgAsSeenBy) {
        return CameraUtilities.calculateGoodLookAt(AffineMatrix4x4.createNaN(), smallerViewingAngle, sgTarget, sphere, sgAsSeenBy);
    }
}

