/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.util;

import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.math.ForwardAndUpGuide;
import edu.cmu.cs.dennisc.math.OrthogonalMatrix3x3;
import edu.cmu.cs.dennisc.math.Point3;
import edu.cmu.cs.dennisc.math.Vector3;
import edu.cmu.cs.dennisc.math.Vector3f;
import edu.cmu.cs.dennisc.math.polynomial.HermiteCubic;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.IndexedQuadrilateralArray;
import edu.cmu.cs.dennisc.scenegraph.Vertex;
import edu.cmu.cs.dennisc.scenegraph.util.Connection;

public class ExtravagantConnection
extends Connection {
    private double m_radius = Double.NaN;
    private static final int DISC_COUNT = 12;
    private static final int CUBIC_COUNT = 24;
    private IndexedQuadrilateralArray m_sgIQA = new IndexedQuadrilateralArray();
    private Point3[] m_points = new Point3[12];
    private Vector3f[] m_normals = new Vector3f[12];
    private OrthogonalMatrix3x3 m_mBuffer = OrthogonalMatrix3x3.createNaN();
    private Vector3 m_vBuffer = Vector3.createNaN();

    public ExtravagantConnection() {
        Vertex[] vertices = new Vertex[288];
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = Vertex.createXYZIJK(0.0, 0.0, 0.0, 0.0f, 1.0f, 0.0f);
        }
        int[] quadData = new int[1104];
        int lcv = 0;
        for (int c = 0; c < 23; ++c) {
            int c0 = c * 12;
            int c1 = (c + 1) * 12;
            for (int d = 0; d < 12; ++d) {
                quadData[lcv++] = c1 + d;
                if (d == 11) {
                    quadData[lcv++] = c1;
                    quadData[lcv++] = c0;
                } else {
                    quadData[lcv++] = c1 + d + 1;
                    quadData[lcv++] = c0 + d + 1;
                }
                quadData[lcv++] = c0 + d;
            }
        }
        this.m_sgIQA.vertices.setValue(vertices);
        this.m_sgIQA.polygonData.setValue(quadData);
        for (int d = 0; d < 12; ++d) {
            this.m_points[d] = new Point3();
            this.m_normals[d] = new Vector3f();
        }
        this.setRadius(1.0);
        this.geometries.setValue(new Geometry[]{this.m_sgIQA});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Vertex[] vertices;
        AffineMatrix4x4 m = this.getTarget().getTransformation(this);
        double s = m.translation.calculateMagnitude();
        HermiteCubic xHermiteCubic = new HermiteCubic(0.0, m.translation.x, 0.0, -(s *= 5.0) * m.orientation.backward.x);
        HermiteCubic yHermiteCubic = new HermiteCubic(0.0, m.translation.y, 0.0, -s * m.orientation.backward.y);
        HermiteCubic zHermiteCubic = new HermiteCubic(0.0, m.translation.z, -1.0, -s * m.orientation.backward.z);
        Vertex[] vertexArray = vertices = (Vertex[])this.m_sgIQA.vertices.getValue();
        synchronized (vertices) {
            double tDelta;
            double t = tDelta = 0.041666666666666664;
            int lcv = 0;
            for (int c = 0; c < 24; ++c) {
                double x = xHermiteCubic.evaluate(t);
                double y = yHermiteCubic.evaluate(t);
                double z = zHermiteCubic.evaluate(t);
                this.m_vBuffer.set(zHermiteCubic.evaluateDerivative(t), yHermiteCubic.evaluateDerivative(t), zHermiteCubic.evaluateDerivative(t));
                this.m_vBuffer.normalize();
                Vector3 upGuide = Vector3.isWithinEpsilonOfPositiveOrNegativeYAxis(this.m_vBuffer, 0.01) ? Vector3.accessPositiveZAxis() : Vector3.accessPositiveYAxis();
                this.m_mBuffer.setValue(new ForwardAndUpGuide(this.m_vBuffer, upGuide));
                for (int d = 0; d < 12; ++d) {
                    vertices[lcv].position.set(this.m_points[d]);
                    this.m_mBuffer.transform(vertices[lcv].position);
                    vertices[lcv].position.add(new Point3(x, y, z));
                    vertices[lcv].normal.set(this.m_normals[d]);
                    this.m_mBuffer.transform(vertices[lcv].normal);
                    ++lcv;
                }
                t += tDelta;
            }
            this.m_sgIQA.vertices.touch();
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return;
        }
    }

    public double getRadius() {
        return this.m_radius;
    }

    public void setRadius(double baseRadius) {
        if (this.m_radius != baseRadius) {
            this.m_radius = baseRadius;
            double theta = 0.0;
            double thetaDelta = 0.5235987755982988;
            for (int d = 0; d < 12; ++d) {
                double c = Math.cos(theta);
                double s = Math.sin(theta);
                this.m_points[d].set(this.m_radius * c, this.m_radius * s, 0.0);
                this.m_normals[d].set((float)s, (float)c, 0.0f);
                theta += thetaDelta;
            }
        }
    }
}

