/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.dennisc.scenegraph.util;

import edu.cmu.cs.dennisc.color.Color4f;
import edu.cmu.cs.dennisc.math.AffineMatrix4x4;
import edu.cmu.cs.dennisc.scenegraph.Appearance;
import edu.cmu.cs.dennisc.scenegraph.Cylinder;
import edu.cmu.cs.dennisc.scenegraph.Geometry;
import edu.cmu.cs.dennisc.scenegraph.Sphere;
import edu.cmu.cs.dennisc.scenegraph.util.ModelTransformable;
import edu.cmu.cs.dennisc.scenegraph.util.ModelVisual;

public class Limb
extends ModelTransformable {
    private ModelTransformable m_sgB = new ModelTransformable();
    private ModelTransformable m_sgC = new ModelTransformable();

    public Limb(double abLength, double bcLength, double ctLength) {
        double sphereRadius = Math.min(abLength, Math.min(bcLength, ctLength)) * 0.25;
        double cylinderRadius = sphereRadius * 0.5;
        this.m_sgB.setLocalTransformation(AffineMatrix4x4.createTranslation(0.0, 0.0, abLength));
        this.m_sgC.setLocalTransformation(AffineMatrix4x4.createTranslation(0.0, 0.0, bcLength));
        Sphere sgSphere = new Sphere();
        sgSphere.radius.setValue(sphereRadius);
        this.getSGVisual().geometries.setValue(new Geometry[]{sgSphere});
        this.m_sgB.getSGVisual().geometries.setValue(new Geometry[]{sgSphere});
        this.m_sgC.getSGVisual().geometries.setValue(new Geometry[]{sgSphere});
        ((Appearance)this.getSGVisual().frontFacingAppearance.getValue()).setDiffuseColor(Color4f.RED);
        ((Appearance)this.m_sgB.getSGVisual().frontFacingAppearance.getValue()).setDiffuseColor(Color4f.GREEN);
        ((Appearance)this.m_sgC.getSGVisual().frontFacingAppearance.getValue()).setDiffuseColor(Color4f.BLUE);
        ModelVisual sgVisualAB = new ModelVisual();
        ModelVisual sgVisualBC = new ModelVisual();
        ModelVisual sgVisualCT = new ModelVisual();
        Cylinder sgCylinderAB = new Cylinder();
        Cylinder sgCylinderBC = new Cylinder();
        Cylinder sgCylinderCT = new Cylinder();
        sgCylinderAB.topRadius.setValue(cylinderRadius);
        sgCylinderAB.bottomRadius.setValue(cylinderRadius);
        sgCylinderAB.originAlignment.setValue(Cylinder.OriginAlignment.BOTTOM);
        sgCylinderAB.bottomToTopAxis.setValue(Cylinder.BottomToTopAxis.POSITIVE_Z);
        sgCylinderAB.length.setValue(abLength);
        sgCylinderBC.topRadius.setValue(cylinderRadius);
        sgCylinderBC.bottomRadius.setValue(cylinderRadius);
        sgCylinderBC.originAlignment.setValue(Cylinder.OriginAlignment.BOTTOM);
        sgCylinderBC.bottomToTopAxis.setValue(Cylinder.BottomToTopAxis.POSITIVE_Z);
        sgCylinderBC.length.setValue(bcLength);
        sgCylinderCT.topRadius.setValue(0.0);
        sgCylinderCT.bottomRadius.setValue(cylinderRadius);
        sgCylinderCT.originAlignment.setValue(Cylinder.OriginAlignment.BOTTOM);
        sgCylinderCT.bottomToTopAxis.setValue(Cylinder.BottomToTopAxis.POSITIVE_Z);
        sgCylinderCT.length.setValue(ctLength);
        ((Appearance)sgVisualAB.frontFacingAppearance.getValue()).setDiffuseColor(Color4f.YELLOW);
        ((Appearance)sgVisualBC.frontFacingAppearance.getValue()).setDiffuseColor(Color4f.CYAN);
        ((Appearance)sgVisualCT.frontFacingAppearance.getValue()).setDiffuseColor(Color4f.WHITE);
        sgVisualAB.geometries.setValue(new Geometry[]{sgCylinderAB});
        sgVisualAB.setParent(this);
        sgVisualBC.geometries.setValue(new Geometry[]{sgCylinderBC});
        sgVisualBC.setParent(this.m_sgB);
        sgVisualCT.geometries.setValue(new Geometry[]{sgCylinderCT});
        sgVisualCT.setParent(this.m_sgC);
        this.m_sgC.setParent(this.m_sgB);
        this.m_sgB.setParent(this);
    }
}

